/*
 * Decompiled with CFR 0.152.
 */
package com.github.zhkl0228.impersonator;

import com.github.zhkl0228.impersonator.ImpersonatorApi;
import com.github.zhkl0228.impersonator.ImpersonatorFactory;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import okhttp3.Http2Connection;
import org.bouncycastle.tls.KeyShareEntry;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsExtensionsUtils;
import org.bouncycastle.tls.TlsUtils;

class MacSafari
extends ImpersonatorFactory {
    private final Type type;

    static ImpersonatorApi newMacSafari() {
        return new MacSafari(Type.MacSafari, "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/17.6 Safari/605.1.15");
    }

    static ImpersonatorApi newIOS() {
        return new MacSafari(Type.iOS, "Mozilla/5.0 (iPhone; CPU iPhone OS 17_5 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/126.0.6478.108 Mobile/15E148 Safari/604.1");
    }

    private MacSafari(Type type, String userAgent) {
        super("GREASE-4865-4866-4867-49196-49195-52393-49200-49199-52392-49162-49161-49172-49171-157-156-53-47-49160-49170-10", userAgent);
        this.type = type;
    }

    @Override
    public void fillRequestHeaders(Map<String, String> headers) {
        Locale locale = Locale.getDefault();
        headers.put("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        headers.put("Accept-Language", String.format("%s,%s;q=0.5", locale.toString().replace('_', '-'), locale.getLanguage()));
        headers.put("Sec-Fetch-Dest", "document");
        headers.put("Sec-Fetch-Mode", "navigate");
        headers.put("Sec-Fetch-Site", "none");
    }

    @Override
    public void onHttp2ConnectionInit(Http2Connection http2Connection) {
        http2Connection.removeSetting(7);
        switch (this.type) {
            case MacSafari: {
                http2Connection.setSetting(7, 0x400000);
                http2Connection.setSetting(4, 100);
                http2Connection.setWindowSizeIncrement(0xA00000L);
                http2Connection.setHeaderOrder("m,s,p,a");
                break;
            }
            case iOS: {
                http2Connection.setSetting(2, 0);
                http2Connection.setSetting(7, 0x200000);
                http2Connection.setSetting(4, 100);
                http2Connection.setWindowSizeIncrement(0xA00000L);
                http2Connection.setHeaderOrder("m,s,p,a");
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported type: " + (Object)((Object)this.type));
            }
        }
    }

    @Override
    protected void onSendClientHelloMessageInternal(Map<Integer, byte[]> clientExtensions) throws IOException {
        clientExtensions.put(18, TlsUtils.EMPTY_BYTES);
        this.addSignatureAlgorithmsExtension(clientExtensions, SignatureAndHashAlgorithm.create(1027), SignatureAndHashAlgorithm.rsa_pss_rsae_sha256, SignatureAndHashAlgorithm.create(1025), SignatureAndHashAlgorithm.create(1283), SignatureAndHashAlgorithm.create(515), SignatureAndHashAlgorithm.rsa_pss_rsae_sha384, SignatureAndHashAlgorithm.rsa_pss_rsae_sha384, SignatureAndHashAlgorithm.create(1281), SignatureAndHashAlgorithm.rsa_pss_rsae_sha512, SignatureAndHashAlgorithm.create(1537), SignatureAndHashAlgorithm.create(513));
        int supportedGroupGrease = MacSafari.randomGrease();
        this.addSupportedGroupsExtension(clientExtensions, supportedGroupGrease, 29, 23, 24, 25);
        this.randomSupportedVersionsExtension(clientExtensions, ProtocolVersion.TLSv13, ProtocolVersion.TLSv12, ProtocolVersion.TLSv11, ProtocolVersion.TLSv10);
        Vector<KeyShareEntry> keyShareEntries = TlsExtensionsUtils.getKeyShareClientHello(clientExtensions);
        if (keyShareEntries != null) {
            keyShareEntries.add(0, new KeyShareEntry(supportedGroupGrease, new byte[1]));
            TlsExtensionsUtils.addKeyShareClientHello(clientExtensions, keyShareEntries);
        }
        TlsExtensionsUtils.addPaddingExtension(clientExtensions, 0);
        TlsExtensionsUtils.addCompressCertificateExtension(clientExtensions, new int[]{1});
        TlsExtensionsUtils.addPSKKeyExchangeModesExtension(clientExtensions, new short[]{1});
        MacSafari.randomExtension(clientExtensions, "0-23-65281-10-11-16-5-13-18-51-45-43-27-21", true);
    }

    private static enum Type {
        MacSafari,
        iOS;

    }
}

