/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import com.github.zhkl0228.impersonator.Impersonator;
import org.bouncycastle.jsse.provider.ContextData;
import org.bouncycastle.jsse.provider.ImpersonateSSLSocketWrap;
import org.bouncycastle.jsse.provider.ImpersonateTlsClient;
import org.bouncycastle.jsse.provider.ImpersonateTlsClientProtocol;
import org.bouncycastle.jsse.provider.ProvSSLEngine;
import org.bouncycastle.jsse.provider.ProvSSLParameters;
import org.bouncycastle.jsse.provider.ProvTlsClient;
import org.bouncycastle.tls.TlsClientProtocol;

class ImpersonateSSLEngine
extends ProvSSLEngine {
    private final Impersonator impersonator;

    ImpersonateSSLEngine(ContextData contextData, String peerHost, int peerPort, Impersonator impersonator) {
        super(contextData, peerHost, peerPort);
        this.impersonator = impersonator;
    }

    @Override
    protected TlsClientProtocol newTlsClientProtocol() {
        return new ImpersonateTlsClientProtocol(this.impersonator);
    }

    @Override
    protected ProvTlsClient newProvTlsClient(ProvSSLParameters sslParameters) {
        int[] cipherSuites = this.impersonator.getCipherSuites();
        ImpersonateSSLSocketWrap.checkCipherSuites(this.contextData, cipherSuites);
        return new ImpersonateTlsClient(this, sslParameters, cipherSuites);
    }
}

