/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.security.AlgorithmParameters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import org.bouncycastle.jsse.java.security.BCAlgorithmConstraints;
import org.bouncycastle.jsse.java.security.BCCryptoPrimitive;
import org.bouncycastle.jsse.provider.FipsUtils;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.PropertyUtils;
import org.bouncycastle.jsse.provider.ProvSSLParameters;
import org.bouncycastle.tls.NamedGroup;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Integers;
import org.bouncycastle.util.Properties;

class NamedGroupInfo {
    private static final Logger LOG = Logger.getLogger(NamedGroupInfo.class.getName());
    private static final String PROPERTY_NAMED_GROUPS = "jdk.tls.namedGroups";
    private static final int[] CANDIDATES_DEFAULT = new int[]{29, 30, 23, 24, 25, 31, 32, 33, 256, 257, 258};
    private final All all;
    private final AlgorithmParameters algorithmParameters;
    private final boolean enabled;

    static PerConnection createPerConnectionClient(PerContext perContext, ProvSSLParameters sslParameters, ProtocolVersion[] activeProtocolVersions) {
        ProtocolVersion latest = ProtocolVersion.getLatestTLS(activeProtocolVersions);
        ProtocolVersion earliest = ProtocolVersion.getEarliestTLS(activeProtocolVersions);
        return NamedGroupInfo.createPerConnection(perContext, sslParameters, earliest, latest);
    }

    static PerConnection createPerConnectionServer(PerContext perContext, ProvSSLParameters sslParameters, ProtocolVersion negotiatedVersion) {
        return NamedGroupInfo.createPerConnection(perContext, sslParameters, negotiatedVersion, negotiatedVersion);
    }

    private static PerConnection createPerConnection(PerContext perContext, ProvSSLParameters sslParameters, ProtocolVersion earliest, ProtocolVersion latest) {
        String[] namedGroups = sslParameters.getNamedGroups();
        int[] candidates = namedGroups == null ? perContext.candidates : NamedGroupInfo.createCandidates(perContext.index, namedGroups, "SSLParameters.namedGroups");
        BCAlgorithmConstraints algorithmConstraints = sslParameters.getAlgorithmConstraints();
        boolean post13Active = TlsUtils.isTLSv13(latest);
        boolean pre13Active = !TlsUtils.isTLSv13(earliest);
        int count = candidates.length;
        LinkedHashMap<Integer, NamedGroupInfo> local = new LinkedHashMap<Integer, NamedGroupInfo>(count);
        for (int i = 0; i < count; ++i) {
            Integer candidate = Integers.valueOf((int)candidates[i]);
            NamedGroupInfo namedGroupInfo = (NamedGroupInfo)perContext.index.get(candidate);
            if (null == namedGroupInfo || !namedGroupInfo.isActive(algorithmConstraints, post13Active, pre13Active)) continue;
            local.put(candidate, namedGroupInfo);
        }
        boolean localECDSA = NamedGroupInfo.hasAnyECDSA(local);
        return new PerConnection(local, localECDSA);
    }

    static PerContext createPerContext(boolean isFipsContext, JcaTlsCrypto crypto) {
        Map<Integer, NamedGroupInfo> index = NamedGroupInfo.createIndex(isFipsContext, crypto);
        int[] candidates = NamedGroupInfo.createCandidatesFromProperty(index, PROPERTY_NAMED_GROUPS);
        return new PerContext(index, candidates);
    }

    static DefaultedResult getMaximumBitsServerECDH(PerConnection perConnection) {
        int maxBits = 0;
        List<NamedGroupInfo> peer = perConnection.getPeer();
        if (peer != null) {
            for (NamedGroupInfo namedGroupInfo : peer) {
                int bits = namedGroupInfo.getBitsECDH();
                if (bits <= maxBits || !perConnection.local.containsKey(namedGroupInfo.getNamedGroup())) continue;
                maxBits = bits;
            }
        } else {
            for (NamedGroupInfo namedGroupInfo : perConnection.local.values()) {
                maxBits = Math.max(maxBits, namedGroupInfo.getBitsECDH());
            }
        }
        return new DefaultedResult(maxBits, peer == null);
    }

    static DefaultedResult getMaximumBitsServerFFDHE(PerConnection perConnection) {
        int maxBits = 0;
        boolean anyPeerFF = false;
        List<NamedGroupInfo> peer = perConnection.getPeer();
        if (peer != null) {
            for (NamedGroupInfo namedGroupInfo : peer) {
                int namedGroup = namedGroupInfo.getNamedGroup();
                anyPeerFF |= NamedGroup.isFiniteField(namedGroup);
                int bits = namedGroupInfo.getBitsFFDHE();
                if (bits <= maxBits || !perConnection.local.containsKey(namedGroup)) continue;
                maxBits = bits;
            }
        }
        if (!anyPeerFF) {
            for (NamedGroupInfo namedGroupInfo : perConnection.local.values()) {
                maxBits = Math.max(maxBits, namedGroupInfo.getBitsFFDHE());
            }
        }
        return new DefaultedResult(maxBits, !anyPeerFF);
    }

    static NamedGroupInfo getNamedGroup(PerContext perContext, int namedGroup) {
        return (NamedGroupInfo)perContext.index.get(namedGroup);
    }

    static Vector<Integer> getSupportedGroupsLocalClient(PerConnection perConnection) {
        return new Vector<Integer>(perConnection.local.keySet());
    }

    static int[] getSupportedGroupsLocalServer(PerConnection perConnection) {
        Set keys = perConnection.local.keySet();
        int count = keys.size();
        int pos = 0;
        int[] result = new int[count];
        for (Integer key : keys) {
            result[pos++] = key;
        }
        return result;
    }

    static boolean hasAnyECDSALocal(PerConnection perConnection) {
        return perConnection.localECDSA;
    }

    static boolean hasLocal(PerConnection perConnection, int namedGroup) {
        return perConnection.local.containsKey(namedGroup);
    }

    static DefaultedResult selectServerECDH(PerConnection perConnection, int minimumBitsECDH) {
        List<NamedGroupInfo> peer = perConnection.getPeer();
        if (peer != null) {
            for (NamedGroupInfo namedGroupInfo : peer) {
                if (namedGroupInfo.getBitsECDH() < minimumBitsECDH) continue;
                int namedGroup = namedGroupInfo.getNamedGroup();
                if (!perConnection.local.containsKey(namedGroup)) continue;
                return new DefaultedResult(namedGroup, false);
            }
        } else {
            for (NamedGroupInfo namedGroupInfo : perConnection.local.values()) {
                if (namedGroupInfo.getBitsECDH() < minimumBitsECDH) continue;
                return new DefaultedResult(namedGroupInfo.getNamedGroup(), true);
            }
        }
        return new DefaultedResult(-1, peer == null);
    }

    static DefaultedResult selectServerFFDHE(PerConnection perConnection, int minimumBitsFFDHE) {
        boolean anyPeerFF = false;
        List<NamedGroupInfo> peer = perConnection.getPeer();
        if (peer != null) {
            for (NamedGroupInfo namedGroupInfo : peer) {
                int namedGroup = namedGroupInfo.getNamedGroup();
                anyPeerFF |= NamedGroup.isFiniteField(namedGroup);
                if (namedGroupInfo.getBitsFFDHE() < minimumBitsFFDHE || !perConnection.local.containsKey(namedGroup)) continue;
                return new DefaultedResult(namedGroup, false);
            }
        }
        if (!anyPeerFF) {
            for (NamedGroupInfo namedGroupInfo : perConnection.local.values()) {
                if (namedGroupInfo.getBitsFFDHE() < minimumBitsFFDHE) continue;
                return new DefaultedResult(namedGroupInfo.getNamedGroup(), true);
            }
        }
        return new DefaultedResult(-1, !anyPeerFF);
    }

    private static void addNamedGroup(boolean isFipsContext, JcaTlsCrypto crypto, boolean disableChar2, boolean disableFFDHE, Map<Integer, NamedGroupInfo> ng, All all) {
        int namedGroup = all.namedGroup;
        if (isFipsContext && !FipsUtils.isFipsNamedGroup(namedGroup)) {
            return;
        }
        boolean disable = disableChar2 && all.char2 || disableFFDHE && all.bitsFFDHE > 0;
        boolean enabled = !disable && null != all.jcaGroup && crypto.hasNamedGroup(namedGroup);
        AlgorithmParameters algorithmParameters = null;
        if (enabled) {
            try {
                algorithmParameters = crypto.getNamedGroupAlgorithmParameters(namedGroup);
            }
            catch (Exception e) {
                enabled = false;
            }
        }
        NamedGroupInfo namedGroupInfo = new NamedGroupInfo(all, algorithmParameters, enabled);
        if (null != ng.put(namedGroup, namedGroupInfo)) {
            throw new IllegalStateException("Duplicate entries for NamedGroupInfo");
        }
    }

    private static int[] createCandidatesFromProperty(Map<Integer, NamedGroupInfo> index, String propertyName) {
        String[] names = PropertyUtils.getStringArraySystemProperty(propertyName);
        if (null == names) {
            return CANDIDATES_DEFAULT;
        }
        return NamedGroupInfo.createCandidates(index, names, propertyName);
    }

    private static int[] createCandidates(Map<Integer, NamedGroupInfo> index, String[] names, String description) {
        int[] result = new int[names.length];
        int count = 0;
        for (String name : names) {
            int namedGroup = NamedGroupInfo.getNamedGroupByName(name);
            if (namedGroup < 0) {
                LOG.warning("'" + description + "' contains unrecognised NamedGroup: " + name);
                continue;
            }
            NamedGroupInfo namedGroupInfo = index.get(namedGroup);
            if (null == namedGroupInfo) {
                LOG.warning("'" + description + "' contains unsupported NamedGroup: " + name);
                continue;
            }
            if (!namedGroupInfo.isEnabled()) {
                LOG.warning("'" + description + "' contains disabled NamedGroup: " + name);
                continue;
            }
            result[count++] = namedGroup;
        }
        if (count < result.length) {
            result = Arrays.copyOf((int[])result, (int)count);
        }
        if (result.length < 1) {
            LOG.severe("'" + description + "' contained no usable NamedGroup values");
        }
        return result;
    }

    private static Map<Integer, NamedGroupInfo> createIndex(boolean isFipsContext, JcaTlsCrypto crypto) {
        TreeMap<Integer, NamedGroupInfo> ng = new TreeMap<Integer, NamedGroupInfo>();
        boolean disableChar2 = PropertyUtils.getBooleanSystemProperty("org.bouncycastle.jsse.ec.disableChar2", false) || Properties.isOverrideSet((String)"org.bouncycastle.ec.disable_f2m");
        boolean disableFFDHE = !PropertyUtils.getBooleanSystemProperty("jsse.enableFFDHE", true);
        for (All all : All.values()) {
            NamedGroupInfo.addNamedGroup(isFipsContext, crypto, disableChar2, disableFFDHE, ng, all);
        }
        return ng;
    }

    private static int getNamedGroupByName(String name) {
        for (All all : All.values()) {
            if (!all.name.equalsIgnoreCase(name)) continue;
            return all.namedGroup;
        }
        return -1;
    }

    private static List<NamedGroupInfo> getNamedGroupInfos(Map<Integer, NamedGroupInfo> namedGroupInfos, int[] namedGroups) {
        if (namedGroups == null) {
            return null;
        }
        if (namedGroups.length < 1) {
            return Collections.emptyList();
        }
        int count = namedGroups.length;
        ArrayList<NamedGroupInfo> result = new ArrayList<NamedGroupInfo>(count);
        for (int i = 0; i < count; ++i) {
            int namedGroup = namedGroups[i];
            NamedGroupInfo namedGroupInfo = namedGroupInfos.get(namedGroup);
            if (null == namedGroupInfo) continue;
            result.add(namedGroupInfo);
        }
        if (result.isEmpty()) {
            return Collections.emptyList();
        }
        result.trimToSize();
        return result;
    }

    private static boolean hasAnyECDSA(Map<Integer, NamedGroupInfo> local) {
        for (NamedGroupInfo namedGroupInfo : local.values()) {
            if (!NamedGroup.refersToAnECDSACurve(namedGroupInfo.getNamedGroup())) continue;
            return true;
        }
        return false;
    }

    NamedGroupInfo(All all, AlgorithmParameters algorithmParameters, boolean enabled) {
        this.all = all;
        this.algorithmParameters = algorithmParameters;
        this.enabled = enabled;
    }

    int getBitsECDH() {
        return this.all.bitsECDH;
    }

    int getBitsFFDHE() {
        return this.all.bitsFFDHE;
    }

    String getJcaAlgorithm() {
        return this.all.jcaAlgorithm;
    }

    String getJcaGroup() {
        return this.all.jcaGroup;
    }

    int getNamedGroup() {
        return this.all.namedGroup;
    }

    boolean isActive(BCAlgorithmConstraints algorithmConstraints, boolean post13Active, boolean pre13Active) {
        return this.enabled && (post13Active && this.isSupportedPost13() || pre13Active && this.isSupportedPre13()) && this.isPermittedBy(algorithmConstraints);
    }

    boolean isEnabled() {
        return this.enabled;
    }

    boolean isSupportedPost13() {
        return this.all.supportedPost13;
    }

    boolean isSupportedPre13() {
        return this.all.supportedPre13;
    }

    public String toString() {
        return this.all.text;
    }

    private boolean isPermittedBy(BCAlgorithmConstraints algorithmConstraints) {
        Set<BCCryptoPrimitive> primitives = JsseUtils.KEY_AGREEMENT_CRYPTO_PRIMITIVES_BC;
        return algorithmConstraints.permits(primitives, this.getJcaGroup(), null) && algorithmConstraints.permits(primitives, this.getJcaAlgorithm(), this.algorithmParameters);
    }

    static class DefaultedResult {
        private final int result;
        private final boolean defaulted;

        DefaultedResult(int result, boolean defaulted) {
            this.result = result;
            this.defaulted = defaulted;
        }

        int getResult() {
            return this.result;
        }

        boolean isDefaulted() {
            return this.defaulted;
        }
    }

    static class PerContext {
        private final Map<Integer, NamedGroupInfo> index;
        private final int[] candidates;

        PerContext(Map<Integer, NamedGroupInfo> index, int[] candidates) {
            this.index = index;
            this.candidates = candidates;
        }
    }

    static class PerConnection {
        private final LinkedHashMap<Integer, NamedGroupInfo> local;
        private final boolean localECDSA;
        private final AtomicReference<List<NamedGroupInfo>> peer;

        PerConnection(LinkedHashMap<Integer, NamedGroupInfo> local, boolean localECDSA) {
            if (local == null) {
                throw new NullPointerException("local");
            }
            this.local = local;
            this.localECDSA = localECDSA;
            this.peer = new AtomicReference();
        }

        List<NamedGroupInfo> getPeer() {
            return this.peer.get();
        }

        void notifyPeerData(int[] namedGroups) {
            List namedGroupInfos = NamedGroupInfo.getNamedGroupInfos(this.local, namedGroups);
            this.peer.set(namedGroupInfos);
        }
    }

    private static enum All {
        sect163k1(1, "EC"),
        sect163r1(2, "EC"),
        sect163r2(3, "EC"),
        sect193r1(4, "EC"),
        sect193r2(5, "EC"),
        sect233k1(6, "EC"),
        sect233r1(7, "EC"),
        sect239k1(8, "EC"),
        sect283k1(9, "EC"),
        sect283r1(10, "EC"),
        sect409k1(11, "EC"),
        sect409r1(12, "EC"),
        sect571k1(13, "EC"),
        sect571r1(14, "EC"),
        secp160k1(15, "EC"),
        secp160r1(16, "EC"),
        secp160r2(17, "EC"),
        secp192k1(18, "EC"),
        secp192r1(19, "EC"),
        secp224k1(20, "EC"),
        secp224r1(21, "EC"),
        secp256k1(22, "EC"),
        secp256r1(23, "EC"),
        secp384r1(24, "EC"),
        secp521r1(25, "EC"),
        brainpoolP256r1(26, "EC"),
        brainpoolP384r1(27, "EC"),
        brainpoolP512r1(28, "EC"),
        x25519(29, "XDH"),
        x448(30, "XDH"),
        brainpoolP256r1tls13(31, "EC"),
        brainpoolP384r1tls13(32, "EC"),
        brainpoolP512r1tls13(33, "EC"),
        curveSM2(41, "EC"),
        ffdhe2048(256, "DiffieHellman"),
        ffdhe3072(257, "DiffieHellman"),
        ffdhe4096(258, "DiffieHellman"),
        ffdhe6144(259, "DiffieHellman"),
        ffdhe8192(260, "DiffieHellman"),
        OQS_mlkem512(583, "ML-KEM"),
        OQS_mlkem768(584, "ML-KEM"),
        OQS_mlkem1024(585, "ML-KEM"),
        DRAFT_mlkem768(1896, "ML-KEM"),
        DRAFT_mlkem1024(4132, "ML-KEM");

        private final int namedGroup;
        private final String name;
        private final String text;
        private final String jcaAlgorithm;
        private final String jcaGroup;
        private final boolean char2;
        private final boolean supportedPost13;
        private final boolean supportedPre13;
        private final int bitsECDH;
        private final int bitsFFDHE;

        private All(int namedGroup, String jcaAlgorithm) {
            this.namedGroup = namedGroup;
            this.name = NamedGroup.getName(namedGroup);
            this.text = NamedGroup.getText(namedGroup);
            this.jcaAlgorithm = jcaAlgorithm;
            this.jcaGroup = NamedGroup.getStandardName(namedGroup);
            this.supportedPost13 = NamedGroup.canBeNegotiated(namedGroup, ProtocolVersion.TLSv13);
            this.supportedPre13 = NamedGroup.canBeNegotiated(namedGroup, ProtocolVersion.TLSv12);
            this.char2 = NamedGroup.isChar2Curve(namedGroup);
            this.bitsECDH = NamedGroup.getCurveBits(namedGroup);
            this.bitsFFDHE = NamedGroup.getFiniteFieldBits(namedGroup);
        }
    }
}

