/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.util.Date;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.cert.CertificateEncodingException;
import javax.security.cert.CertificateException;
import javax.security.cert.CertificateExpiredException;
import javax.security.cert.CertificateNotYetValidException;
import javax.security.cert.X509Certificate;
import org.bouncycastle.jsse.BCExtendedSSLSession;

class OldCertUtil {
    OldCertUtil() {
    }

    static X509Certificate[] getPeerCertificateChain(BCExtendedSSLSession sslSession) throws SSLPeerUnverifiedException {
        boolean isFips = sslSession.isFipsMode();
        Certificate[] peerCertificates = sslSession.getPeerCertificates();
        X509Certificate[] result = new X509Certificate[peerCertificates.length];
        int count = 0;
        try {
            for (int i = 0; i < peerCertificates.length; ++i) {
                Certificate peerCertificate = peerCertificates[i];
                if (!(peerCertificate instanceof java.security.cert.X509Certificate)) continue;
                java.security.cert.X509Certificate peerX509Certificate = (java.security.cert.X509Certificate)peerCertificate;
                result[count++] = isFips ? new X509CertificateWrapper(peerX509Certificate) : X509Certificate.getInstance(peerX509Certificate.getEncoded());
            }
        }
        catch (Exception e) {
            throw new SSLPeerUnverifiedException(e.getMessage());
        }
        if (count >= result.length) {
            return result;
        }
        X509Certificate[] tmp = new X509Certificate[count];
        System.arraycopy(result, 0, tmp, 0, count);
        return tmp;
    }

    private static class X509CertificateWrapper
    extends X509Certificate {
        private final java.security.cert.X509Certificate c;

        private X509CertificateWrapper(java.security.cert.X509Certificate c) {
            this.c = c;
        }

        @Override
        public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
            try {
                this.c.checkValidity();
            }
            catch (java.security.cert.CertificateExpiredException e) {
                throw new CertificateExpiredException(e.getMessage());
            }
            catch (java.security.cert.CertificateNotYetValidException e) {
                throw new CertificateNotYetValidException(e.getMessage());
            }
        }

        @Override
        public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
            try {
                this.c.checkValidity(date);
            }
            catch (java.security.cert.CertificateExpiredException e) {
                throw new CertificateExpiredException(e.getMessage());
            }
            catch (java.security.cert.CertificateNotYetValidException e) {
                throw new CertificateNotYetValidException(e.getMessage());
            }
        }

        @Override
        public int getVersion() {
            return this.c.getVersion() - 1;
        }

        @Override
        public BigInteger getSerialNumber() {
            return this.c.getSerialNumber();
        }

        @Override
        public Principal getIssuerDN() {
            return this.c.getIssuerX500Principal();
        }

        @Override
        public Principal getSubjectDN() {
            return this.c.getSubjectX500Principal();
        }

        @Override
        public Date getNotBefore() {
            return this.c.getNotBefore();
        }

        @Override
        public Date getNotAfter() {
            return this.c.getNotAfter();
        }

        @Override
        public String getSigAlgName() {
            return this.c.getSigAlgName();
        }

        @Override
        public String getSigAlgOID() {
            return this.c.getSigAlgOID();
        }

        @Override
        public byte[] getSigAlgParams() {
            return this.c.getSigAlgParams();
        }

        @Override
        public byte[] getEncoded() throws CertificateEncodingException {
            try {
                return this.c.getEncoded();
            }
            catch (java.security.cert.CertificateEncodingException e) {
                throw new CertificateEncodingException(e.getMessage());
            }
        }

        @Override
        public void verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
            try {
                this.c.verify(key);
            }
            catch (java.security.cert.CertificateEncodingException e) {
                throw new CertificateEncodingException(e.getMessage());
            }
            catch (java.security.cert.CertificateExpiredException e) {
                throw new CertificateExpiredException(e.getMessage());
            }
            catch (java.security.cert.CertificateNotYetValidException e) {
                throw new CertificateNotYetValidException(e.getMessage());
            }
            catch (CertificateParsingException e) {
                throw new javax.security.cert.CertificateParsingException(e.getMessage());
            }
            catch (java.security.cert.CertificateException e) {
                throw new CertificateException(e.getMessage());
            }
        }

        @Override
        public void verify(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
            try {
                this.c.verify(key, sigProvider);
            }
            catch (java.security.cert.CertificateEncodingException e) {
                throw new CertificateEncodingException(e.getMessage());
            }
            catch (java.security.cert.CertificateExpiredException e) {
                throw new CertificateExpiredException(e.getMessage());
            }
            catch (java.security.cert.CertificateNotYetValidException e) {
                throw new CertificateNotYetValidException(e.getMessage());
            }
            catch (CertificateParsingException e) {
                throw new javax.security.cert.CertificateParsingException(e.getMessage());
            }
            catch (java.security.cert.CertificateException e) {
                throw new CertificateException(e.getMessage());
            }
        }

        @Override
        public String toString() {
            return this.c.toString();
        }

        @Override
        public PublicKey getPublicKey() {
            return this.c.getPublicKey();
        }
    }
}

