/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.bouncycastle.jsse.BCSSLSocket;
import org.bouncycastle.jsse.provider.PropertyUtils;
import org.bouncycastle.jsse.provider.SSLSocketUtil;

abstract class ProvSSLSocketBase
extends SSLSocket
implements BCSSLSocket {
    protected static final boolean provAssumeOriginalHostName = PropertyUtils.getBooleanSystemProperty("org.bouncycastle.jsse.client.assumeOriginalHostName", false);
    protected static final boolean provJdkTlsTrustNameService = PropertyUtils.getBooleanSystemProperty("jdk.tls.trustNameService", false);
    protected final Closeable socketCloser = new Closeable(){

        @Override
        public void close() throws IOException {
            ProvSSLSocketBase.this.closeSocket();
        }
    };
    protected final Map<HandshakeCompletedListener, AccessControlContext> listeners = Collections.synchronizedMap(new HashMap(4));

    protected ProvSSLSocketBase() {
    }

    @Override
    public void addHandshakeCompletedListener(HandshakeCompletedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("'listener' cannot be null");
        }
        this.listeners.put(listener, AccessController.getContext());
    }

    protected void closeSocket() throws IOException {
        super.close();
    }

    @Override
    public void connect(String host, int port, int timeout) throws IOException {
        this.setHost(host);
        this.connect(this.createInetSocketAddress(host, port), timeout);
    }

    @Override
    public final boolean getOOBInline() throws SocketException {
        throw new SocketException("This method is ineffective, since sending urgent data is not supported by SSLSockets");
    }

    @Override
    public void removeHandshakeCompletedListener(HandshakeCompletedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("'listener' cannot be null");
        }
        if (null == this.listeners.remove(listener)) {
            throw new IllegalArgumentException("'listener' is not registered");
        }
    }

    @Override
    public final void sendUrgentData(int data) throws IOException {
        throw new SocketException("This method is not supported by SSLSockets");
    }

    @Override
    public final void setOOBInline(boolean on) throws SocketException {
        throw new SocketException("This method is ineffective, since sending urgent data is not supported by SSLSockets");
    }

    protected InetSocketAddress createInetSocketAddress(InetAddress address, int port) throws IOException {
        return new InetSocketAddress(address, port);
    }

    protected InetSocketAddress createInetSocketAddress(String host, int port) throws IOException {
        return null == host ? new InetSocketAddress(InetAddress.getByName(null), port) : new InetSocketAddress(host, port);
    }

    protected void implBind(InetAddress clientAddress, int clientPort) throws IOException {
        this.bind(this.createInetSocketAddress(clientAddress, clientPort));
    }

    protected void implConnect(InetAddress address, int port) throws IOException {
        this.connect(this.createInetSocketAddress(address, port), 0);
    }

    protected void implConnect(String host, int port) throws IOException, UnknownHostException {
        this.connect(this.createInetSocketAddress(host, port), 0);
    }

    protected void notifyHandshakeCompletedListeners(SSLSession eventSession) {
        final Collection<Map.Entry<HandshakeCompletedListener, AccessControlContext>> entries = this.getHandshakeCompletedEntries();
        if (null == entries) {
            return;
        }
        final HandshakeCompletedEvent event = new HandshakeCompletedEvent(this, eventSession);
        Runnable notifyRunnable = new Runnable(){

            @Override
            public void run() {
                for (Map.Entry entry : entries) {
                    final HandshakeCompletedListener listener = (HandshakeCompletedListener)entry.getKey();
                    AccessControlContext accessControlContext = (AccessControlContext)entry.getValue();
                    AccessController.doPrivileged(new PrivilegedAction<Void>(){

                        @Override
                        public Void run() {
                            listener.handshakeCompleted(event);
                            return null;
                        }
                    }, accessControlContext);
                }
            }
        };
        SSLSocketUtil.handshakeCompleted(notifyRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Map.Entry<HandshakeCompletedListener, AccessControlContext>> getHandshakeCompletedEntries() {
        Map<HandshakeCompletedListener, AccessControlContext> map = this.listeners;
        synchronized (map) {
            return this.listeners.isEmpty() ? null : new ArrayList<Map.Entry<HandshakeCompletedListener, AccessControlContext>>(this.listeners.entrySet());
        }
    }
}

