/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;

class ReflectionUtil {
    ReflectionUtil() {
    }

    static Method findMethod(Method[] methods, String name) {
        if (methods != null) {
            for (Method m : methods) {
                if (!m.getName().equals(name)) continue;
                return m;
            }
        }
        return null;
    }

    static boolean hasMethod(Method[] methods, String name) {
        return null != ReflectionUtil.findMethod(methods, name);
    }

    static Class<?> getClass(final String className) {
        if (null == className) {
            return null;
        }
        return (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

            @Override
            public Class<?> run() {
                try {
                    ClassLoader classLoader = ReflectionUtil.class.getClassLoader();
                    Class<?> clazz = null == classLoader ? Class.forName(className) : classLoader.loadClass(className);
                    return clazz;
                }
                catch (Exception exception) {
                    return null;
                }
            }
        });
    }

    static <T> Constructor<T> getDeclaredConstructor(final String className, final Class<?> ... parameterTypes) {
        if (null == className) {
            return null;
        }
        return (Constructor)AccessController.doPrivileged(new PrivilegedAction<Constructor<T>>(){

            @Override
            public Constructor<T> run() {
                try {
                    Class<?> clazz;
                    ClassLoader classLoader = ReflectionUtil.class.getClassLoader();
                    Class<?> clazz2 = clazz = null == classLoader ? Class.forName(className) : classLoader.loadClass(className);
                    if (null != clazz) {
                        return clazz.getDeclaredConstructor(parameterTypes);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    static Method getMethod(final String className, final String methodName, final Class<?> ... parameterTypes) {
        if (null == className || null == methodName) {
            return null;
        }
        return AccessController.doPrivileged(new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                try {
                    Class<?> clazz;
                    ClassLoader classLoader = ReflectionUtil.class.getClassLoader();
                    Class<?> clazz2 = clazz = null == classLoader ? Class.forName(className) : classLoader.loadClass(className);
                    if (null != clazz) {
                        return clazz.getMethod(methodName, parameterTypes);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    static Method[] getMethods(final String className) {
        if (null == className) {
            return null;
        }
        return AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

            @Override
            public Method[] run() {
                try {
                    Class<?> clazz;
                    ClassLoader classLoader = ReflectionUtil.class.getClassLoader();
                    Class<?> clazz2 = clazz = null == classLoader ? Class.forName(className) : classLoader.loadClass(className);
                    if (null != clazz) {
                        return clazz.getMethods();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    static Integer getStaticInt(final String className, final String fieldName) {
        return AccessController.doPrivileged(new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                try {
                    Class<?> fieldType;
                    Field field;
                    Class<?> clazz;
                    ClassLoader classLoader = ReflectionUtil.class.getClassLoader();
                    Class<?> clazz2 = clazz = null == classLoader ? Class.forName(className) : classLoader.loadClass(className);
                    if (null != clazz && null != (field = clazz.getField(fieldName)) && Integer.TYPE == (fieldType = field.getType())) {
                        return field.getInt(null);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    static Integer getStaticIntOrDefault(String className, String fieldName, int defaultValue) {
        Integer value = ReflectionUtil.getStaticInt(className, fieldName);
        return null == value ? defaultValue : value;
    }

    static Object invokeGetter(Object obj, Method method) {
        return ReflectionUtil.invokeMethod(obj, method, new Object[0]);
    }

    static Object invokeMethod(final Object obj, final Method method, final Object ... args) {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    return method.invoke(obj, args);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    static void invokeSetter(Object obj, Method method, Object arg) {
        ReflectionUtil.invokeMethod(obj, method, arg);
    }
}

