/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.security.AlgorithmParameters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import org.bouncycastle.jsse.java.security.BCAlgorithmConstraints;
import org.bouncycastle.jsse.java.security.BCCryptoPrimitive;
import org.bouncycastle.jsse.provider.FipsUtils;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.NamedGroupInfo;
import org.bouncycastle.jsse.provider.PropertyUtils;
import org.bouncycastle.jsse.provider.ProvSSLParameters;
import org.bouncycastle.tls.NamedGroup;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.SignatureScheme;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Integers;

class SignatureSchemeInfo {
    private static final Logger LOG = Logger.getLogger(SignatureSchemeInfo.class.getName());
    static final int historical_dsa_sha1 = 514;
    static final int historical_dsa_sha224 = 770;
    static final int historical_dsa_sha256 = 1026;
    static final int historical_ecdsa_sha224 = 771;
    static final int historical_rsa_md5 = 257;
    static final int historical_rsa_sha224 = 769;
    private static final String PROPERTY_CLIENT_SIGNATURE_SCHEMES = "jdk.tls.client.SignatureSchemes";
    private static final String PROPERTY_SERVER_SIGNATURE_SCHEMES = "jdk.tls.server.SignatureSchemes";
    private static final String PROPERTY_CLIENT_SIGNATURE_SCHEMES_CERT = "org.bouncycastle.jsse.client.SignatureSchemesCert";
    private static final String PROPERTY_SERVER_SIGNATURE_SCHEMES_CERT = "org.bouncycastle.jsse.server.SignatureSchemesCert";
    private static final int[] CANDIDATES_DEFAULT = SignatureSchemeInfo.createCandidatesDefault();
    private final All all;
    private final AlgorithmParameters algorithmParameters;
    private final NamedGroupInfo namedGroupInfo;
    private final boolean enabled;
    private final boolean disabled13;

    static PerConnection createPerConnectionClient(PerContext perContext, ProvSSLParameters sslParameters, ProtocolVersion[] activeProtocolVersions, NamedGroupInfo.PerConnection namedGroups) {
        ProtocolVersion latest = ProtocolVersion.getLatestTLS(activeProtocolVersions);
        if (!TlsUtils.isSignatureAlgorithmsExtensionAllowed(latest)) {
            return new PerConnection(null, null);
        }
        ProtocolVersion earliest = ProtocolVersion.getEarliestTLS(activeProtocolVersions);
        return SignatureSchemeInfo.createPerConnection(perContext, false, sslParameters, earliest, latest, namedGroups);
    }

    static PerConnection createPerConnectionServer(PerContext perContext, ProvSSLParameters sslParameters, ProtocolVersion negotiatedVersion, NamedGroupInfo.PerConnection namedGroups) {
        if (!TlsUtils.isSignatureAlgorithmsExtensionAllowed(negotiatedVersion)) {
            return new PerConnection(null, null);
        }
        return SignatureSchemeInfo.createPerConnection(perContext, true, sslParameters, negotiatedVersion, negotiatedVersion, namedGroups);
    }

    private static PerConnection createPerConnection(PerContext perContext, boolean isServer, ProvSSLParameters sslParameters, ProtocolVersion earliest, ProtocolVersion latest, NamedGroupInfo.PerConnection namedGroups) {
        String[] signatureSchemesCert;
        int[] candidates;
        String[] signatureSchemes = sslParameters.getSignatureSchemes();
        if (signatureSchemes == null) {
            int[] nArray = candidates = isServer ? perContext.candidatesServer : perContext.candidatesClient;
            if (candidates == null) {
                candidates = CANDIDATES_DEFAULT;
            }
        } else {
            candidates = SignatureSchemeInfo.createCandidates(perContext.index, signatureSchemes, "SSLParameters.signatureSchemes");
        }
        int[] candidatesCert = (signatureSchemesCert = sslParameters.getSignatureSchemesCert()) == null ? (isServer ? perContext.candidatesCertServer : perContext.candidatesCertClient) : SignatureSchemeInfo.createCandidates(perContext.index, signatureSchemesCert, "SSLParameters.signatureSchemesCert");
        BCAlgorithmConstraints algorithmConstraints = sslParameters.getAlgorithmConstraints();
        boolean post13Active = TlsUtils.isTLSv13(latest);
        boolean pre13Active = !TlsUtils.isTLSv13(earliest);
        int count = candidates.length;
        ArrayList<SignatureSchemeInfo> localSigSchemes = new ArrayList<SignatureSchemeInfo>(count);
        for (int i = 0; i < count; ++i) {
            Integer candidate = Integers.valueOf((int)candidates[i]);
            SignatureSchemeInfo signatureSchemeInfo = (SignatureSchemeInfo)perContext.index.get(candidate);
            if (null == signatureSchemeInfo || !signatureSchemeInfo.isActiveCerts(algorithmConstraints, post13Active, pre13Active, namedGroups)) continue;
            localSigSchemes.add(signatureSchemeInfo);
        }
        localSigSchemes.trimToSize();
        ArrayList<SignatureSchemeInfo> localSigSchemesCert = null;
        if (candidatesCert != null) {
            int count2 = candidatesCert.length;
            localSigSchemesCert = new ArrayList<SignatureSchemeInfo>(count2);
            for (int i = 0; i < count2; ++i) {
                Integer candidate = Integers.valueOf((int)candidatesCert[i]);
                SignatureSchemeInfo signatureSchemeInfo = (SignatureSchemeInfo)perContext.index.get(candidate);
                if (null == signatureSchemeInfo || !signatureSchemeInfo.isActiveCerts(algorithmConstraints, post13Active, pre13Active, namedGroups)) continue;
                localSigSchemesCert.add(signatureSchemeInfo);
            }
            localSigSchemesCert.trimToSize();
        }
        return new PerConnection(localSigSchemes, localSigSchemesCert);
    }

    static PerContext createPerContext(boolean isFipsContext, JcaTlsCrypto crypto, NamedGroupInfo.PerContext namedGroups) {
        Map<Integer, SignatureSchemeInfo> index = SignatureSchemeInfo.createIndex(isFipsContext, crypto, namedGroups);
        int[] candidatesClient = SignatureSchemeInfo.createCandidatesFromProperty(index, PROPERTY_CLIENT_SIGNATURE_SCHEMES);
        int[] candidatesServer = SignatureSchemeInfo.createCandidatesFromProperty(index, PROPERTY_SERVER_SIGNATURE_SCHEMES);
        int[] candidatesCertClient = SignatureSchemeInfo.createCandidatesFromProperty(index, PROPERTY_CLIENT_SIGNATURE_SCHEMES_CERT);
        int[] candidatesCertServer = SignatureSchemeInfo.createCandidatesFromProperty(index, PROPERTY_SERVER_SIGNATURE_SCHEMES_CERT);
        return new PerContext(index, candidatesClient, candidatesServer, candidatesCertClient, candidatesCertServer);
    }

    private static String[] getJcaSignatureAlgorithms(Collection<SignatureSchemeInfo> infos) {
        if (null == infos) {
            return TlsUtils.EMPTY_STRINGS;
        }
        String[] result = new String[infos.size()];
        int resultPos = 0;
        for (SignatureSchemeInfo info : infos) {
            result[resultPos++] = info.getJcaSignatureAlgorithm();
        }
        return result;
    }

    private static String[] getJcaSignatureAlgorithmsBC(Collection<SignatureSchemeInfo> infos) {
        if (null == infos) {
            return TlsUtils.EMPTY_STRINGS;
        }
        String[] result = new String[infos.size()];
        int resultPos = 0;
        for (SignatureSchemeInfo info : infos) {
            result[resultPos++] = info.getJcaSignatureAlgorithmBC();
        }
        return result;
    }

    static SignatureAndHashAlgorithm getSignatureAndHashAlgorithm(int signatureScheme) {
        if (!TlsUtils.isValidUint16(signatureScheme)) {
            throw new IllegalArgumentException();
        }
        return SignatureScheme.getSignatureAndHashAlgorithm(signatureScheme);
    }

    private static Vector<SignatureAndHashAlgorithm> getSignatureAndHashAlgorithms(Collection<SignatureSchemeInfo> signatureSchemeInfos) {
        if (null == signatureSchemeInfos || signatureSchemeInfos.isEmpty()) {
            return null;
        }
        int count = signatureSchemeInfos.size();
        Vector<SignatureAndHashAlgorithm> result = new Vector<SignatureAndHashAlgorithm>(count);
        for (SignatureSchemeInfo signatureSchemeInfo : signatureSchemeInfos) {
            if (null == signatureSchemeInfo) continue;
            SignatureAndHashAlgorithm sigAndHashAlg = signatureSchemeInfo.getSignatureAndHashAlgorithm();
            result.add(sigAndHashAlg);
        }
        if (result.isEmpty()) {
            return null;
        }
        result.trimToSize();
        return result;
    }

    static List<SignatureSchemeInfo> getSignatureSchemes(PerContext perContext, Vector<SignatureAndHashAlgorithm> sigAndHashAlgs) {
        if (null == sigAndHashAlgs || sigAndHashAlgs.isEmpty()) {
            return null;
        }
        int count = sigAndHashAlgs.size();
        ArrayList<SignatureSchemeInfo> result = new ArrayList<SignatureSchemeInfo>(count);
        for (int i = 0; i < count; ++i) {
            SignatureAndHashAlgorithm sigAndHashAlg = sigAndHashAlgs.elementAt(i);
            if (null == sigAndHashAlg) continue;
            int signatureScheme = SignatureScheme.from(sigAndHashAlg);
            SignatureSchemeInfo signatureSchemeInfo = (SignatureSchemeInfo)perContext.index.get(signatureScheme);
            if (null == signatureSchemeInfo) continue;
            result.add(signatureSchemeInfo);
        }
        if (result.isEmpty()) {
            return null;
        }
        result.trimToSize();
        return Collections.unmodifiableList(result);
    }

    private static void addSignatureScheme(boolean isFipsContext, JcaTlsCrypto crypto, NamedGroupInfo.PerContext ng, Map<Integer, SignatureSchemeInfo> ss, All all) {
        int signatureScheme = all.signatureScheme;
        if (isFipsContext && !FipsUtils.isFipsSignatureScheme(signatureScheme)) {
            return;
        }
        NamedGroupInfo namedGroupInfo = null;
        boolean disabled13 = false;
        int namedGroup13 = all.namedGroup13;
        if (!(namedGroup13 < 0 || null != (namedGroupInfo = NamedGroupInfo.getNamedGroup(ng, namedGroup13)) && namedGroupInfo.isEnabled() && namedGroupInfo.isSupportedPost13())) {
            disabled13 = true;
        }
        boolean enabled = crypto.hasSignatureScheme(signatureScheme);
        AlgorithmParameters algorithmParameters = null;
        if (enabled) {
            try {
                algorithmParameters = crypto.getSignatureSchemeAlgorithmParameters(signatureScheme);
            }
            catch (Exception e) {
                enabled = false;
            }
        }
        SignatureSchemeInfo signatureSchemeInfo = new SignatureSchemeInfo(all, algorithmParameters, namedGroupInfo, enabled, disabled13);
        if (null != ss.put(signatureScheme, signatureSchemeInfo)) {
            throw new IllegalStateException("Duplicate entries for SignatureSchemeInfo");
        }
    }

    private static int[] createCandidatesFromProperty(Map<Integer, SignatureSchemeInfo> index, String propertyName) {
        String[] names = PropertyUtils.getStringArraySystemProperty(propertyName);
        if (null == names) {
            return null;
        }
        return SignatureSchemeInfo.createCandidates(index, names, propertyName);
    }

    private static int[] createCandidates(Map<Integer, SignatureSchemeInfo> index, String[] names, String description) {
        int[] result = new int[names.length];
        int count = 0;
        for (String name : names) {
            int signatureScheme = SignatureSchemeInfo.getSignatureSchemeByName(name);
            if (signatureScheme < 0) {
                LOG.warning("'" + description + "' contains unrecognised SignatureScheme: " + name);
                continue;
            }
            SignatureSchemeInfo signatureSchemeInfo = index.get(signatureScheme);
            if (null == signatureSchemeInfo) {
                LOG.warning("'" + description + "' contains unsupported SignatureScheme: " + name);
                continue;
            }
            if (!signatureSchemeInfo.isEnabled()) {
                LOG.warning("'" + description + "' contains disabled SignatureScheme: " + name);
                continue;
            }
            result[count++] = signatureScheme;
        }
        if (count < result.length) {
            result = Arrays.copyOf((int[])result, (int)count);
        }
        if (result.length < 1) {
            LOG.severe("'" + description + "' contained no usable SignatureScheme values");
        }
        return result;
    }

    private static int[] createCandidatesDefault() {
        All[] values = All.values();
        int[] result = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = values[i].signatureScheme;
        }
        return result;
    }

    private static Map<Integer, SignatureSchemeInfo> createIndex(boolean isFipsContext, JcaTlsCrypto crypto, NamedGroupInfo.PerContext ng) {
        TreeMap<Integer, SignatureSchemeInfo> ss = new TreeMap<Integer, SignatureSchemeInfo>();
        for (All all : All.values()) {
            SignatureSchemeInfo.addSignatureScheme(isFipsContext, crypto, ng, ss, all);
        }
        return ss;
    }

    private static int getSignatureSchemeByName(String name) {
        for (All all : All.values()) {
            if (!all.name.equalsIgnoreCase(name)) continue;
            return all.signatureScheme;
        }
        return -1;
    }

    private static boolean isECDSA(int signatureScheme) {
        switch (signatureScheme) {
            case 515: 
            case 771: 
            case 1027: 
            case 1283: 
            case 1539: 
            case 2074: 
            case 2075: 
            case 2076: {
                return true;
            }
        }
        return false;
    }

    SignatureSchemeInfo(All all, AlgorithmParameters algorithmParameters, NamedGroupInfo namedGroupInfo, boolean enabled, boolean disabled13) {
        this.all = all;
        this.algorithmParameters = algorithmParameters;
        this.namedGroupInfo = namedGroupInfo;
        this.enabled = enabled;
        this.disabled13 = disabled13;
    }

    short getHashAlgorithm() {
        return SignatureScheme.getHashAlgorithm(this.all.signatureScheme);
    }

    String getJcaSignatureAlgorithm() {
        return this.all.jcaSignatureAlgorithm;
    }

    String getJcaSignatureAlgorithmBC() {
        return this.all.jcaSignatureAlgorithmBC;
    }

    String getKeyType() {
        return this.all.keyAlgorithm;
    }

    String getKeyType13() {
        return this.all.keyType13;
    }

    String getName() {
        return this.all.name;
    }

    NamedGroupInfo getNamedGroupInfo() {
        return this.namedGroupInfo;
    }

    short getSignatureAlgorithm() {
        return SignatureScheme.getSignatureAlgorithm(this.all.signatureScheme);
    }

    SignatureAndHashAlgorithm getSignatureAndHashAlgorithm() {
        return SignatureSchemeInfo.getSignatureAndHashAlgorithm(this.all.signatureScheme);
    }

    int getSignatureScheme() {
        return this.all.signatureScheme;
    }

    boolean isEnabled() {
        return this.enabled;
    }

    boolean isSupportedPost13() {
        return !this.disabled13 && this.all.supportedPost13;
    }

    boolean isSupportedPre13() {
        return this.all.supportedPre13;
    }

    boolean isSupportedCerts13() {
        return !this.disabled13 && this.all.supportedCerts13;
    }

    public String toString() {
        return this.all.text;
    }

    private boolean isActiveCerts(BCAlgorithmConstraints algorithmConstraints, boolean post13Active, boolean pre13Active, NamedGroupInfo.PerConnection namedGroupInfos) {
        return this.enabled && this.isNamedGroupOK(post13Active && this.isSupportedCerts13(), pre13Active && this.isSupportedPre13(), namedGroupInfos) && this.isPermittedBy(algorithmConstraints);
    }

    private boolean isNamedGroupOK(boolean post13Allowed, boolean pre13Allowed, NamedGroupInfo.PerConnection namedGroupInfos) {
        if (null != this.namedGroupInfo) {
            return post13Allowed && NamedGroupInfo.hasLocal(namedGroupInfos, this.namedGroupInfo.getNamedGroup()) || pre13Allowed && NamedGroupInfo.hasAnyECDSALocal(namedGroupInfos);
        }
        return !(!post13Allowed && !pre13Allowed || SignatureSchemeInfo.isECDSA(this.all.signatureScheme) && !NamedGroupInfo.hasAnyECDSALocal(namedGroupInfos));
    }

    private boolean isPermittedBy(BCAlgorithmConstraints algorithmConstraints) {
        Set<BCCryptoPrimitive> primitives = JsseUtils.SIGNATURE_CRYPTO_PRIMITIVES_BC;
        return algorithmConstraints.permits(primitives, this.all.name, null) && algorithmConstraints.permits(primitives, this.all.keyAlgorithm, null) && algorithmConstraints.permits(primitives, this.all.jcaSignatureAlgorithm, this.algorithmParameters);
    }

    static class PerContext {
        private final Map<Integer, SignatureSchemeInfo> index;
        private final int[] candidatesClient;
        private final int[] candidatesServer;
        private final int[] candidatesCertClient;
        private final int[] candidatesCertServer;

        PerContext(Map<Integer, SignatureSchemeInfo> index, int[] candidatesClient, int[] candidatesServer, int[] candidatesCertClient, int[] candidatesCertServer) {
            this.index = index;
            this.candidatesClient = candidatesClient;
            this.candidatesServer = candidatesServer;
            this.candidatesCertClient = candidatesCertClient;
            this.candidatesCertServer = candidatesCertServer;
        }
    }

    static class PerConnection {
        private final List<SignatureSchemeInfo> localSigSchemes;
        private final List<SignatureSchemeInfo> localSigSchemesCert;
        private final AtomicReference<List<SignatureSchemeInfo>> peerSigSchemes;
        private final AtomicReference<List<SignatureSchemeInfo>> peerSigSchemesCert;

        PerConnection(List<SignatureSchemeInfo> localSigSchemes, List<SignatureSchemeInfo> localSigSchemesCert) {
            this.localSigSchemes = localSigSchemes;
            this.localSigSchemesCert = localSigSchemesCert;
            this.peerSigSchemes = new AtomicReference();
            this.peerSigSchemesCert = new AtomicReference();
        }

        String[] getLocalJcaSignatureAlgorithms() {
            return SignatureSchemeInfo.getJcaSignatureAlgorithms(this.getLocalSigSchemesCert());
        }

        String[] getLocalJcaSignatureAlgorithmsBC() {
            return SignatureSchemeInfo.getJcaSignatureAlgorithmsBC(this.getLocalSigSchemesCert());
        }

        Vector<SignatureAndHashAlgorithm> getLocalSignatureAndHashAlgorithms() {
            return SignatureSchemeInfo.getSignatureAndHashAlgorithms(this.localSigSchemes);
        }

        Vector<SignatureAndHashAlgorithm> getLocalSignatureAndHashAlgorithmsCert() {
            return SignatureSchemeInfo.getSignatureAndHashAlgorithms(this.localSigSchemesCert);
        }

        List<SignatureSchemeInfo> getLocalSigSchemes() {
            return this.localSigSchemes;
        }

        List<SignatureSchemeInfo> getLocalSigSchemesCert() {
            return this.localSigSchemesCert != null ? this.localSigSchemesCert : this.getLocalSigSchemes();
        }

        String[] getPeerJcaSignatureAlgorithms() {
            return SignatureSchemeInfo.getJcaSignatureAlgorithms(this.getPeerSigSchemesCert());
        }

        String[] getPeerJcaSignatureAlgorithmsBC() {
            return SignatureSchemeInfo.getJcaSignatureAlgorithmsBC(this.getPeerSigSchemesCert());
        }

        List<SignatureSchemeInfo> getPeerSigSchemes() {
            return this.peerSigSchemes.get();
        }

        List<SignatureSchemeInfo> getPeerSigSchemesCert() {
            List<SignatureSchemeInfo> sigSchemesCert = this.peerSigSchemesCert.get();
            return sigSchemesCert != null ? sigSchemesCert : this.getPeerSigSchemes();
        }

        boolean hasLocalSignatureScheme(SignatureSchemeInfo signatureSchemeInfo) {
            return this.localSigSchemes.contains(signatureSchemeInfo);
        }

        void notifyPeerData(List<SignatureSchemeInfo> sigSchemes, List<SignatureSchemeInfo> sigSchemesCert) {
            this.peerSigSchemes.set(sigSchemes);
            this.peerSigSchemesCert.set(sigSchemesCert);
        }
    }

    private static enum All {
        ed25519(2055, "Ed25519", "Ed25519"),
        ed448(2056, "Ed448", "Ed448"),
        ecdsa_secp256r1_sha256(1027, "SHA256withECDSA", "EC"),
        ecdsa_secp384r1_sha384(1283, "SHA384withECDSA", "EC"),
        ecdsa_secp521r1_sha512(1539, "SHA512withECDSA", "EC"),
        ecdsa_brainpoolP256r1tls13_sha256(2074, "SHA256withECDSA", "EC"),
        ecdsa_brainpoolP384r1tls13_sha384(2075, "SHA384withECDSA", "EC"),
        ecdsa_brainpoolP512r1tls13_sha512(2076, "SHA512withECDSA", "EC"),
        rsa_pss_pss_sha256(2057, "SHA256withRSAandMGF1", "RSASSA-PSS"),
        rsa_pss_pss_sha384(2058, "SHA384withRSAandMGF1", "RSASSA-PSS"),
        rsa_pss_pss_sha512(2059, "SHA512withRSAandMGF1", "RSASSA-PSS"),
        rsa_pss_rsae_sha256(2052, "SHA256withRSAandMGF1", "RSA"),
        rsa_pss_rsae_sha384(2053, "SHA384withRSAandMGF1", "RSA"),
        rsa_pss_rsae_sha512(2054, "SHA512withRSAandMGF1", "RSA"),
        rsa_pkcs1_sha256(1025, "SHA256withRSA", "RSA", true),
        rsa_pkcs1_sha384(1281, "SHA384withRSA", "RSA", true),
        rsa_pkcs1_sha512(1537, "SHA512withRSA", "RSA", true),
        sm2sig_sm3(1800, "SM3withSM2", "EC"),
        dsa_sha256(1026, "dsa_sha256", "SHA256withDSA", "DSA"),
        ecdsa_sha224(771, "ecdsa_sha224", "SHA224withECDSA", "EC"),
        rsa_sha224(769, "rsa_sha224", "SHA224withRSA", "RSA"),
        dsa_sha224(770, "dsa_sha224", "SHA224withDSA", "DSA"),
        ecdsa_sha1(515, "SHA1withECDSA", "EC", true),
        rsa_pkcs1_sha1(513, "SHA1withRSA", "RSA", true),
        dsa_sha1(514, "dsa_sha1", "SHA1withDSA", "DSA"),
        rsa_md5(257, "rsa_md5", "MD5withRSA", "RSA");

        private final int signatureScheme;
        private final String name;
        private final String text;
        private final String jcaSignatureAlgorithm;
        private final String jcaSignatureAlgorithmBC;
        private final String keyAlgorithm;
        private final String keyType13;
        private final boolean supportedPost13;
        private final boolean supportedPre13;
        private final boolean supportedCerts13;
        private final int namedGroup13;

        private All(int signatureScheme, String jcaSignatureAlgorithm, String keyAlgorithm) {
            this(signatureScheme, jcaSignatureAlgorithm, keyAlgorithm, true, true, SignatureScheme.getNamedGroup(signatureScheme));
        }

        private All(int signatureScheme, String jcaSignatureAlgorithm, String keyAlgorithm, boolean supportedCerts13) {
            this(signatureScheme, jcaSignatureAlgorithm, keyAlgorithm, false, supportedCerts13, -1);
        }

        private All(int signatureScheme, String jcaSignatureAlgorithm, String keyAlgorithm, boolean supportedPost13, boolean supportedCerts13, int namedGroup13) {
            this(signatureScheme, SignatureScheme.getName(signatureScheme), jcaSignatureAlgorithm, keyAlgorithm, supportedPost13, supportedCerts13, namedGroup13);
        }

        private All(int signatureScheme, String name, String jcaSignatureAlgorithm, String keyAlgorithm) {
            this(signatureScheme, name, jcaSignatureAlgorithm, keyAlgorithm, false, false, -1);
        }

        private All(int signatureScheme, String name, String jcaSignatureAlgorithm, String keyAlgorithm, boolean supportedPost13, boolean supportedCerts13, int namedGroup13) {
            String keyType13 = JsseUtils.getKeyType13(keyAlgorithm, namedGroup13);
            String jcaSignatureAlgorithmBC = JsseUtils.getJcaSignatureAlgorithmBC(jcaSignatureAlgorithm, keyAlgorithm);
            this.signatureScheme = signatureScheme;
            this.name = name;
            this.text = name + "(0x" + Integer.toHexString(signatureScheme) + ")";
            this.jcaSignatureAlgorithm = jcaSignatureAlgorithm;
            this.jcaSignatureAlgorithmBC = jcaSignatureAlgorithmBC;
            this.keyAlgorithm = keyAlgorithm;
            this.keyType13 = keyType13;
            this.supportedPost13 = supportedPost13;
            this.supportedPre13 = namedGroup13 < 0 || NamedGroup.canBeNegotiated(namedGroup13, ProtocolVersion.TLSv12);
            this.supportedCerts13 = supportedCerts13;
            this.namedGroup13 = namedGroup13;
        }
    }
}

