/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsKeyExchange;

public abstract class AbstractTlsKeyExchange
implements TlsKeyExchange {
    protected int keyExchange;
    protected TlsContext context;

    protected AbstractTlsKeyExchange(int keyExchange) {
        this.keyExchange = keyExchange;
    }

    @Override
    public void init(TlsContext context) {
        this.context = context;
    }

    @Override
    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public boolean requiresServerKeyExchange() {
        return false;
    }

    @Override
    public byte[] generateServerKeyExchange() throws IOException {
        if (this.requiresServerKeyExchange()) {
            throw new TlsFatalAlert(80);
        }
        return null;
    }

    @Override
    public void skipServerKeyExchange() throws IOException {
        if (this.requiresServerKeyExchange()) {
            throw new TlsFatalAlert(10);
        }
    }

    @Override
    public void processServerKeyExchange(InputStream input) throws IOException {
        if (!this.requiresServerKeyExchange()) {
            throw new TlsFatalAlert(10);
        }
    }

    @Override
    public short[] getClientCertificateTypes() {
        return null;
    }

    @Override
    public void skipClientCredentials() throws IOException {
    }

    @Override
    public void processClientCertificate(Certificate clientCertificate) throws IOException {
    }

    @Override
    public void processClientKeyExchange(InputStream input) throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public boolean requiresCertificateVerify() {
        return true;
    }
}

