/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import org.bouncycastle.tls.DefaultTlsKeyExchangeFactory;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.TlsCloseable;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsHeartbeat;
import org.bouncycastle.tls.TlsKeyExchangeFactory;
import org.bouncycastle.tls.TlsPeer;
import org.bouncycastle.tls.crypto.TlsCrypto;

public abstract class AbstractTlsPeer
implements TlsPeer {
    private final TlsCrypto crypto;
    private volatile TlsCloseable closeHandle;

    protected AbstractTlsPeer(TlsCrypto crypto) {
        this.crypto = crypto;
    }

    protected ProtocolVersion[] getSupportedVersions() {
        return ProtocolVersion.TLSv13.downTo(ProtocolVersion.TLSv12);
    }

    protected abstract int[] getSupportedCipherSuites();

    @Override
    public void cancel() throws IOException {
        TlsCloseable closeHandle = this.closeHandle;
        if (null != closeHandle) {
            closeHandle.close();
        }
    }

    @Override
    public TlsCrypto getCrypto() {
        return this.crypto;
    }

    @Override
    public void notifyCloseHandle(TlsCloseable closeHandle) {
        this.closeHandle = closeHandle;
    }

    @Override
    public void notifyHandshakeBeginning() throws IOException {
    }

    @Override
    public int getHandshakeTimeoutMillis() {
        return 0;
    }

    @Override
    public int getHandshakeResendTimeMillis() {
        return 1000;
    }

    @Override
    public boolean allowLegacyResumption() {
        return false;
    }

    @Override
    public int getMaxCertificateChainLength() {
        return 10;
    }

    @Override
    public int getMaxHandshakeMessageSize() {
        return 32768;
    }

    @Override
    public short[] getPskKeyExchangeModes() {
        return new short[]{1};
    }

    @Override
    public boolean requiresCloseNotify() {
        return true;
    }

    @Override
    public boolean requiresExtendedMasterSecret() {
        return false;
    }

    @Override
    public boolean shouldCheckSigAlgOfPeerCerts() {
        return true;
    }

    @Override
    public boolean shouldUseExtendedMasterSecret() {
        return true;
    }

    @Override
    public boolean shouldUseExtendedPadding() {
        return false;
    }

    @Override
    public boolean shouldUseGMTUnixTime() {
        return false;
    }

    @Override
    public void notifySecureRenegotiation(boolean secureRenegotiation) throws IOException {
        if (!secureRenegotiation) {
            throw new TlsFatalAlert(40);
        }
    }

    @Override
    public TlsKeyExchangeFactory getKeyExchangeFactory() throws IOException {
        return new DefaultTlsKeyExchangeFactory();
    }

    @Override
    public void notifyAlertRaised(short alertLevel, short alertDescription, String message, Throwable cause) {
    }

    @Override
    public void notifyAlertReceived(short alertLevel, short alertDescription) {
    }

    @Override
    public void notifyConnectionClosed() {
    }

    @Override
    public void notifyHandshakeComplete() throws IOException {
    }

    @Override
    public TlsHeartbeat getHeartbeat() {
        return null;
    }

    @Override
    public short getHeartbeatPolicy() {
        return 2;
    }

    @Override
    public int getRenegotiationPolicy() {
        return 0;
    }
}

