/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.math.BigInteger;
import java.util.Vector;
import org.bouncycastle.tls.TlsSRPConfigVerifier;
import org.bouncycastle.tls.crypto.SRP6Group;
import org.bouncycastle.tls.crypto.SRP6StandardGroups;
import org.bouncycastle.tls.crypto.TlsSRPConfig;

public class DefaultTlsSRPConfigVerifier
implements TlsSRPConfigVerifier {
    private static final Vector DEFAULT_GROUPS = new Vector();
    protected final Vector groups;

    public DefaultTlsSRPConfigVerifier() {
        this(DEFAULT_GROUPS);
    }

    public DefaultTlsSRPConfigVerifier(Vector groups) {
        this.groups = new Vector(groups);
    }

    @Override
    public boolean accept(TlsSRPConfig srpConfig) {
        for (int i = 0; i < this.groups.size(); ++i) {
            if (!this.areGroupsEqual(srpConfig, (SRP6Group)this.groups.elementAt(i))) continue;
            return true;
        }
        return false;
    }

    protected boolean areGroupsEqual(TlsSRPConfig a, SRP6Group b) {
        BigInteger[] ng = a.getExplicitNG();
        return this.areParametersEqual(ng[0], b.getN()) && this.areParametersEqual(ng[1], b.getG());
    }

    protected boolean areParametersEqual(BigInteger a, BigInteger b) {
        return a == b || a.equals(b);
    }

    static {
        DEFAULT_GROUPS.addElement(SRP6StandardGroups.rfc5054_1024);
        DEFAULT_GROUPS.addElement(SRP6StandardGroups.rfc5054_1536);
        DEFAULT_GROUPS.addElement(SRP6StandardGroups.rfc5054_2048);
        DEFAULT_GROUPS.addElement(SRP6StandardGroups.rfc5054_3072);
        DEFAULT_GROUPS.addElement(SRP6StandardGroups.rfc5054_4096);
        DEFAULT_GROUPS.addElement(SRP6StandardGroups.rfc5054_6144);
        DEFAULT_GROUPS.addElement(SRP6StandardGroups.rfc5054_8192);
    }
}

