/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.tls.AbstractTlsKeyExchange;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsECCUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsAgreement;
import org.bouncycastle.tls.crypto.TlsECConfig;
import org.bouncycastle.tls.crypto.TlsSecret;

public class TlsECDHanonKeyExchange
extends AbstractTlsKeyExchange {
    protected TlsECConfig ecConfig;
    protected TlsAgreement agreement;

    private static int checkKeyExchange(int keyExchange) {
        switch (keyExchange) {
            case 20: {
                return keyExchange;
            }
        }
        throw new IllegalArgumentException("unsupported key exchange algorithm");
    }

    public TlsECDHanonKeyExchange(int keyExchange) {
        this(keyExchange, null);
    }

    public TlsECDHanonKeyExchange(int keyExchange, TlsECConfig ecConfig) {
        super(TlsECDHanonKeyExchange.checkKeyExchange(keyExchange));
        this.ecConfig = ecConfig;
    }

    @Override
    public void skipServerCredentials() throws IOException {
    }

    @Override
    public void processServerCredentials(TlsCredentials serverCredentials) throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        throw new TlsFatalAlert(10);
    }

    @Override
    public boolean requiresServerKeyExchange() {
        return true;
    }

    @Override
    public byte[] generateServerKeyExchange() throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        TlsECCUtils.writeECConfig(this.ecConfig, buf);
        this.agreement = this.context.getCrypto().createECDomain(this.ecConfig).createECDH();
        this.generateEphemeral(buf);
        return buf.toByteArray();
    }

    @Override
    public void processServerKeyExchange(InputStream input) throws IOException {
        this.ecConfig = TlsECCUtils.receiveECDHConfig(this.context, input);
        byte[] point = TlsUtils.readOpaque8(input, 1);
        this.agreement = this.context.getCrypto().createECDomain(this.ecConfig).createECDH();
        this.processEphemeral(point);
    }

    @Override
    public short[] getClientCertificateTypes() {
        return null;
    }

    @Override
    public void processClientCredentials(TlsCredentials clientCredentials) throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public void generateClientKeyExchange(OutputStream output) throws IOException {
        this.generateEphemeral(output);
    }

    @Override
    public void processClientCertificate(Certificate clientCertificate) throws IOException {
        throw new TlsFatalAlert(10);
    }

    @Override
    public void processClientKeyExchange(InputStream input) throws IOException {
        byte[] point = TlsUtils.readOpaque8(input, 1);
        this.processEphemeral(point);
    }

    @Override
    public TlsSecret generatePreMasterSecret() throws IOException {
        return this.agreement.calculateSecret();
    }

    protected void generateEphemeral(OutputStream output) throws IOException {
        byte[] point = this.agreement.generateEphemeral();
        TlsUtils.writeOpaque8(point, output);
    }

    protected void processEphemeral(byte[] point) throws IOException {
        TlsECCUtils.checkPointEncoding(this.ecConfig.getNamedGroup(), point);
        this.agreement.receivePeerValue(point);
    }
}

