/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import org.bouncycastle.tls.AbstractTlsKeyExchange;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.DigestInputBuffer;
import org.bouncycastle.tls.ServerSRPParams;
import org.bouncycastle.tls.TlsCredentialedSigner;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsSRPConfigVerifier;
import org.bouncycastle.tls.TlsSRPIdentity;
import org.bouncycastle.tls.TlsSRPLoginParameters;
import org.bouncycastle.tls.TlsSRPUtils;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsSRP6Client;
import org.bouncycastle.tls.crypto.TlsSRP6Server;
import org.bouncycastle.tls.crypto.TlsSRPConfig;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.io.TeeInputStream;

public class TlsSRPKeyExchange
extends AbstractTlsKeyExchange {
    protected TlsSRPIdentity srpIdentity;
    protected TlsSRPConfigVerifier srpConfigVerifier;
    protected TlsCertificate serverCertificate = null;
    protected byte[] srpSalt = null;
    protected TlsSRP6Client srpClient = null;
    protected TlsSRPLoginParameters srpLoginParameters;
    protected TlsCredentialedSigner serverCredentials = null;
    protected TlsSRP6Server srpServer = null;
    protected BigInteger srpPeerCredentials = null;

    private static int checkKeyExchange(int keyExchange) {
        switch (keyExchange) {
            case 21: 
            case 22: 
            case 23: {
                return keyExchange;
            }
        }
        throw new IllegalArgumentException("unsupported key exchange algorithm");
    }

    public TlsSRPKeyExchange(int keyExchange, TlsSRPIdentity srpIdentity, TlsSRPConfigVerifier srpConfigVerifier) {
        super(TlsSRPKeyExchange.checkKeyExchange(keyExchange));
        this.srpIdentity = srpIdentity;
        this.srpConfigVerifier = srpConfigVerifier;
    }

    public TlsSRPKeyExchange(int keyExchange, TlsSRPLoginParameters srpLoginParameters) {
        super(TlsSRPKeyExchange.checkKeyExchange(keyExchange));
        this.srpLoginParameters = srpLoginParameters;
    }

    @Override
    public void skipServerCredentials() throws IOException {
        if (this.keyExchange != 21) {
            throw new TlsFatalAlert(80);
        }
    }

    @Override
    public void processServerCredentials(TlsCredentials serverCredentials) throws IOException {
        if (this.keyExchange == 21) {
            throw new TlsFatalAlert(80);
        }
        this.serverCredentials = TlsUtils.requireSignerCredentials(serverCredentials);
    }

    @Override
    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        if (this.keyExchange == 21) {
            throw new TlsFatalAlert(80);
        }
        this.serverCertificate = serverCertificate.getCertificateAt(0);
    }

    @Override
    public boolean requiresServerKeyExchange() {
        return true;
    }

    @Override
    public byte[] generateServerKeyExchange() throws IOException {
        TlsSRPConfig config = this.srpLoginParameters.getConfig();
        this.srpServer = this.context.getCrypto().createSRP6Server(config, this.srpLoginParameters.getVerifier());
        BigInteger B = this.srpServer.generateServerCredentials();
        BigInteger[] ng = config.getExplicitNG();
        ServerSRPParams srpParams = new ServerSRPParams(ng[0], ng[1], this.srpLoginParameters.getSalt(), B);
        DigestInputBuffer digestBuffer = new DigestInputBuffer();
        srpParams.encode(digestBuffer);
        if (this.serverCredentials != null) {
            TlsUtils.generateServerKeyExchangeSignature(this.context, this.serverCredentials, null, digestBuffer);
        }
        return digestBuffer.toByteArray();
    }

    @Override
    public void processServerKeyExchange(InputStream input) throws IOException {
        DigestInputBuffer digestBuffer = null;
        InputStream teeIn = input;
        if (this.keyExchange != 21) {
            digestBuffer = new DigestInputBuffer();
            teeIn = new TeeInputStream(input, (OutputStream)digestBuffer);
        }
        ServerSRPParams srpParams = ServerSRPParams.parse(teeIn);
        if (digestBuffer != null) {
            TlsUtils.verifyServerKeyExchangeSignature(this.context, input, this.serverCertificate, null, digestBuffer);
        }
        TlsSRPConfig config = new TlsSRPConfig();
        config.setExplicitNG(new BigInteger[]{srpParams.getN(), srpParams.getG()});
        if (!this.srpConfigVerifier.accept(config)) {
            throw new TlsFatalAlert(71);
        }
        this.srpSalt = srpParams.getS();
        this.srpPeerCredentials = TlsSRPKeyExchange.validatePublicValue(srpParams.getN(), srpParams.getB());
        this.srpClient = this.context.getCrypto().createSRP6Client(config);
    }

    @Override
    public void processClientCredentials(TlsCredentials clientCredentials) throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public void generateClientKeyExchange(OutputStream output) throws IOException {
        byte[] identity = this.srpIdentity.getSRPIdentity();
        byte[] password = this.srpIdentity.getSRPPassword();
        BigInteger A = this.srpClient.generateClientCredentials(this.srpSalt, identity, password);
        TlsSRPUtils.writeSRPParameter(A, output);
        this.context.getSecurityParametersHandshake().srpIdentity = Arrays.clone((byte[])identity);
    }

    @Override
    public void processClientKeyExchange(InputStream input) throws IOException {
        this.srpPeerCredentials = TlsSRPKeyExchange.validatePublicValue(this.srpLoginParameters.getConfig().getExplicitNG()[0], TlsSRPUtils.readSRPParameter(input));
        this.context.getSecurityParametersHandshake().srpIdentity = Arrays.clone((byte[])this.srpLoginParameters.getIdentity());
    }

    @Override
    public TlsSecret generatePreMasterSecret() throws IOException {
        BigInteger S = this.srpServer != null ? this.srpServer.calculateSecret(this.srpPeerCredentials) : this.srpClient.calculateSecret(this.srpPeerCredentials);
        return this.context.getCrypto().createSecret(BigIntegers.asUnsignedByteArray((BigInteger)S));
    }

    protected static BigInteger validatePublicValue(BigInteger N, BigInteger val) throws IOException {
        if ((val = val.mod(N)).equals(BigInteger.ZERO)) {
            throw new TlsFatalAlert(47);
        }
        return val;
    }
}

