/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto;

import java.io.IOException;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.TlsCipher;
import org.bouncycastle.tls.crypto.TlsDecodeResult;
import org.bouncycastle.tls.crypto.TlsEncodeResult;

public class TlsNullNullCipher
implements TlsCipher {
    public static final TlsNullNullCipher INSTANCE = new TlsNullNullCipher();

    @Override
    public int getCiphertextDecodeLimit(int plaintextLimit) {
        return plaintextLimit;
    }

    @Override
    public int getCiphertextEncodeLimit(int plaintextLimit) {
        return plaintextLimit;
    }

    @Override
    public int getPlaintextDecodeLimit(int ciphertextLimit) {
        return ciphertextLimit;
    }

    @Override
    public int getPlaintextEncodeLimit(int ciphertextLimit) {
        return ciphertextLimit;
    }

    @Override
    public TlsEncodeResult encodePlaintext(long seqNo, short contentType, ProtocolVersion recordVersion, int headerAllocation, byte[] plaintext, int offset, int len) throws IOException {
        byte[] result = new byte[headerAllocation + len];
        System.arraycopy(plaintext, offset, result, headerAllocation, len);
        return new TlsEncodeResult(result, 0, result.length, contentType);
    }

    @Override
    public TlsDecodeResult decodeCiphertext(long seqNo, short recordType, ProtocolVersion recordVersion, byte[] ciphertext, int offset, int len) throws IOException {
        return new TlsDecodeResult(ciphertext, offset, len, recordType);
    }

    @Override
    public void rekeyDecoder() throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public void rekeyEncoder() throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public boolean usesOpaqueRecordTypeDecode() {
        return false;
    }

    @Override
    public boolean usesOpaqueRecordTypeEncode() {
        return false;
    }
}

