/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl;

import java.io.IOException;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCipher;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsDecodeResult;
import org.bouncycastle.tls.crypto.TlsEncodeResult;
import org.bouncycastle.tls.crypto.TlsHMAC;
import org.bouncycastle.tls.crypto.impl.TlsBlockCipherImpl;
import org.bouncycastle.tls.crypto.impl.TlsImplUtils;
import org.bouncycastle.tls.crypto.impl.TlsSuiteHMac;
import org.bouncycastle.tls.crypto.impl.TlsSuiteMac;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Integers;
import org.bouncycastle.util.Pack;

public final class TlsBlockCipher
implements TlsCipher {
    private final TlsCryptoParameters cryptoParams;
    private final byte[] randomData;
    private final boolean encryptThenMAC;
    private final boolean useExplicitIV;
    private final boolean acceptExtraPadding;
    private final boolean useExtraPadding;
    private final TlsBlockCipherImpl decryptCipher;
    private final TlsBlockCipherImpl encryptCipher;
    private final TlsSuiteMac readMac;
    private final TlsSuiteMac writeMac;
    private final byte[] decryptConnectionID;
    private final byte[] encryptConnectionID;
    private final boolean decryptUseInnerPlaintext;
    private final boolean encryptUseInnerPlaintext;

    public TlsBlockCipher(TlsCryptoParameters cryptoParams, TlsBlockCipherImpl encryptCipher, TlsBlockCipherImpl decryptCipher, TlsHMAC clientMac, TlsHMAC serverMac, int cipherKeySize) throws IOException {
        TlsBlockCipherImpl serverCipher;
        TlsBlockCipherImpl clientCipher;
        SecurityParameters securityParameters = cryptoParams.getSecurityParametersHandshake();
        ProtocolVersion negotiatedVersion = securityParameters.getNegotiatedVersion();
        if (TlsImplUtils.isTLSv13(negotiatedVersion)) {
            throw new TlsFatalAlert(80);
        }
        this.decryptConnectionID = securityParameters.getConnectionIDPeer();
        this.encryptConnectionID = securityParameters.getConnectionIDLocal();
        this.decryptUseInnerPlaintext = !Arrays.isNullOrEmpty((byte[])this.decryptConnectionID);
        this.encryptUseInnerPlaintext = !Arrays.isNullOrEmpty((byte[])this.encryptConnectionID);
        this.cryptoParams = cryptoParams;
        this.randomData = cryptoParams.getNonceGenerator().generateNonce(256);
        this.encryptThenMAC = securityParameters.isEncryptThenMAC();
        this.useExplicitIV = TlsImplUtils.isTLSv11(negotiatedVersion);
        this.acceptExtraPadding = !negotiatedVersion.isSSL();
        this.useExtraPadding = securityParameters.isExtendedPadding() && ProtocolVersion.TLSv10.isEqualOrEarlierVersionOf(negotiatedVersion) && (this.encryptThenMAC || !securityParameters.isTruncatedHMac());
        this.encryptCipher = encryptCipher;
        this.decryptCipher = decryptCipher;
        if (cryptoParams.isServer()) {
            clientCipher = decryptCipher;
            serverCipher = encryptCipher;
        } else {
            clientCipher = encryptCipher;
            serverCipher = decryptCipher;
        }
        int key_block_size = 2 * cipherKeySize + clientMac.getMacLength() + serverMac.getMacLength();
        if (!this.useExplicitIV) {
            key_block_size += clientCipher.getBlockSize() + serverCipher.getBlockSize();
        }
        byte[] key_block = TlsImplUtils.calculateKeyBlock(cryptoParams, key_block_size);
        int offset = 0;
        clientMac.setKey(key_block, offset, clientMac.getMacLength());
        serverMac.setKey(key_block, offset += clientMac.getMacLength(), serverMac.getMacLength());
        clientCipher.setKey(key_block, offset += serverMac.getMacLength(), cipherKeySize);
        serverCipher.setKey(key_block, offset += cipherKeySize, cipherKeySize);
        offset += cipherKeySize;
        int clientIVLength = clientCipher.getBlockSize();
        int serverIVLength = serverCipher.getBlockSize();
        if (this.useExplicitIV) {
            clientCipher.init(new byte[clientIVLength], 0, clientIVLength);
            serverCipher.init(new byte[serverIVLength], 0, serverIVLength);
        } else {
            clientCipher.init(key_block, offset, clientIVLength);
            serverCipher.init(key_block, offset += clientIVLength, serverIVLength);
            offset += serverIVLength;
        }
        if (offset != key_block_size) {
            throw new TlsFatalAlert(80);
        }
        if (cryptoParams.isServer()) {
            this.writeMac = new TlsSuiteHMac(cryptoParams, serverMac);
            this.readMac = new TlsSuiteHMac(cryptoParams, clientMac);
        } else {
            this.writeMac = new TlsSuiteHMac(cryptoParams, clientMac);
            this.readMac = new TlsSuiteHMac(cryptoParams, serverMac);
        }
    }

    @Override
    public int getCiphertextDecodeLimit(int plaintextLimit) {
        int blockSize = this.decryptCipher.getBlockSize();
        int macSize = this.readMac.getSize();
        int maxPadding = 256;
        int innerPlaintextLimit = plaintextLimit + (this.decryptUseInnerPlaintext ? 1 : 0);
        return this.getCiphertextLength(blockSize, macSize, maxPadding, innerPlaintextLimit);
    }

    @Override
    public int getCiphertextEncodeLimit(int plaintextLimit) {
        int blockSize = this.encryptCipher.getBlockSize();
        int macSize = this.writeMac.getSize();
        int maxPadding = this.useExtraPadding ? 256 : blockSize;
        int innerPlaintextLimit = plaintextLimit + (this.encryptUseInnerPlaintext ? 1 : 0);
        return this.getCiphertextLength(blockSize, macSize, maxPadding, innerPlaintextLimit);
    }

    @Override
    public int getPlaintextDecodeLimit(int ciphertextLimit) {
        int blockSize = this.decryptCipher.getBlockSize();
        int macSize = this.readMac.getSize();
        int innerPlaintextLimit = this.getPlaintextLength(blockSize, macSize, ciphertextLimit);
        return innerPlaintextLimit - (this.decryptUseInnerPlaintext ? 1 : 0);
    }

    @Override
    public int getPlaintextEncodeLimit(int ciphertextLimit) {
        int blockSize = this.encryptCipher.getBlockSize();
        int macSize = this.writeMac.getSize();
        int innerPlaintextLimit = this.getPlaintextLength(blockSize, macSize, ciphertextLimit);
        return innerPlaintextLimit - (this.encryptUseInnerPlaintext ? 1 : 0);
    }

    @Override
    public TlsEncodeResult encodePlaintext(long seqNo, short contentType, ProtocolVersion recordVersion, int headerAllocation, byte[] plaintext, int offset, int len) throws IOException {
        int innerPlaintextLength;
        int blockSize = this.encryptCipher.getBlockSize();
        int macSize = this.writeMac.getSize();
        int enc_input_length = innerPlaintextLength = len + (this.encryptUseInnerPlaintext ? 1 : 0);
        if (!this.encryptThenMAC) {
            enc_input_length += macSize;
        }
        int padding_length = blockSize - enc_input_length % blockSize;
        if (this.useExtraPadding) {
            int maxExtraPadBlocks = (256 - padding_length) / blockSize;
            int actualExtraPadBlocks = this.chooseExtraPadBlocks(maxExtraPadBlocks);
            padding_length += actualExtraPadBlocks * blockSize;
        }
        int totalSize = innerPlaintextLength + macSize + padding_length;
        if (this.useExplicitIV) {
            totalSize += blockSize;
        }
        byte[] outBuf = new byte[headerAllocation + totalSize];
        int outOff = headerAllocation;
        if (this.useExplicitIV) {
            byte[] explicitIV = this.cryptoParams.getNonceGenerator().generateNonce(blockSize);
            System.arraycopy(explicitIV, 0, outBuf, outOff, blockSize);
            outOff += blockSize;
        }
        int innerPlaintextOffset = outOff;
        System.arraycopy(plaintext, offset, outBuf, outOff, len);
        outOff += len;
        short recordType = contentType;
        if (this.encryptUseInnerPlaintext) {
            outBuf[outOff++] = (byte)contentType;
            recordType = 25;
        }
        if (!this.encryptThenMAC) {
            byte[] mac = this.writeMac.calculateMac(seqNo, recordType, this.encryptConnectionID, outBuf, innerPlaintextOffset, innerPlaintextLength);
            System.arraycopy(mac, 0, outBuf, outOff, mac.length);
            outOff += mac.length;
        }
        byte padByte = (byte)(padding_length - 1);
        for (int i = 0; i < padding_length; ++i) {
            outBuf[outOff++] = padByte;
        }
        this.encryptCipher.doFinal(outBuf, headerAllocation, outOff - headerAllocation, outBuf, headerAllocation);
        if (this.encryptThenMAC) {
            byte[] mac = this.writeMac.calculateMac(seqNo, recordType, this.encryptConnectionID, outBuf, headerAllocation, outOff - headerAllocation);
            System.arraycopy(mac, 0, outBuf, outOff, mac.length);
            outOff += mac.length;
        }
        if (outOff != outBuf.length) {
            throw new TlsFatalAlert(80);
        }
        return new TlsEncodeResult(outBuf, 0, outBuf.length, recordType);
    }

    @Override
    public TlsDecodeResult decodeCiphertext(long seqNo, short recordType, ProtocolVersion recordVersion, byte[] ciphertext, int offset, int len) throws IOException {
        int plaintextLength;
        short contentType;
        block9: {
            byte octet;
            byte[] expectedMac;
            boolean checkMac;
            int blockSize = this.decryptCipher.getBlockSize();
            int macSize = this.readMac.getSize();
            int minLen = blockSize;
            minLen = this.encryptThenMAC ? (minLen += macSize) : Math.max(minLen, macSize + 1);
            if (this.useExplicitIV) {
                minLen += blockSize;
            }
            if (len < minLen) {
                throw new TlsFatalAlert(50);
            }
            int blocks_length = len;
            if (this.encryptThenMAC) {
                blocks_length -= macSize;
            }
            if (blocks_length % blockSize != 0) {
                throw new TlsFatalAlert(21);
            }
            if (this.encryptThenMAC && !(checkMac = TlsUtils.constantTimeAreEqual(macSize, expectedMac = this.readMac.calculateMac(seqNo, recordType, this.decryptConnectionID, ciphertext, offset, len - macSize), 0, ciphertext, offset + len - macSize))) {
                throw new TlsFatalAlert(20);
            }
            this.decryptCipher.doFinal(ciphertext, offset, blocks_length, ciphertext, offset);
            if (this.useExplicitIV) {
                offset += blockSize;
                blocks_length -= blockSize;
            }
            int totalPad = this.checkPaddingConstantTime(ciphertext, offset, blocks_length, blockSize, this.encryptThenMAC ? 0 : macSize);
            boolean badMac = totalPad == 0;
            int innerPlaintextLength = blocks_length - totalPad;
            if (!this.encryptThenMAC) {
                byte[] expectedMac2 = this.readMac.calculateMacConstantTime(seqNo, recordType, this.decryptConnectionID, ciphertext, offset, innerPlaintextLength -= macSize, blocks_length - macSize, this.randomData);
                badMac |= !TlsUtils.constantTimeAreEqual(macSize, expectedMac2, 0, ciphertext, offset + innerPlaintextLength);
            }
            if (badMac) {
                throw new TlsFatalAlert(20);
            }
            contentType = recordType;
            plaintextLength = innerPlaintextLength;
            if (!this.decryptUseInnerPlaintext) break block9;
            do {
                if (--plaintextLength >= 0) continue;
                throw new TlsFatalAlert(10);
            } while (0 == (octet = ciphertext[offset + plaintextLength]));
            contentType = (short)(octet & 0xFF);
        }
        return new TlsDecodeResult(ciphertext, offset, plaintextLength, contentType);
    }

    @Override
    public void rekeyDecoder() throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public void rekeyEncoder() throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public boolean usesOpaqueRecordTypeDecode() {
        return this.decryptUseInnerPlaintext;
    }

    @Override
    public boolean usesOpaqueRecordTypeEncode() {
        return this.encryptUseInnerPlaintext;
    }

    private int checkPaddingConstantTime(byte[] buf, int off, int len, int blockSize, int macSize) {
        int end = off + len;
        byte lastByte = buf[end - 1];
        int padlen = lastByte & 0xFF;
        int totalPad = padlen + 1;
        int dummyIndex = 0;
        int padDiff = 0;
        int totalPadLimit = Math.min(this.acceptExtraPadding ? 256 : blockSize, len - macSize);
        if (totalPad > totalPadLimit) {
            totalPad = 0;
        } else {
            int padPos = end - totalPad;
            do {
                padDiff = (byte)(padDiff | buf[padPos++] ^ lastByte);
            } while (padPos < end);
            dummyIndex = totalPad;
            if (padDiff != 0) {
                totalPad = 0;
            }
        }
        byte[] dummyPad = this.randomData;
        while (dummyIndex < 256) {
            padDiff = (byte)(padDiff | dummyPad[dummyIndex++] ^ lastByte);
        }
        dummyPad[0] = (byte)(dummyPad[0] ^ padDiff);
        return totalPad;
    }

    private int chooseExtraPadBlocks(int max) {
        byte[] random = this.cryptoParams.getNonceGenerator().generateNonce(4);
        int x = Pack.littleEndianToInt((byte[])random, (int)0);
        int n = Integers.numberOfTrailingZeros((int)x);
        return Math.min(n, max);
    }

    private int getCiphertextLength(int blockSize, int macSize, int maxPadding, int plaintextLength) {
        int ciphertextLength = plaintextLength;
        if (this.useExplicitIV) {
            ciphertextLength += blockSize;
        }
        ciphertextLength += maxPadding;
        if (this.encryptThenMAC) {
            ciphertextLength -= ciphertextLength % blockSize;
            ciphertextLength += macSize;
        } else {
            ciphertextLength += macSize;
            ciphertextLength -= ciphertextLength % blockSize;
        }
        return ciphertextLength;
    }

    private int getPlaintextLength(int blockSize, int macSize, int ciphertextLength) {
        int plaintextLength = ciphertextLength;
        if (this.encryptThenMAC) {
            plaintextLength -= macSize;
            plaintextLength -= plaintextLength % blockSize;
        } else {
            plaintextLength -= plaintextLength % blockSize;
            plaintextLength -= macSize;
        }
        --plaintextLength;
        if (this.useExplicitIV) {
            plaintextLength -= blockSize;
        }
        return plaintextLength;
    }
}

