/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl;

import java.io.IOException;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCipher;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsDecodeResult;
import org.bouncycastle.tls.crypto.TlsEncodeResult;
import org.bouncycastle.tls.crypto.TlsHMAC;
import org.bouncycastle.tls.crypto.impl.TlsImplUtils;
import org.bouncycastle.tls.crypto.impl.TlsSuiteHMac;
import org.bouncycastle.util.Arrays;

public final class TlsNullCipher
implements TlsCipher {
    private final TlsSuiteHMac readMac;
    private final TlsSuiteHMac writeMac;
    private final byte[] decryptConnectionID;
    private final byte[] encryptConnectionID;
    private final boolean decryptUseInnerPlaintext;
    private final boolean encryptUseInnerPlaintext;

    public TlsNullCipher(TlsCryptoParameters cryptoParams, TlsHMAC clientMac, TlsHMAC serverMac) throws IOException {
        SecurityParameters securityParameters = cryptoParams.getSecurityParametersHandshake();
        ProtocolVersion negotiatedVersion = securityParameters.getNegotiatedVersion();
        if (TlsImplUtils.isTLSv13(negotiatedVersion)) {
            throw new TlsFatalAlert(80);
        }
        this.decryptConnectionID = securityParameters.getConnectionIDPeer();
        this.encryptConnectionID = securityParameters.getConnectionIDLocal();
        this.decryptUseInnerPlaintext = !Arrays.isNullOrEmpty((byte[])this.decryptConnectionID);
        this.encryptUseInnerPlaintext = !Arrays.isNullOrEmpty((byte[])this.encryptConnectionID);
        int key_block_size = clientMac.getMacLength() + serverMac.getMacLength();
        byte[] key_block = TlsImplUtils.calculateKeyBlock(cryptoParams, key_block_size);
        int offset = 0;
        clientMac.setKey(key_block, offset, clientMac.getMacLength());
        serverMac.setKey(key_block, offset += clientMac.getMacLength(), serverMac.getMacLength());
        if ((offset += serverMac.getMacLength()) != key_block_size) {
            throw new TlsFatalAlert(80);
        }
        if (cryptoParams.isServer()) {
            this.writeMac = new TlsSuiteHMac(cryptoParams, serverMac);
            this.readMac = new TlsSuiteHMac(cryptoParams, clientMac);
        } else {
            this.writeMac = new TlsSuiteHMac(cryptoParams, clientMac);
            this.readMac = new TlsSuiteHMac(cryptoParams, serverMac);
        }
    }

    @Override
    public int getCiphertextDecodeLimit(int plaintextLimit) {
        int innerPlaintextLimit = plaintextLimit + (this.decryptUseInnerPlaintext ? 1 : 0);
        return innerPlaintextLimit + this.readMac.getSize();
    }

    @Override
    public int getCiphertextEncodeLimit(int plaintextLimit) {
        int innerPlaintextLimit = plaintextLimit + (this.encryptUseInnerPlaintext ? 1 : 0);
        return innerPlaintextLimit + this.writeMac.getSize();
    }

    @Override
    public int getPlaintextDecodeLimit(int ciphertextLimit) {
        int innerPlaintextLimit = ciphertextLimit - this.readMac.getSize();
        return innerPlaintextLimit - (this.decryptUseInnerPlaintext ? 1 : 0);
    }

    @Override
    public int getPlaintextEncodeLimit(int ciphertextLimit) {
        int innerPlaintextLimit = ciphertextLimit - this.writeMac.getSize();
        return innerPlaintextLimit - (this.encryptUseInnerPlaintext ? 1 : 0);
    }

    @Override
    public TlsEncodeResult encodePlaintext(long seqNo, short contentType, ProtocolVersion recordVersion, int headerAllocation, byte[] plaintext, int offset, int len) throws IOException {
        int macSize = this.writeMac.getSize();
        int innerPlaintextLength = len + (this.encryptUseInnerPlaintext ? 1 : 0);
        byte[] ciphertext = new byte[headerAllocation + innerPlaintextLength + macSize];
        System.arraycopy(plaintext, offset, ciphertext, headerAllocation, len);
        short recordType = contentType;
        if (this.encryptUseInnerPlaintext) {
            ciphertext[headerAllocation + len] = (byte)contentType;
            recordType = 25;
        }
        byte[] mac = this.writeMac.calculateMac(seqNo, recordType, this.encryptConnectionID, ciphertext, headerAllocation, innerPlaintextLength);
        System.arraycopy(mac, 0, ciphertext, headerAllocation + innerPlaintextLength, mac.length);
        return new TlsEncodeResult(ciphertext, 0, ciphertext.length, recordType);
    }

    @Override
    public TlsDecodeResult decodeCiphertext(long seqNo, short recordType, ProtocolVersion recordVersion, byte[] ciphertext, int offset, int len) throws IOException {
        int plaintextLength;
        short contentType;
        block3: {
            byte octet;
            boolean badMac;
            int macSize = this.readMac.getSize();
            int innerPlaintextLength = len - macSize;
            if (innerPlaintextLength < (this.decryptUseInnerPlaintext ? 1 : 0)) {
                throw new TlsFatalAlert(50);
            }
            byte[] expectedMac = this.readMac.calculateMac(seqNo, recordType, this.decryptConnectionID, ciphertext, offset, innerPlaintextLength);
            boolean bl = badMac = !TlsUtils.constantTimeAreEqual(macSize, expectedMac, 0, ciphertext, offset + innerPlaintextLength);
            if (badMac) {
                throw new TlsFatalAlert(20);
            }
            contentType = recordType;
            plaintextLength = innerPlaintextLength;
            if (!this.decryptUseInnerPlaintext) break block3;
            do {
                if (--plaintextLength >= 0) continue;
                throw new TlsFatalAlert(10);
            } while (0 == (octet = ciphertext[offset + plaintextLength]));
            contentType = (short)(octet & 0xFF);
        }
        return new TlsDecodeResult(ciphertext, offset, plaintextLength, contentType);
    }

    @Override
    public void rekeyDecoder() throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public void rekeyEncoder() throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public boolean usesOpaqueRecordTypeDecode() {
        return this.decryptUseInnerPlaintext;
    }

    @Override
    public boolean usesOpaqueRecordTypeEncode() {
        return this.encryptUseInnerPlaintext;
    }
}

