/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import java.security.SecureRandom;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.tls.TlsRsaKeyExchange;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.TlsCredentialedDecryptor;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;

public class BcDefaultTlsCredentialedDecryptor
implements TlsCredentialedDecryptor {
    protected BcTlsCrypto crypto;
    protected Certificate certificate;
    protected AsymmetricKeyParameter privateKey;

    public BcDefaultTlsCredentialedDecryptor(BcTlsCrypto crypto, Certificate certificate, AsymmetricKeyParameter privateKey) {
        if (crypto == null) {
            throw new IllegalArgumentException("'crypto' cannot be null");
        }
        if (certificate == null) {
            throw new IllegalArgumentException("'certificate' cannot be null");
        }
        if (certificate.isEmpty()) {
            throw new IllegalArgumentException("'certificate' cannot be empty");
        }
        if (privateKey == null) {
            throw new IllegalArgumentException("'privateKey' cannot be null");
        }
        if (!privateKey.isPrivate()) {
            throw new IllegalArgumentException("'privateKey' must be private");
        }
        if (!(privateKey instanceof RSAKeyParameters)) {
            throw new IllegalArgumentException("'privateKey' type not supported: " + privateKey.getClass().getName());
        }
        this.crypto = crypto;
        this.certificate = certificate;
        this.privateKey = privateKey;
    }

    @Override
    public Certificate getCertificate() {
        return this.certificate;
    }

    @Override
    public TlsSecret decrypt(TlsCryptoParameters cryptoParams, byte[] ciphertext) throws IOException {
        return this.safeDecryptPreMasterSecret(cryptoParams, (RSAKeyParameters)this.privateKey, ciphertext);
    }

    protected TlsSecret safeDecryptPreMasterSecret(TlsCryptoParameters cryptoParams, RSAKeyParameters rsaServerPrivateKey, byte[] encryptedPreMasterSecret) {
        ProtocolVersion expectedVersion = cryptoParams.getRSAPreMasterSecretVersion();
        byte[] preMasterSecret = TlsRsaKeyExchange.decryptPreMasterSecret((byte[])encryptedPreMasterSecret, (int)0, (int)encryptedPreMasterSecret.length, (RSAKeyParameters)rsaServerPrivateKey, (int)expectedVersion.getFullVersion(), (SecureRandom)this.crypto.getSecureRandom());
        return this.crypto.createSecret(preMasterSecret);
    }
}

