/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.Signature;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.crypto.TlsStreamVerifier;
import org.bouncycastle.tls.crypto.TlsVerifier;
import org.bouncycastle.tls.crypto.impl.jcajce.Exceptions;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;

public abstract class JcaTlsDSSVerifier
implements TlsVerifier {
    protected final JcaTlsCrypto crypto;
    protected final PublicKey publicKey;
    protected final short algorithmType;
    protected final String algorithmName;

    protected JcaTlsDSSVerifier(JcaTlsCrypto crypto, PublicKey publicKey, short algorithmType, String algorithmName) {
        if (null == crypto) {
            throw new NullPointerException("crypto");
        }
        if (null == publicKey) {
            throw new NullPointerException("publicKey");
        }
        this.crypto = crypto;
        this.publicKey = publicKey;
        this.algorithmType = algorithmType;
        this.algorithmName = algorithmName;
    }

    @Override
    public TlsStreamVerifier getStreamVerifier(DigitallySigned digitallySigned) throws IOException {
        return null;
    }

    @Override
    public boolean verifyRawSignature(DigitallySigned digitallySigned, byte[] hash) {
        SignatureAndHashAlgorithm algorithm = digitallySigned.getAlgorithm();
        if (algorithm != null && algorithm.getSignature() != this.algorithmType) {
            throw new IllegalStateException("Invalid algorithm: " + algorithm);
        }
        try {
            Signature signer = this.crypto.getHelper().createSignature(this.algorithmName);
            signer.initVerify(this.publicKey);
            if (algorithm == null) {
                signer.update(hash, 16, 20);
            } else {
                signer.update(hash, 0, hash.length);
            }
            return signer.verify(digitallySigned.getSignature());
        }
        catch (GeneralSecurityException e) {
            throw Exceptions.illegalStateException("unable to process signature: " + e.getMessage(), e);
        }
    }
}

