/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsSigner;
import org.bouncycastle.tls.crypto.TlsStreamSigner;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaUtils;

public class JcaTlsRSASigner
implements TlsSigner {
    private final JcaTlsCrypto crypto;
    private final PrivateKey privateKey;
    private final PublicKey publicKey;
    private Signature rawSigner = null;

    public JcaTlsRSASigner(JcaTlsCrypto crypto, PrivateKey privateKey, PublicKey publicKey) {
        if (null == crypto) {
            throw new NullPointerException("crypto");
        }
        if (null == privateKey) {
            throw new NullPointerException("privateKey");
        }
        this.crypto = crypto;
        this.privateKey = privateKey;
        this.publicKey = publicKey;
    }

    @Override
    public byte[] generateRawSignature(SignatureAndHashAlgorithm algorithm, byte[] hash) throws IOException {
        try {
            byte[] input;
            Signature signer = this.getRawSigner();
            if (algorithm != null) {
                if (algorithm.getSignature() != 1) {
                    throw new IllegalStateException("Invalid algorithm: " + algorithm);
                }
                AlgorithmIdentifier algID = new AlgorithmIdentifier(TlsUtils.getOIDForHashAlgorithm(algorithm.getHash()), (ASN1Encodable)DERNull.INSTANCE);
                input = new DigestInfo(algID, hash).getEncoded();
            } else {
                input = hash;
            }
            signer.update(input, 0, input.length);
            byte[] signature = signer.sign();
            signer.initVerify(this.publicKey);
            signer.update(input, 0, input.length);
            if (signer.verify(signature)) {
                byte[] byArray = signature;
                return byArray;
            }
        }
        catch (GeneralSecurityException e) {
            throw new TlsFatalAlert(80, (Throwable)e);
        }
        finally {
            this.rawSigner = null;
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsStreamSigner getStreamSigner(SignatureAndHashAlgorithm algorithm) throws IOException {
        if (algorithm != null && 1 == algorithm.getSignature() && JcaUtils.isSunMSCAPIProviderActive() && this.isSunMSCAPIRawSigner()) {
            return this.crypto.createVerifyingStreamSigner(algorithm, this.privateKey, true, this.publicKey);
        }
        return null;
    }

    protected Signature getRawSigner() throws GeneralSecurityException {
        if (this.rawSigner == null) {
            this.rawSigner = this.crypto.getHelper().createSignature("NoneWithRSA");
            this.rawSigner.initSign(this.privateKey, this.crypto.getSecureRandom());
        }
        return this.rawSigner;
    }

    protected boolean isSunMSCAPIRawSigner() throws IOException {
        try {
            Signature rawSigner = this.getRawSigner();
            return JcaUtils.isSunMSCAPIProvider(rawSigner.getProvider());
        }
        catch (GeneralSecurityException e) {
            return true;
        }
    }
}

