/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.impl.TlsBlockCipherImpl;
import org.bouncycastle.tls.crypto.impl.jcajce.Exceptions;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;

public class JceBlockCipherWithCBCImplicitIVImpl
implements TlsBlockCipherImpl {
    private static final int BUF_SIZE = 32768;
    private final JcaTlsCrypto crypto;
    private final Cipher cipher;
    private final String algorithm;
    private final int cipherMode;
    private SecretKey key;
    private byte[] nextIV;

    public JceBlockCipherWithCBCImplicitIVImpl(JcaTlsCrypto crypto, Cipher cipher, String algorithm, boolean isEncrypting) throws GeneralSecurityException {
        this.crypto = crypto;
        this.cipher = cipher;
        this.algorithm = algorithm;
        this.cipherMode = isEncrypting ? 1 : 2;
    }

    @Override
    public void setKey(byte[] key, int keyOff, int keyLen) {
        this.key = new SecretKeySpec(key, keyOff, keyLen, this.algorithm);
    }

    @Override
    public void init(byte[] iv, int ivOff, int ivLen) {
        if (this.nextIV != null) {
            throw new IllegalStateException("unexpected reinitialization of an implicit-IV cipher");
        }
        this.nextIV = TlsUtils.copyOfRangeExact(iv, ivOff, ivOff + ivLen);
    }

    @Override
    public int doFinal(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) {
        SecureRandom random = this.crypto.getSecureRandom();
        try {
            this.cipher.init(this.cipherMode, (Key)this.key, new IvParameterSpec(this.nextIV), random);
            this.nextIV = null;
            if (1 != this.cipherMode) {
                this.nextIV = TlsUtils.copyOfRangeExact(input, inputOffset + inputLength - this.cipher.getBlockSize(), inputOffset + inputLength);
            }
            int totLen = 0;
            while (inputLength > 32768) {
                totLen += this.cipher.update(input, inputOffset, 32768, output, outputOffset + totLen);
                inputOffset += 32768;
                inputLength -= 32768;
            }
            totLen += this.cipher.update(input, inputOffset, inputLength, output, outputOffset + totLen);
            totLen += this.cipher.doFinal(output, outputOffset + totLen);
            if (1 == this.cipherMode) {
                this.nextIV = TlsUtils.copyOfRangeExact(output, outputOffset + totLen - this.cipher.getBlockSize(), outputOffset + totLen);
            }
            return totLen;
        }
        catch (GeneralSecurityException e) {
            throw Exceptions.illegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }
}

