/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.spec.KeySpec;
import java.util.Arrays;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import org.bouncycastle.tls.TlsDHUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.DHGroup;
import org.bouncycastle.tls.crypto.TlsAgreement;
import org.bouncycastle.tls.crypto.TlsCryptoException;
import org.bouncycastle.tls.crypto.TlsDHConfig;
import org.bouncycastle.tls.crypto.TlsDHDomain;
import org.bouncycastle.tls.crypto.impl.jcajce.DHUtil;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsDH;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsSecret;
import org.bouncycastle.util.BigIntegers;

public class JceTlsDHDomain
implements TlsDHDomain {
    protected final JcaTlsCrypto crypto;
    protected final TlsDHConfig dhConfig;
    protected final DHParameterSpec dhSpec;

    private static byte[] encodeValue(DHParameterSpec dh, boolean padded, BigInteger x) {
        return padded ? BigIntegers.asUnsignedByteArray((int)JceTlsDHDomain.getValueLength(dh), (BigInteger)x) : BigIntegers.asUnsignedByteArray((BigInteger)x);
    }

    private static int getValueLength(DHParameterSpec dh) {
        return (dh.getP().bitLength() + 7) / 8;
    }

    public static JceTlsSecret calculateDHAgreement(JcaTlsCrypto crypto, DHPrivateKey privateKey, DHPublicKey publicKey, boolean padded) throws IOException {
        try {
            byte[] secret = crypto.calculateKeyAgreement("DiffieHellman", privateKey, publicKey, "TlsPremasterSecret");
            if (padded) {
                int length = JceTlsDHDomain.getValueLength(privateKey.getParams());
                byte[] tmp = new byte[length];
                System.arraycopy(secret, 0, tmp, length - secret.length, secret.length);
                Arrays.fill(secret, (byte)0);
                secret = tmp;
            }
            return crypto.adoptLocalSecret(secret);
        }
        catch (GeneralSecurityException e) {
            throw new TlsCryptoException("cannot calculate secret", e);
        }
    }

    public JceTlsDHDomain(JcaTlsCrypto crypto, TlsDHConfig dhConfig) {
        DHParameterSpec spec;
        DHGroup dhGroup = TlsDHUtils.getDHGroup(dhConfig);
        if (null != dhGroup && null != (spec = DHUtil.getDHParameterSpec(crypto, dhGroup))) {
            this.crypto = crypto;
            this.dhConfig = dhConfig;
            this.dhSpec = spec;
            return;
        }
        throw new IllegalArgumentException("No DH configuration provided");
    }

    public JceTlsSecret calculateDHAgreement(DHPrivateKey privateKey, DHPublicKey publicKey) throws IOException {
        return JceTlsDHDomain.calculateDHAgreement(this.crypto, privateKey, publicKey, this.dhConfig.isPadded());
    }

    @Override
    public TlsAgreement createDH() {
        return new JceTlsDH(this);
    }

    public BigInteger decodeParameter(byte[] encoding) throws IOException {
        if (this.dhConfig.isPadded() && JceTlsDHDomain.getValueLength(this.dhSpec) != encoding.length) {
            throw new TlsFatalAlert(47);
        }
        return new BigInteger(1, encoding);
    }

    public DHPublicKey decodePublicKey(byte[] encoding) throws IOException {
        try {
            BigInteger y = this.decodeParameter(encoding);
            KeySpec publicKeySpec = DHUtil.createPublicKeySpec(y, this.dhSpec);
            KeyFactory keyFactory = this.crypto.getHelper().createKeyFactory("DiffieHellman");
            return (DHPublicKey)keyFactory.generatePublic(publicKeySpec);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TlsFatalAlert(40, (Throwable)e);
        }
    }

    public byte[] encodeParameter(BigInteger x) throws IOException {
        return JceTlsDHDomain.encodeValue(this.dhSpec, this.dhConfig.isPadded(), x);
    }

    public byte[] encodePublicKey(DHPublicKey publicKey) throws IOException {
        return JceTlsDHDomain.encodeValue(this.dhSpec, true, publicKey.getY());
    }

    public KeyPair generateKeyPair() throws IOException {
        try {
            KeyPairGenerator keyPairGenerator = this.crypto.getHelper().createKeyPairGenerator("DiffieHellman");
            keyPairGenerator.initialize(this.dhSpec, this.crypto.getSecureRandom());
            return keyPairGenerator.generateKeyPair();
        }
        catch (GeneralSecurityException e) {
            throw new TlsCryptoException("unable to create key pair", e);
        }
    }
}

