/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import com.github.zhkl0228.impersonator.ImpersonatorApi;
import com.github.zhkl0228.impersonator.ImpersonatorFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.EventListener;
import okhttp3.Headers;
import okhttp3.Http2Connection;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.OkHttpClientBuilderFactory;
import okhttp3.OkHttpClientFactory;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.SocketFactory;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultHttpClientFactory
extends OkHttpClientFactory {
    private static final Logger log = LoggerFactory.getLogger(DefaultHttpClientFactory.class);
    private final ImpersonatorFactory api;
    private final OkHttpClientBuilderFactory okHttpClientBuilderFactory;

    public DefaultHttpClientFactory(ImpersonatorApi api, OkHttpClientBuilderFactory okHttpClientBuilderFactory) {
        if (!(api instanceof ImpersonatorFactory)) {
            throw new UnsupportedOperationException("Only ImpersonatorFactory instances are supported");
        }
        this.api = (ImpersonatorFactory)api;
        this.okHttpClientBuilderFactory = okHttpClientBuilderFactory;
    }

    @Override
    public OkHttpClient newHttpClient() {
        return this.newHttpClient((String)null);
    }

    @Override
    public OkHttpClient newHttpClient(SocketFactory socketFactory) {
        return this.newHttpClientInternal(null, new TrustManager[]{new ImpersonatorFactory.DummyX509KeyManager()}, null, socketFactory);
    }

    @Override
    public OkHttpClient newHttpClient(String userAgent) {
        return this.newHttpClient(null, new TrustManager[]{new ImpersonatorFactory.DummyX509KeyManager()}, userAgent);
    }

    @Override
    public OkHttpClient newHttpClient(KeyManager[] km, TrustManager[] tm, String userAgent) {
        return this.newHttpClientInternal(km, tm, userAgent, null);
    }

    private OkHttpClient newHttpClientInternal(KeyManager[] km, TrustManager[] tm, String userAgent, SocketFactory socketFactory) {
        OkHttpClient.Builder builder = this.okHttpClientBuilderFactory == null ? new OkHttpClient.Builder() : this.okHttpClientBuilderFactory.newOkHttpClientBuilder();
        X509TrustManager trustManager = DefaultHttpClientFactory.getX509KeyManager(tm);
        if (socketFactory != null) {
            builder.socketFactory(new OkHttpClientSocketFactory(socketFactory));
        }
        builder.sslSocketFactory(this.api.newSSLContext(km, new TrustManager[]{trustManager}).getSocketFactory(), trustManager);
        builder.addInterceptor(new ImpersonatorInterceptor(userAgent == null ? this.api.getUserAgent() : userAgent));
        builder.eventListener(new EventListener(){

            @Override
            public void onHttp2ConnectionInit(@NotNull Http2Connection http2Connection) {
                DefaultHttpClientFactory.this.api.onHttp2ConnectionInit(http2Connection);
            }
        });
        return builder.build();
    }

    private void onInterceptRequest(Request.Builder builder, Map<String, String> headers) {
        this.api.fillRequestHeaders(headers);
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            builder.header(entry.getKey(), entry.getValue());
        }
    }

    private static X509TrustManager getX509KeyManager(TrustManager[] tm) {
        Object trustManager = tm != null && tm.length > 0 ? (X509TrustManager)tm[0] : new ImpersonatorFactory.DummyX509KeyManager();
        return trustManager;
    }

    private class ImpersonatorInterceptor
    implements Interceptor {
        private final String userAgent;

        ImpersonatorInterceptor(String userAgent) {
            this.userAgent = userAgent;
        }

        @Override
        @NotNull
        public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
            Request request = chain.request();
            Request.Builder builder = request.newBuilder();
            LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
            Headers requestHeaders = request.headers();
            for (String name : requestHeaders.names()) {
                String value = requestHeaders.get(name);
                log.debug("intercept name={} value={}", (Object)name, (Object)value);
                builder.removeHeader(name);
                headers.put(name, value);
            }
            if (this.userAgent != null) {
                headers.put("User-Agent", this.userAgent);
            }
            DefaultHttpClientFactory.this.onInterceptRequest(builder, headers);
            return chain.proceed(builder.build());
        }
    }

    private static class OkHttpClientSocketFactory
    extends javax.net.SocketFactory {
        private final SocketFactory socketFactory;

        OkHttpClientSocketFactory(SocketFactory socketFactory) {
            this.socketFactory = socketFactory;
        }

        @Override
        public Socket createSocket() throws IOException {
            return this.socketFactory.newSocket();
        }

        @Override
        public Socket createSocket(String host, int port) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Socket createSocket(InetAddress host, int port) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) {
            throw new UnsupportedOperationException();
        }
    }
}

