/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.Headers;
import okhttp3.PriorityFrame;
import okhttp3.Request;
import okhttp3.internal.Util;
import okhttp3.internal.concurrent.Task;
import okhttp3.internal.concurrent.TaskQueue;
import okhttp3.internal.concurrent.TaskRunner;
import okhttp3.internal.http.RequestLine;
import okhttp3.internal.http2.ConnectionShutdownException;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.Header;
import okhttp3.internal.http2.Http2Reader;
import okhttp3.internal.http2.Http2Stream;
import okhttp3.internal.http2.Http2Writer;
import okhttp3.internal.http2.PushObserver;
import okhttp3.internal.http2.Settings;
import okhttp3.internal.platform.Platform;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00d0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b#\n\u0002\u0018\u0002\n\u0002\b\u0014\u0018\u0000 \u00ac\u00012\u00020\u00012\u00020\u0002:\b\u00ab\u0001\u00ac\u0001\u00ad\u0001\u00ae\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u000201H\u0016J\u0006\u0010Z\u001a\u00020XJ\b\u0010[\u001a\u00020XH\u0016J'\u0010[\u001a\u00020X2\u0006\u0010\\\u001a\u00020]2\u0006\u0010^\u001a\u00020]2\b\u0010_\u001a\u0004\u0018\u00010`H\u0000\u00a2\u0006\u0002\baJ\u0012\u0010b\u001a\u00020X2\b\u0010c\u001a\u0004\u0018\u00010`H\u0002J&\u0010d\u001a\u00020X2\u0016\u0010e\u001a\u0012\u0012\u0004\u0012\u00020f00j\b\u0012\u0004\u0012\u00020f`22\u0006\u0010g\u001a\u00020hJ\u0006\u0010i\u001a\u00020XJ\u0010\u0010j\u001a\u0004\u0018\u00010H2\u0006\u0010k\u001a\u00020\u0013J\u000e\u0010l\u001a\u00020\n2\u0006\u0010m\u001a\u00020\u0007J&\u0010n\u001a\u00020H2\u0006\u0010o\u001a\u00020\u00132\f\u0010p\u001a\b\u0012\u0004\u0012\u00020f0q2\u0006\u0010r\u001a\u00020\nH\u0002J\u001c\u0010n\u001a\u00020H2\f\u0010p\u001a\b\u0012\u0004\u0012\u00020f0q2\u0006\u0010r\u001a\u00020\nJ\u0006\u0010s\u001a\u00020\u0013J-\u0010t\u001a\u00020X2\u0006\u0010u\u001a\u00020\u00132\u0006\u0010v\u001a\u00020w2\u0006\u0010x\u001a\u00020\u00132\u0006\u0010y\u001a\u00020\nH\u0000\u00a2\u0006\u0002\bzJ+\u0010{\u001a\u00020X2\u0006\u0010u\u001a\u00020\u00132\f\u0010p\u001a\b\u0012\u0004\u0012\u00020f0q2\u0006\u0010y\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b|J#\u0010}\u001a\u00020X2\u0006\u0010u\u001a\u00020\u00132\f\u0010p\u001a\b\u0012\u0004\u0012\u00020f0qH\u0000\u00a2\u0006\u0002\b~J\u001f\u0010\u007f\u001a\u00020X2\u0006\u0010u\u001a\u00020\u00132\u0007\u0010\u0080\u0001\u001a\u00020]H\u0000\u00a2\u0006\u0003\b\u0081\u0001J%\u0010\u0082\u0001\u001a\u00020H2\u0006\u0010o\u001a\u00020\u00132\f\u0010p\u001a\b\u0012\u0004\u0012\u00020f0q2\u0006\u0010r\u001a\u00020\nJ\u0017\u0010\u0083\u0001\u001a\u00020\n2\u0006\u0010u\u001a\u00020\u0013H\u0000\u00a2\u0006\u0003\b\u0084\u0001J\u0019\u0010\u0085\u0001\u001a\u0004\u0018\u00010H2\u0006\u0010u\u001a\u00020\u0013H\u0000\u00a2\u0006\u0003\b\u0086\u0001J\u000f\u0010\u0087\u0001\u001a\u00020XH\u0000\u00a2\u0006\u0003\b\u0088\u0001J\u0014\u0010\u0089\u0001\u001a\u00020X2\t\u0010\u008a\u0001\u001a\u0004\u0018\u00010\u000eH\u0016J\u001a\u0010\u008b\u0001\u001a\u00020X2\u0006\u0010k\u001a\u00020\u00132\u0007\u0010\u008c\u0001\u001a\u00020\u0013H\u0016J\u0010\u0010\u008d\u0001\u001a\u00020X2\u0007\u0010\u008e\u0001\u001a\u00020(J\u0012\u0010\u008f\u0001\u001a\u00020X2\u0007\u0010\u0090\u0001\u001a\u00020\u0007H\u0016J\u0010\u0010\u0091\u0001\u001a\u00020X2\u0007\u0010\u0092\u0001\u001a\u00020]J\u001e\u0010\u0093\u0001\u001a\u00020X2\t\b\u0002\u0010\u0094\u0001\u001a\u00020\n2\b\b\u0002\u0010K\u001a\u00020LH\u0007J\u0018\u0010\u0095\u0001\u001a\u00020X2\u0007\u0010\u0096\u0001\u001a\u00020\u0007H\u0000\u00a2\u0006\u0003\b\u0097\u0001J,\u0010\u0098\u0001\u001a\u00020X2\u0006\u0010u\u001a\u00020\u00132\u0007\u0010\u0099\u0001\u001a\u00020\n2\n\u0010\u009a\u0001\u001a\u0005\u0018\u00010\u009b\u00012\u0006\u0010x\u001a\u00020\u0007J/\u0010\u009c\u0001\u001a\u00020X2\u0006\u0010u\u001a\u00020\u00132\u0007\u0010\u0099\u0001\u001a\u00020\n2\r\u0010\u009d\u0001\u001a\b\u0012\u0004\u0012\u00020f0qH\u0000\u00a2\u0006\u0003\b\u009e\u0001J\u0007\u0010\u009f\u0001\u001a\u00020XJ\"\u0010\u009f\u0001\u001a\u00020X2\u0007\u0010\u00a0\u0001\u001a\u00020\n2\u0007\u0010\u00a1\u0001\u001a\u00020\u00132\u0007\u0010\u00a2\u0001\u001a\u00020\u0013J\u0007\u0010\u00a3\u0001\u001a\u00020XJ \u0010\u00a4\u0001\u001a\u00020X2\u0006\u0010u\u001a\u00020\u00132\u0007\u0010\u0092\u0001\u001a\u00020]H\u0000\u00a2\u0006\u0003\b\u00a5\u0001J \u0010\u00a6\u0001\u001a\u00020X2\u0006\u0010u\u001a\u00020\u00132\u0007\u0010\u0080\u0001\u001a\u00020]H\u0000\u00a2\u0006\u0003\b\u00a7\u0001J \u0010\u00a8\u0001\u001a\u00020X2\u0006\u0010u\u001a\u00020\u00132\u0007\u0010\u00a9\u0001\u001a\u00020\u0007H\u0000\u00a2\u0006\u0003\b\u00aa\u0001R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u00020\u0013X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020!X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020\u0013X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u001d\"\u0004\b&\u0010\u001fR\u0011\u0010'\u001a\u00020(\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u001a\u0010+\u001a\u00020(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010*\"\u0004\b-\u0010.R\u001e\u0010/\u001a\u0012\u0012\u0004\u0012\u00020100j\b\u0012\u0004\u0012\u000201`2X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u000206X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u00108\u001a\u00020\u00072\u0006\u00107\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u001e\u0010;\u001a\u00020\u00072\u0006\u00107\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010:R\u0015\u0010=\u001a\u00060>R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010@R\u000e\u0010A\u001a\u000206X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010B\u001a\u00020CX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010ER \u0010F\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020H0GX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bI\u0010JR\u000e\u0010K\u001a\u00020LX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010M\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010N\u001a\u00020\u00072\u0006\u00107\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bO\u0010:R\u001e\u0010P\u001a\u00020\u00072\u0006\u00107\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bQ\u0010:R\u0011\u0010R\u001a\u00020S\u00a2\u0006\b\n\u0000\u001a\u0004\bT\u0010UR\u000e\u0010V\u001a\u000206X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00af\u0001"}, d2={"Lokhttp3/internal/http2/Http2Connection;", "Ljava/io/Closeable;", "Lokhttp3/Http2Connection;", "builder", "Lokhttp3/internal/http2/Http2Connection$Builder;", "(Lokhttp3/internal/http2/Http2Connection$Builder;)V", "awaitPingsSent", "", "awaitPongsReceived", "client", "", "getClient$impersonator_okhttp", "()Z", "connectionName", "", "getConnectionName$impersonator_okhttp", "()Ljava/lang/String;", "currentPushRequests", "", "", "degradedPingsSent", "degradedPongDeadlineNs", "degradedPongsReceived", "headerOrder", "intervalPingsSent", "intervalPongsReceived", "isShutdown", "lastGoodStreamId", "getLastGoodStreamId$impersonator_okhttp", "()I", "setLastGoodStreamId$impersonator_okhttp", "(I)V", "listener", "Lokhttp3/internal/http2/Http2Connection$Listener;", "getListener$impersonator_okhttp", "()Lokhttp3/internal/http2/Http2Connection$Listener;", "nextStreamId", "getNextStreamId$impersonator_okhttp", "setNextStreamId$impersonator_okhttp", "okHttpSettings", "Lokhttp3/internal/http2/Settings;", "getOkHttpSettings", "()Lokhttp3/internal/http2/Settings;", "peerSettings", "getPeerSettings", "setPeerSettings", "(Lokhttp3/internal/http2/Settings;)V", "priorityFrames", "Ljava/util/ArrayList;", "Lokhttp3/PriorityFrame;", "Lkotlin/collections/ArrayList;", "pushObserver", "Lokhttp3/internal/http2/PushObserver;", "pushQueue", "Lokhttp3/internal/concurrent/TaskQueue;", "<set-?>", "readBytesAcknowledged", "getReadBytesAcknowledged", "()J", "readBytesTotal", "getReadBytesTotal", "readerRunnable", "Lokhttp3/internal/http2/Http2Connection$ReaderRunnable;", "getReaderRunnable", "()Lokhttp3/internal/http2/Http2Connection$ReaderRunnable;", "settingsListenerQueue", "socket", "Ljava/net/Socket;", "getSocket$impersonator_okhttp", "()Ljava/net/Socket;", "streams", "", "Lokhttp3/internal/http2/Http2Stream;", "getStreams$impersonator_okhttp", "()Ljava/util/Map;", "taskRunner", "Lokhttp3/internal/concurrent/TaskRunner;", "windowSizeIncrement", "writeBytesMaximum", "getWriteBytesMaximum", "writeBytesTotal", "getWriteBytesTotal", "writer", "Lokhttp3/internal/http2/Http2Writer;", "getWriter", "()Lokhttp3/internal/http2/Http2Writer;", "writerQueue", "addPriorityFrame", "", "frame", "awaitPong", "close", "connectionCode", "Lokhttp3/internal/http2/ErrorCode;", "streamCode", "cause", "Ljava/io/IOException;", "close$impersonator_okhttp", "failConnection", "e", "fillHeaderOrder", "result", "Lokhttp3/internal/http2/Header;", "request", "Lokhttp3/Request;", "flush", "getStream", "id", "isHealthy", "nowNs", "newStream", "associatedStreamId", "requestHeaders", "", "out", "openStreamCount", "pushDataLater", "streamId", "source", "Lokio/BufferedSource;", "byteCount", "inFinished", "pushDataLater$impersonator_okhttp", "pushHeadersLater", "pushHeadersLater$impersonator_okhttp", "pushRequestLater", "pushRequestLater$impersonator_okhttp", "pushResetLater", "errorCode", "pushResetLater$impersonator_okhttp", "pushStream", "pushedStream", "pushedStream$impersonator_okhttp", "removeStream", "removeStream$impersonator_okhttp", "sendDegradedPingLater", "sendDegradedPingLater$impersonator_okhttp", "setHeaderOrder", "order", "setSetting", "value", "setSettings", "settings", "setWindowSizeIncrement", "windowUpdate", "shutdown", "statusCode", "start", "sendConnectionPreface", "updateConnectionFlowControl", "read", "updateConnectionFlowControl$impersonator_okhttp", "writeData", "outFinished", "buffer", "Lokio/Buffer;", "writeHeaders", "alternating", "writeHeaders$impersonator_okhttp", "writePing", "reply", "payload1", "payload2", "writePingAndAwaitPong", "writeSynReset", "writeSynReset$impersonator_okhttp", "writeSynResetLater", "writeSynResetLater$impersonator_okhttp", "writeWindowUpdateLater", "unacknowledgedBytesRead", "writeWindowUpdateLater$impersonator_okhttp", "Builder", "Companion", "Listener", "ReaderRunnable", "impersonator-okhttp"})
@SourceDebugExtension(value={"SMAP\nHttp2Connection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http2Connection.kt\nokhttp3/internal/http2/Http2Connection\n+ 2 TaskQueue.kt\nokhttp3/internal/concurrent/TaskQueue\n+ 3 Util.kt\nokhttp3/internal/Util\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,1069:1\n84#2,4:1070\n90#2,13:1077\n90#2,13:1090\n90#2,13:1132\n90#2,13:1145\n90#2,13:1158\n90#2,13:1171\n90#2,13:1184\n90#2,13:1197\n563#3:1074\n557#3:1076\n557#3:1103\n615#3,4:1104\n402#3,5:1108\n402#3,5:1116\n402#3,5:1122\n402#3,5:1127\n1#4:1075\n37#5,2:1113\n13309#6:1115\n13310#6:1121\n*S KotlinDebug\n*F\n+ 1 Http2Connection.kt\nokhttp3/internal/http2/Http2Connection\n*L\n163#1:1070,4\n351#1:1077,13\n372#1:1090,13\n569#1:1132,13\n617#1:1145,13\n956#1:1158,13\n974#1:1171,13\n1001#1:1184,13\n1015#1:1197,13\n194#1:1074\n330#1:1076\n413#1:1103\n457#1:1104,4\n459#1:1108,5\n472#1:1116,5\n478#1:1122,5\n483#1:1127,5\n466#1:1113,2\n471#1:1115\n471#1:1121\n*E\n"})
public final class Http2Connection
implements Closeable,
okhttp3.Http2Connection {
    @NotNull
    public static final Companion Companion;
    private final boolean client;
    @NotNull
    private final Listener listener;
    @NotNull
    private final Map<Integer, Http2Stream> streams;
    @NotNull
    private final String connectionName;
    private int lastGoodStreamId;
    private int nextStreamId;
    private boolean isShutdown;
    @NotNull
    private final TaskRunner taskRunner;
    @NotNull
    private final TaskQueue writerQueue;
    @NotNull
    private final TaskQueue pushQueue;
    @NotNull
    private final TaskQueue settingsListenerQueue;
    @NotNull
    private final PushObserver pushObserver;
    private long intervalPingsSent;
    private long intervalPongsReceived;
    private long degradedPingsSent;
    private long degradedPongsReceived;
    private long awaitPingsSent;
    private long awaitPongsReceived;
    private long degradedPongDeadlineNs;
    @NotNull
    private final Settings okHttpSettings;
    @NotNull
    private Settings peerSettings;
    private long readBytesTotal;
    private long readBytesAcknowledged;
    private long writeBytesTotal;
    private long writeBytesMaximum;
    @NotNull
    private final Socket socket;
    @NotNull
    private final Http2Writer writer;
    @NotNull
    private final ReaderRunnable readerRunnable;
    @NotNull
    private final Set<Integer> currentPushRequests;
    @Nullable
    private String headerOrder;
    private long windowSizeIncrement;
    @NotNull
    private ArrayList<PriorityFrame> priorityFrames;
    public static final int OKHTTP_CLIENT_WINDOW_SIZE = 0x1000000;
    @NotNull
    private static final Settings DEFAULT_SETTINGS;
    public static final int INTERVAL_PING = 1;
    public static final int DEGRADED_PING = 2;
    public static final int AWAIT_PING = 3;
    public static final int DEGRADED_PONG_TIMEOUT_NS = 1000000000;

    /*
     * WARNING - void declaration
     */
    public Http2Connection(@NotNull Builder builder) {
        Settings settings;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.client = builder.getClient$impersonator_okhttp();
        this.listener = builder.getListener$impersonator_okhttp();
        this.streams = new LinkedHashMap();
        this.connectionName = builder.getConnectionName$impersonator_okhttp();
        this.nextStreamId = builder.getClient$impersonator_okhttp() ? 3 : 2;
        this.taskRunner = builder.getTaskRunner$impersonator_okhttp();
        this.writerQueue = this.taskRunner.newQueue();
        this.pushQueue = this.taskRunner.newQueue();
        this.settingsListenerQueue = this.taskRunner.newQueue();
        this.pushObserver = builder.getPushObserver$impersonator_okhttp();
        Settings settings2 = settings = new Settings();
        Http2Connection http2Connection = this;
        boolean bl2 = false;
        if (builder.getClient$impersonator_okhttp()) {
            void $this$okHttpSettings_u24lambda_u240;
            $this$okHttpSettings_u24lambda_u240.set(7, 0x1000000);
        }
        http2Connection.okHttpSettings = settings;
        this.peerSettings = DEFAULT_SETTINGS;
        this.writeBytesMaximum = this.peerSettings.getInitialWindowSize();
        this.socket = builder.getSocket$impersonator_okhttp();
        this.writer = new Http2Writer(builder.getSink$impersonator_okhttp(), this.client);
        this.readerRunnable = new ReaderRunnable(new Http2Reader(builder.getSource$impersonator_okhttp(), this.client));
        this.currentPushRequests = new LinkedHashSet();
        if (builder.getPingIntervalMillis$impersonator_okhttp() != 0) {
            void this_$iv;
            long pingIntervalNanos = TimeUnit.MILLISECONDS.toNanos(builder.getPingIntervalMillis$impersonator_okhttp());
            TaskQueue bl2 = this.writerQueue;
            String name$iv = this.connectionName + " ping";
            boolean $i$f$schedule = false;
            this_$iv.schedule(new Task(name$iv, this, pingIntervalNanos){
                final /* synthetic */ Http2Connection this$0;
                final /* synthetic */ long $pingIntervalNanos$inlined;
                {
                    this.this$0 = http2Connection;
                    this.$pingIntervalNanos$inlined = l;
                    super($name, false, 2, null);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public long runOnce() {
                    long l;
                    boolean bl;
                    boolean bl2 = false;
                    Http2Connection http2Connection = this.this$0;
                    synchronized (http2Connection) {
                        boolean bl3;
                        boolean bl4 = false;
                        if (Http2Connection.access$getIntervalPongsReceived$p(this.this$0) < Http2Connection.access$getIntervalPingsSent$p(this.this$0)) {
                            bl3 = true;
                        } else {
                            long l2 = Http2Connection.access$getIntervalPingsSent$p(this.this$0);
                            Http2Connection.access$setIntervalPingsSent$p(this.this$0, l2 + 1L);
                            bl3 = false;
                        }
                        bl = bl3;
                    }
                    boolean failDueToMissingPong = bl;
                    if (failDueToMissingPong) {
                        Http2Connection.access$failConnection(this.this$0, null);
                        l = -1L;
                    } else {
                        this.this$0.writePing(false, 1, 0);
                        l = this.$pingIntervalNanos$inlined;
                    }
                    return l;
                }
            }, pingIntervalNanos);
        }
        this.windowSizeIncrement = -1L;
        this.priorityFrames = new ArrayList(10);
    }

    public final boolean getClient$impersonator_okhttp() {
        return this.client;
    }

    @NotNull
    public final Listener getListener$impersonator_okhttp() {
        return this.listener;
    }

    @NotNull
    public final Map<Integer, Http2Stream> getStreams$impersonator_okhttp() {
        return this.streams;
    }

    @NotNull
    public final String getConnectionName$impersonator_okhttp() {
        return this.connectionName;
    }

    public final int getLastGoodStreamId$impersonator_okhttp() {
        return this.lastGoodStreamId;
    }

    public final void setLastGoodStreamId$impersonator_okhttp(int n) {
        this.lastGoodStreamId = n;
    }

    public final int getNextStreamId$impersonator_okhttp() {
        return this.nextStreamId;
    }

    public final void setNextStreamId$impersonator_okhttp(int n) {
        this.nextStreamId = n;
    }

    @NotNull
    public final Settings getOkHttpSettings() {
        return this.okHttpSettings;
    }

    public void setSetting(int id, int value) {
        this.okHttpSettings.set(id, value);
    }

    @NotNull
    public final Settings getPeerSettings() {
        return this.peerSettings;
    }

    public final void setPeerSettings(@NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"<set-?>");
        this.peerSettings = settings;
    }

    public final long getReadBytesTotal() {
        return this.readBytesTotal;
    }

    public final long getReadBytesAcknowledged() {
        return this.readBytesAcknowledged;
    }

    public final long getWriteBytesTotal() {
        return this.writeBytesTotal;
    }

    public final long getWriteBytesMaximum() {
        return this.writeBytesMaximum;
    }

    @NotNull
    public final Socket getSocket$impersonator_okhttp() {
        return this.socket;
    }

    @NotNull
    public final Http2Writer getWriter() {
        return this.writer;
    }

    @NotNull
    public final ReaderRunnable getReaderRunnable() {
        return this.readerRunnable;
    }

    public final synchronized int openStreamCount() {
        return this.streams.size();
    }

    @Nullable
    public final synchronized Http2Stream getStream(int id) {
        return this.streams.get(id);
    }

    @Nullable
    public final synchronized Http2Stream removeStream$impersonator_okhttp(int streamId) {
        Http2Stream stream = this.streams.remove(streamId);
        Http2Connection $this$notifyAll$iv = this;
        boolean $i$f$notifyAll = false;
        Intrinsics.checkNotNull((Object)$this$notifyAll$iv, (String)"null cannot be cast to non-null type java.lang.Object");
        ((Object)$this$notifyAll$iv).notifyAll();
        return stream;
    }

    public final synchronized void updateConnectionFlowControl$impersonator_okhttp(long read) {
        this.readBytesTotal += read;
        long readBytesToAcknowledge = this.readBytesTotal - this.readBytesAcknowledged;
        if (readBytesToAcknowledge >= (long)(this.okHttpSettings.getInitialWindowSize() / 2)) {
            this.writeWindowUpdateLater$impersonator_okhttp(0, readBytesToAcknowledge);
            this.readBytesAcknowledged += readBytesToAcknowledge;
        }
    }

    @NotNull
    public final Http2Stream pushStream(int associatedStreamId, @NotNull List<Header> requestHeaders, boolean out) throws IOException {
        Intrinsics.checkNotNullParameter(requestHeaders, (String)"requestHeaders");
        if (!(!this.client)) {
            boolean bl = false;
            String string = "Client cannot push requests.";
            throw new IllegalStateException(string.toString());
        }
        return this.newStream(associatedStreamId, requestHeaders, out);
    }

    @NotNull
    public final Http2Stream newStream(@NotNull List<Header> requestHeaders, boolean out) throws IOException {
        Intrinsics.checkNotNullParameter(requestHeaders, (String)"requestHeaders");
        return this.newStream(0, requestHeaders, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Http2Stream newStream(int associatedStreamId, List<Header> requestHeaders, boolean out) throws IOException {
        boolean outFinished = !out;
        boolean inFinished = false;
        boolean flushHeaders = false;
        Http2Stream stream = null;
        int streamId = 0;
        Http2Writer http2Writer = this.writer;
        synchronized (http2Writer) {
            boolean bl = false;
            Http2Connection http2Connection = this;
            synchronized (http2Connection) {
                boolean $i$a$-synchronized-Http2Connection$newStream$1$22 = false;
                if (this.nextStreamId > 0x3FFFFFFF) {
                    this.shutdown(ErrorCode.REFUSED_STREAM);
                }
                if (this.isShutdown) {
                    throw new ConnectionShutdownException();
                }
                streamId = this.nextStreamId;
                this.nextStreamId += 2;
                stream = new Http2Stream(streamId, this, outFinished, inFinished, null);
                boolean bl2 = flushHeaders = !out || this.writeBytesTotal >= this.writeBytesMaximum || stream.getWriteBytesTotal() >= stream.getWriteBytesMaximum();
                if (stream.isOpen()) {
                    this.streams.put(streamId, stream);
                }
                Unit $i$a$-synchronized-Http2Connection$newStream$1$22 = Unit.INSTANCE;
            }
            if (associatedStreamId == 0) {
                this.writer.headers(outFinished, streamId, requestHeaders);
            } else {
                if (!(!this.client)) {
                    boolean bl3 = false;
                    String string = "client streams shouldn't have associated stream IDs";
                    throw new IllegalArgumentException(string.toString());
                }
                this.writer.pushPromise(associatedStreamId, streamId, requestHeaders);
            }
            Unit unit = Unit.INSTANCE;
        }
        if (flushHeaders) {
            this.writer.flush();
        }
        return stream;
    }

    public final void writeHeaders$impersonator_okhttp(int streamId, boolean outFinished, @NotNull List<Header> alternating) throws IOException {
        Intrinsics.checkNotNullParameter(alternating, (String)"alternating");
        this.writer.headers(outFinished, streamId, alternating);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeData(int streamId, boolean outFinished, @Nullable Buffer buffer, long byteCount) throws IOException {
        if (byteCount == 0L) {
            this.writer.data(outFinished, streamId, buffer, 0);
            return;
        }
        long byteCount2 = 0L;
        byteCount2 = byteCount;
        while (byteCount2 > 0L) {
            int toWrite = 0;
            Http2Connection http2Connection = this;
            synchronized (http2Connection) {
                boolean bl = false;
                try {
                    while (this.writeBytesTotal >= this.writeBytesMaximum) {
                        if (!this.streams.containsKey(streamId)) {
                            throw new IOException("stream closed");
                        }
                        Http2Connection $this$wait$iv = this;
                        boolean $i$f$wait = false;
                        Intrinsics.checkNotNull((Object)$this$wait$iv, (String)"null cannot be cast to non-null type java.lang.Object");
                        ((Object)$this$wait$iv).wait();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException();
                }
                toWrite = (int)Math.min(byteCount2, this.writeBytesMaximum - this.writeBytesTotal);
                toWrite = Math.min(toWrite, this.writer.maxDataLength());
                this.writeBytesTotal += (long)toWrite;
                Unit unit = Unit.INSTANCE;
            }
            this.writer.data(outFinished && (byteCount2 -= (long)toWrite) == 0L, streamId, buffer, toWrite);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void writeSynResetLater$impersonator_okhttp(int streamId, @NotNull ErrorCode errorCode) {
        void $this$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)errorCode), (String)"errorCode");
        TaskQueue taskQueue = this.writerQueue;
        String name$iv = this.connectionName + '[' + streamId + "] writeSynReset";
        long delayNanos$iv = 0L;
        boolean cancelable$iv = true;
        boolean $i$f$execute = false;
        $this$iv.schedule(new Task(name$iv, cancelable$iv, this, streamId, errorCode){
            final /* synthetic */ Http2Connection this$0;
            final /* synthetic */ int $streamId$inlined;
            final /* synthetic */ ErrorCode $errorCode$inlined;
            {
                this.this$0 = http2Connection;
                this.$streamId$inlined = n;
                this.$errorCode$inlined = errorCode;
                super($name, $cancelable);
            }

            public long runOnce() {
                boolean bl = false;
                try {
                    this.this$0.writeSynReset$impersonator_okhttp(this.$streamId$inlined, this.$errorCode$inlined);
                }
                catch (IOException e) {
                    Http2Connection.access$failConnection(this.this$0, e);
                }
                return -1L;
            }
        }, delayNanos$iv);
    }

    public final void writeSynReset$impersonator_okhttp(int streamId, @NotNull ErrorCode statusCode) throws IOException {
        Intrinsics.checkNotNullParameter((Object)((Object)statusCode), (String)"statusCode");
        this.writer.rstStream(streamId, statusCode);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeWindowUpdateLater$impersonator_okhttp(int streamId, long unacknowledgedBytesRead) {
        void $this$iv;
        TaskQueue taskQueue = this.writerQueue;
        String name$iv = this.connectionName + '[' + streamId + "] windowUpdate";
        long delayNanos$iv = 0L;
        boolean cancelable$iv = true;
        boolean $i$f$execute = false;
        $this$iv.schedule(new Task(name$iv, cancelable$iv, this, streamId, unacknowledgedBytesRead){
            final /* synthetic */ Http2Connection this$0;
            final /* synthetic */ int $streamId$inlined;
            final /* synthetic */ long $unacknowledgedBytesRead$inlined;
            {
                this.this$0 = http2Connection;
                this.$streamId$inlined = n;
                this.$unacknowledgedBytesRead$inlined = l;
                super($name, $cancelable);
            }

            public long runOnce() {
                boolean bl = false;
                try {
                    this.this$0.getWriter().windowUpdate(this.$streamId$inlined, this.$unacknowledgedBytesRead$inlined);
                }
                catch (IOException e) {
                    Http2Connection.access$failConnection(this.this$0, e);
                }
                return -1L;
            }
        }, delayNanos$iv);
    }

    public final void writePing(boolean reply, int payload1, int payload2) {
        try {
            this.writer.ping(reply, payload1, payload2);
        }
        catch (IOException e) {
            this.failConnection(e);
        }
    }

    public final void writePingAndAwaitPong() throws InterruptedException {
        this.writePing();
        this.awaitPong();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writePing() throws InterruptedException {
        Http2Connection http2Connection = this;
        synchronized (http2Connection) {
            boolean bl = false;
            long l = this.awaitPingsSent;
            this.awaitPingsSent = l + 1L;
            long l2 = l;
        }
        this.writePing(false, 3, 1330343787);
    }

    public final synchronized void awaitPong() throws InterruptedException {
        while (this.awaitPongsReceived < this.awaitPingsSent) {
            Http2Connection $this$wait$iv = this;
            boolean $i$f$wait = false;
            Intrinsics.checkNotNull((Object)$this$wait$iv, (String)"null cannot be cast to non-null type java.lang.Object");
            ((Object)$this$wait$iv).wait();
        }
    }

    public final void flush() throws IOException {
        this.writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void shutdown(@NotNull ErrorCode statusCode) throws IOException {
        Intrinsics.checkNotNullParameter((Object)((Object)statusCode), (String)"statusCode");
        Http2Writer http2Writer = this.writer;
        synchronized (http2Writer) {
            boolean bl = false;
            Ref.IntRef lastGoodStreamId = new Ref.IntRef();
            Http2Connection http2Connection = this;
            synchronized (http2Connection) {
                boolean bl2 = false;
                if (this.isShutdown) {
                    return;
                }
                this.isShutdown = true;
                lastGoodStreamId.element = this.lastGoodStreamId;
                Unit unit = Unit.INSTANCE;
            }
            this.writer.goAway(lastGoodStreamId.element, statusCode, Util.EMPTY_BYTE_ARRAY);
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public void close() {
        this.close$impersonator_okhttp(ErrorCode.NO_ERROR, ErrorCode.CANCEL, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close$impersonator_okhttp(@NotNull ErrorCode connectionCode, @NotNull ErrorCode streamCode, @Nullable IOException cause) {
        Intrinsics.checkNotNullParameter((Object)((Object)connectionCode), (String)"connectionCode");
        Intrinsics.checkNotNullParameter((Object)((Object)streamCode), (String)"streamCode");
        Http2Connection $this$assertThreadDoesntHoldLock$iv = this;
        boolean $i$f$assertThreadDoesntHoldLock = false;
        if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertThreadDoesntHoldLock$iv));
        }
        boolean $i$f$ignoreIoExceptions = false;
        try {
            boolean bl = false;
            this.shutdown(connectionCode);
        }
        catch (IOException iOException) {
        }
        Http2Stream[] streamsToClose = null;
        Http2Connection bl = this;
        synchronized (bl) {
            boolean $i$a$-synchronized-Http2Connection$close$32 = false;
            if (!this.streams.isEmpty()) {
                Collection<Http2Stream> $this$toTypedArray$iv = this.streams.values();
                boolean $i$f$toTypedArray = false;
                Collection<Http2Stream> thisCollection$iv = $this$toTypedArray$iv;
                streamsToClose = thisCollection$iv.toArray(new Http2Stream[0]);
                this.streams.clear();
            }
            Unit $i$a$-synchronized-Http2Connection$close$32 = Unit.INSTANCE;
        }
        Http2Stream[] http2StreamArray = streamsToClose;
        if (http2StreamArray != null) {
            Http2Stream[] $this$forEach$iv = http2StreamArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Http2Stream element$iv;
                Http2Stream stream = element$iv = $this$forEach$iv[i];
                boolean bl2 = false;
                boolean $i$f$ignoreIoExceptions2 = false;
                try {
                    boolean bl3 = false;
                    stream.close(streamCode, cause);
                    continue;
                }
                catch (IOException iOException) {
                }
            }
        }
        boolean $i$f$ignoreIoExceptions3 = false;
        try {
            boolean bl4 = false;
            this.writer.close();
        }
        catch (IOException iOException) {
        }
        $i$f$ignoreIoExceptions3 = false;
        try {
            boolean bl5 = false;
            this.socket.close();
        }
        catch (IOException iOException) {
        }
        this.writerQueue.shutdown();
        this.pushQueue.shutdown();
        this.settingsListenerQueue.shutdown();
    }

    private final void failConnection(IOException e) {
        this.close$impersonator_okhttp(ErrorCode.PROTOCOL_ERROR, ErrorCode.PROTOCOL_ERROR, e);
    }

    public void setHeaderOrder(@Nullable String order) {
        this.headerOrder = order;
    }

    public final void fillHeaderOrder(@NotNull ArrayList<Header> result, @NotNull Request request) {
        block17: {
            Intrinsics.checkNotNullParameter(result, (String)"result");
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            if (this.headerOrder == null) break block17;
            String string = this.headerOrder;
            Intrinsics.checkNotNull((Object)string);
            String[] stringArray = new String[]{","};
            Iterator iterator = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null).iterator();
            block12: while (iterator.hasNext()) {
                String token;
                switch (token = (String)iterator.next()) {
                    case "a": {
                        String host = request.header("Host");
                        if (host == null) continue block12;
                        result.add(new Header(Header.TARGET_AUTHORITY, host));
                        continue block12;
                    }
                    case "m": {
                        result.add(new Header(Header.TARGET_METHOD, request.method()));
                        continue block12;
                    }
                    case "p": {
                        result.add(new Header(Header.TARGET_PATH, RequestLine.INSTANCE.requestPath(request.url())));
                        continue block12;
                    }
                    case "s": {
                        result.add(new Header(Header.TARGET_SCHEME, request.url().scheme()));
                        continue block12;
                    }
                }
                throw new IllegalStateException("headerOrder: " + this.headerOrder);
            }
        }
    }

    public void setWindowSizeIncrement(long windowUpdate) {
        this.windowSizeIncrement = windowUpdate;
    }

    public void addPriorityFrame(@NotNull PriorityFrame frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        this.priorityFrames.add(frame);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public final void start(boolean sendConnectionPreface, @NotNull TaskRunner taskRunner) throws IOException {
        void $this$iv;
        Intrinsics.checkNotNullParameter((Object)taskRunner, (String)"taskRunner");
        if (sendConnectionPreface) {
            this.writer.connectionPreface();
            this.writer.settings(this.okHttpSettings);
            if (this.windowSizeIncrement >= 0L) {
                if (this.windowSizeIncrement > 0L) {
                    this.writer.windowUpdate(0, this.windowSizeIncrement);
                }
            } else {
                int windowSize = this.okHttpSettings.getInitialWindowSize();
                if (windowSize != 65535) {
                    this.writer.windowUpdate(0, windowSize - 65535);
                }
            }
            for (PriorityFrame priorityFrame : this.priorityFrames) {
                Intrinsics.checkNotNull((Object)priorityFrame);
                this.writer.priority(priorityFrame);
            }
        }
        TaskQueue windowSize = taskRunner.newQueue();
        String string = this.connectionName;
        Function0 block$iv = this.readerRunnable;
        long delayNanos$iv = 0L;
        boolean cancelable$iv = true;
        boolean $i$f$execute = false;
        $this$iv.schedule(new Task(string, cancelable$iv, (Function0<Unit>)block$iv){
            final /* synthetic */ Function0<Unit> $block;
            {
                this.$block = $block;
                super($name, $cancelable);
            }

            public long runOnce() {
                this.$block.invoke();
                return -1L;
            }
        }, delayNanos$iv);
    }

    public static /* synthetic */ void start$default(Http2Connection http2Connection, boolean bl, TaskRunner taskRunner, int n, Object object) throws IOException {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            taskRunner = TaskRunner.INSTANCE;
        }
        http2Connection.start(bl, taskRunner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setSettings(@NotNull Settings settings) throws IOException {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Http2Writer http2Writer = this.writer;
        synchronized (http2Writer) {
            boolean bl = false;
            Http2Connection http2Connection = this;
            synchronized (http2Connection) {
                boolean bl2 = false;
                if (this.isShutdown) {
                    throw new ConnectionShutdownException();
                }
                this.okHttpSettings.merge(settings);
                Unit unit = Unit.INSTANCE;
            }
            this.writer.settings(settings);
            Unit unit = Unit.INSTANCE;
        }
    }

    public final synchronized boolean isHealthy(long nowNs) {
        if (this.isShutdown) {
            return false;
        }
        return this.degradedPongsReceived >= this.degradedPingsSent || nowNs < this.degradedPongDeadlineNs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void sendDegradedPingLater$impersonator_okhttp() {
        void $this$iv;
        Object object = this;
        synchronized (object) {
            boolean bl = false;
            if (this.degradedPongsReceived < this.degradedPingsSent) {
                return;
            }
            long l = this.degradedPingsSent;
            this.degradedPingsSent = l + 1L;
            this.degradedPongDeadlineNs = System.nanoTime() + (long)1000000000;
            Unit $i$a$-synchronized-Http2Connection$sendDegradedPingLater$2 = Unit.INSTANCE;
        }
        object = this.writerQueue;
        String name$iv = this.connectionName + " ping";
        long delayNanos$iv = 0L;
        boolean cancelable$iv = true;
        boolean $i$f$execute = false;
        $this$iv.schedule(new Task(name$iv, cancelable$iv, this){
            final /* synthetic */ Http2Connection this$0;
            {
                this.this$0 = http2Connection;
                super($name, $cancelable);
            }

            public long runOnce() {
                boolean bl = false;
                this.this$0.writePing(false, 2, 0);
                return -1L;
            }
        }, delayNanos$iv);
    }

    public final boolean pushedStream$impersonator_okhttp(int streamId) {
        return streamId != 0 && (streamId & 1) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void pushRequestLater$impersonator_okhttp(int streamId, @NotNull List<Header> requestHeaders) {
        void $this$iv;
        Intrinsics.checkNotNullParameter(requestHeaders, (String)"requestHeaders");
        Object object = this;
        synchronized (object) {
            boolean bl = false;
            if (this.currentPushRequests.contains(streamId)) {
                this.writeSynResetLater$impersonator_okhttp(streamId, ErrorCode.PROTOCOL_ERROR);
                return;
            }
            bl = this.currentPushRequests.add(streamId);
        }
        object = this.pushQueue;
        String name$iv = this.connectionName + '[' + streamId + "] onRequest";
        long delayNanos$iv = 0L;
        boolean cancelable$iv = true;
        boolean $i$f$execute = false;
        $this$iv.schedule(new Task(name$iv, cancelable$iv, this, streamId, requestHeaders){
            final /* synthetic */ Http2Connection this$0;
            final /* synthetic */ int $streamId$inlined;
            final /* synthetic */ List $requestHeaders$inlined;
            {
                this.this$0 = http2Connection;
                this.$streamId$inlined = n;
                this.$requestHeaders$inlined = list;
                super($name, $cancelable);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public long runOnce() {
                block5: {
                    boolean bl = false;
                    boolean cancel = Http2Connection.access$getPushObserver$p(this.this$0).onRequest(this.$streamId$inlined, this.$requestHeaders$inlined);
                    boolean $i$f$ignoreIoExceptions = false;
                    try {
                        boolean bl2 = false;
                        if (!cancel) break block5;
                        this.this$0.getWriter().rstStream(this.$streamId$inlined, ErrorCode.CANCEL);
                        Http2Connection http2Connection = this.this$0;
                        synchronized (http2Connection) {
                            boolean bl3 = false;
                            boolean bl4 = Http2Connection.access$getCurrentPushRequests$p(this.this$0).remove(this.$streamId$inlined);
                        }
                    }
                    catch (IOException iOException) {
                    }
                }
                return -1L;
            }
        }, delayNanos$iv);
    }

    /*
     * WARNING - void declaration
     */
    public final void pushHeadersLater$impersonator_okhttp(int streamId, @NotNull List<Header> requestHeaders, boolean inFinished) {
        void $this$iv;
        Intrinsics.checkNotNullParameter(requestHeaders, (String)"requestHeaders");
        TaskQueue taskQueue = this.pushQueue;
        String name$iv = this.connectionName + '[' + streamId + "] onHeaders";
        long delayNanos$iv = 0L;
        boolean cancelable$iv = true;
        boolean $i$f$execute = false;
        $this$iv.schedule(new Task(name$iv, cancelable$iv, this, streamId, requestHeaders, inFinished){
            final /* synthetic */ Http2Connection this$0;
            final /* synthetic */ int $streamId$inlined;
            final /* synthetic */ List $requestHeaders$inlined;
            final /* synthetic */ boolean $inFinished$inlined;
            {
                this.this$0 = http2Connection;
                this.$streamId$inlined = n;
                this.$requestHeaders$inlined = list;
                this.$inFinished$inlined = bl;
                super($name, $cancelable);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public long runOnce() {
                block6: {
                    boolean bl = false;
                    boolean cancel = Http2Connection.access$getPushObserver$p(this.this$0).onHeaders(this.$streamId$inlined, this.$requestHeaders$inlined, this.$inFinished$inlined);
                    boolean $i$f$ignoreIoExceptions = false;
                    try {
                        boolean bl2 = false;
                        if (cancel) {
                            this.this$0.getWriter().rstStream(this.$streamId$inlined, ErrorCode.CANCEL);
                        }
                        if (!cancel && !this.$inFinished$inlined) break block6;
                        Http2Connection http2Connection = this.this$0;
                        synchronized (http2Connection) {
                            boolean bl3 = false;
                            boolean bl4 = Http2Connection.access$getCurrentPushRequests$p(this.this$0).remove(this.$streamId$inlined);
                        }
                    }
                    catch (IOException iOException) {
                    }
                }
                return -1L;
            }
        }, delayNanos$iv);
    }

    /*
     * WARNING - void declaration
     */
    public final void pushDataLater$impersonator_okhttp(int streamId, @NotNull BufferedSource source, int byteCount, boolean inFinished) throws IOException {
        void $this$iv;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Buffer buffer = new Buffer();
        source.require((long)byteCount);
        source.read(buffer, (long)byteCount);
        TaskQueue taskQueue = this.pushQueue;
        String name$iv = this.connectionName + '[' + streamId + "] onData";
        long delayNanos$iv = 0L;
        boolean cancelable$iv = true;
        boolean $i$f$execute = false;
        $this$iv.schedule(new Task(name$iv, cancelable$iv, this, streamId, buffer, byteCount, inFinished){
            final /* synthetic */ Http2Connection this$0;
            final /* synthetic */ int $streamId$inlined;
            final /* synthetic */ Buffer $buffer$inlined;
            final /* synthetic */ int $byteCount$inlined;
            final /* synthetic */ boolean $inFinished$inlined;
            {
                this.this$0 = http2Connection;
                this.$streamId$inlined = n;
                this.$buffer$inlined = buffer;
                this.$byteCount$inlined = n2;
                this.$inFinished$inlined = bl;
                super($name, $cancelable);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public long runOnce() {
                block6: {
                    boolean bl = false;
                    boolean $i$f$ignoreIoExceptions = false;
                    try {
                        boolean bl2 = false;
                        boolean cancel = Http2Connection.access$getPushObserver$p(this.this$0).onData(this.$streamId$inlined, (BufferedSource)this.$buffer$inlined, this.$byteCount$inlined, this.$inFinished$inlined);
                        if (cancel) {
                            this.this$0.getWriter().rstStream(this.$streamId$inlined, ErrorCode.CANCEL);
                        }
                        if (!cancel && !this.$inFinished$inlined) break block6;
                        Http2Connection http2Connection = this.this$0;
                        synchronized (http2Connection) {
                            boolean bl3 = false;
                            boolean bl4 = Http2Connection.access$getCurrentPushRequests$p(this.this$0).remove(this.$streamId$inlined);
                        }
                    }
                    catch (IOException iOException) {
                    }
                }
                return -1L;
            }
        }, delayNanos$iv);
    }

    /*
     * WARNING - void declaration
     */
    public final void pushResetLater$impersonator_okhttp(int streamId, @NotNull ErrorCode errorCode) {
        void $this$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)errorCode), (String)"errorCode");
        TaskQueue taskQueue = this.pushQueue;
        String name$iv = this.connectionName + '[' + streamId + "] onReset";
        long delayNanos$iv = 0L;
        boolean cancelable$iv = true;
        boolean $i$f$execute = false;
        $this$iv.schedule(new Task(name$iv, cancelable$iv, this, streamId, errorCode){
            final /* synthetic */ Http2Connection this$0;
            final /* synthetic */ int $streamId$inlined;
            final /* synthetic */ ErrorCode $errorCode$inlined;
            {
                this.this$0 = http2Connection;
                this.$streamId$inlined = n;
                this.$errorCode$inlined = errorCode;
                super($name, $cancelable);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public long runOnce() {
                boolean bl = false;
                Http2Connection.access$getPushObserver$p(this.this$0).onReset(this.$streamId$inlined, this.$errorCode$inlined);
                Http2Connection http2Connection = this.this$0;
                synchronized (http2Connection) {
                    boolean bl2 = false;
                    Http2Connection.access$getCurrentPushRequests$p(this.this$0).remove(this.$streamId$inlined);
                    Unit unit = Unit.INSTANCE;
                }
                return -1L;
            }
        }, delayNanos$iv);
    }

    @JvmOverloads
    public final void start(boolean sendConnectionPreface) throws IOException {
        Http2Connection.start$default(this, sendConnectionPreface, null, 2, null);
    }

    @JvmOverloads
    public final void start() throws IOException {
        Http2Connection.start$default(this, false, null, 3, null);
    }

    public static final /* synthetic */ long access$getIntervalPingsSent$p(Http2Connection $this) {
        return $this.intervalPingsSent;
    }

    public static final /* synthetic */ void access$setIntervalPingsSent$p(Http2Connection $this, long l) {
        $this.intervalPingsSent = l;
    }

    public static final /* synthetic */ Set access$getCurrentPushRequests$p(Http2Connection $this) {
        return $this.currentPushRequests;
    }

    public static final /* synthetic */ PushObserver access$getPushObserver$p(Http2Connection $this) {
        return $this.pushObserver;
    }

    static {
        Settings settings;
        Companion = new Companion(null);
        Settings $this$DEFAULT_SETTINGS_u24lambda_u2435 = settings = new Settings();
        boolean bl = false;
        $this$DEFAULT_SETTINGS_u24lambda_u2435.set(7, 65535);
        $this$DEFAULT_SETTINGS_u24lambda_u2435.set(5, 16384);
        DEFAULT_SETTINGS = settings;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u00107\u001a\u000208J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001eJ.\u0010)\u001a\u00020\u00002\u0006\u0010)\u001a\u00020*2\b\b\u0002\u00109\u001a\u00020\f2\b\b\u0002\u0010/\u001a\u0002002\b\b\u0002\u0010#\u001a\u00020$H\u0007R\u001a\u0010\u0002\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020$X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020*X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u001a\u0010/\u001a\u000200X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106\u00a8\u0006:"}, d2={"Lokhttp3/internal/http2/Http2Connection$Builder;", "", "client", "", "taskRunner", "Lokhttp3/internal/concurrent/TaskRunner;", "(ZLokhttp3/internal/concurrent/TaskRunner;)V", "getClient$impersonator_okhttp", "()Z", "setClient$impersonator_okhttp", "(Z)V", "connectionName", "", "getConnectionName$impersonator_okhttp", "()Ljava/lang/String;", "setConnectionName$impersonator_okhttp", "(Ljava/lang/String;)V", "listener", "Lokhttp3/internal/http2/Http2Connection$Listener;", "getListener$impersonator_okhttp", "()Lokhttp3/internal/http2/Http2Connection$Listener;", "setListener$impersonator_okhttp", "(Lokhttp3/internal/http2/Http2Connection$Listener;)V", "pingIntervalMillis", "", "getPingIntervalMillis$impersonator_okhttp", "()I", "setPingIntervalMillis$impersonator_okhttp", "(I)V", "pushObserver", "Lokhttp3/internal/http2/PushObserver;", "getPushObserver$impersonator_okhttp", "()Lokhttp3/internal/http2/PushObserver;", "setPushObserver$impersonator_okhttp", "(Lokhttp3/internal/http2/PushObserver;)V", "sink", "Lokio/BufferedSink;", "getSink$impersonator_okhttp", "()Lokio/BufferedSink;", "setSink$impersonator_okhttp", "(Lokio/BufferedSink;)V", "socket", "Ljava/net/Socket;", "getSocket$impersonator_okhttp", "()Ljava/net/Socket;", "setSocket$impersonator_okhttp", "(Ljava/net/Socket;)V", "source", "Lokio/BufferedSource;", "getSource$impersonator_okhttp", "()Lokio/BufferedSource;", "setSource$impersonator_okhttp", "(Lokio/BufferedSource;)V", "getTaskRunner$impersonator_okhttp", "()Lokhttp3/internal/concurrent/TaskRunner;", "build", "Lokhttp3/internal/http2/Http2Connection;", "peerName", "impersonator-okhttp"})
    public static final class Builder {
        private boolean client;
        @NotNull
        private final TaskRunner taskRunner;
        public Socket socket;
        public String connectionName;
        public BufferedSource source;
        public BufferedSink sink;
        @NotNull
        private Listener listener;
        @NotNull
        private PushObserver pushObserver;
        private int pingIntervalMillis;

        public Builder(boolean client, @NotNull TaskRunner taskRunner) {
            Intrinsics.checkNotNullParameter((Object)taskRunner, (String)"taskRunner");
            this.client = client;
            this.taskRunner = taskRunner;
            this.listener = Listener.REFUSE_INCOMING_STREAMS;
            this.pushObserver = PushObserver.CANCEL;
        }

        public final boolean getClient$impersonator_okhttp() {
            return this.client;
        }

        public final void setClient$impersonator_okhttp(boolean bl) {
            this.client = bl;
        }

        @NotNull
        public final TaskRunner getTaskRunner$impersonator_okhttp() {
            return this.taskRunner;
        }

        @NotNull
        public final Socket getSocket$impersonator_okhttp() {
            Socket socket = this.socket;
            if (socket != null) {
                return socket;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"socket");
            return null;
        }

        public final void setSocket$impersonator_okhttp(@NotNull Socket socket) {
            Intrinsics.checkNotNullParameter((Object)socket, (String)"<set-?>");
            this.socket = socket;
        }

        @NotNull
        public final String getConnectionName$impersonator_okhttp() {
            String string = this.connectionName;
            if (string != null) {
                return string;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"connectionName");
            return null;
        }

        public final void setConnectionName$impersonator_okhttp(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.connectionName = string;
        }

        @NotNull
        public final BufferedSource getSource$impersonator_okhttp() {
            BufferedSource bufferedSource = this.source;
            if (bufferedSource != null) {
                return bufferedSource;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"source");
            return null;
        }

        public final void setSource$impersonator_okhttp(@NotNull BufferedSource bufferedSource) {
            Intrinsics.checkNotNullParameter((Object)bufferedSource, (String)"<set-?>");
            this.source = bufferedSource;
        }

        @NotNull
        public final BufferedSink getSink$impersonator_okhttp() {
            BufferedSink bufferedSink = this.sink;
            if (bufferedSink != null) {
                return bufferedSink;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"sink");
            return null;
        }

        public final void setSink$impersonator_okhttp(@NotNull BufferedSink bufferedSink) {
            Intrinsics.checkNotNullParameter((Object)bufferedSink, (String)"<set-?>");
            this.sink = bufferedSink;
        }

        @NotNull
        public final Listener getListener$impersonator_okhttp() {
            return this.listener;
        }

        public final void setListener$impersonator_okhttp(@NotNull Listener listener) {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"<set-?>");
            this.listener = listener;
        }

        @NotNull
        public final PushObserver getPushObserver$impersonator_okhttp() {
            return this.pushObserver;
        }

        public final void setPushObserver$impersonator_okhttp(@NotNull PushObserver pushObserver) {
            Intrinsics.checkNotNullParameter((Object)pushObserver, (String)"<set-?>");
            this.pushObserver = pushObserver;
        }

        public final int getPingIntervalMillis$impersonator_okhttp() {
            return this.pingIntervalMillis;
        }

        public final void setPingIntervalMillis$impersonator_okhttp(int n) {
            this.pingIntervalMillis = n;
        }

        @JvmOverloads
        @NotNull
        public final Builder socket(@NotNull Socket socket, @NotNull String peerName, @NotNull BufferedSource source, @NotNull BufferedSink sink) throws IOException {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
            Intrinsics.checkNotNullParameter((Object)peerName, (String)"peerName");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            Builder $this$socket_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$socket_u24lambda_u240.setSocket$impersonator_okhttp(socket);
            $this$socket_u24lambda_u240.setConnectionName$impersonator_okhttp($this$socket_u24lambda_u240.client ? Util.okHttpName + ' ' + peerName : "MockWebServer " + peerName);
            $this$socket_u24lambda_u240.setSource$impersonator_okhttp(source);
            $this$socket_u24lambda_u240.setSink$impersonator_okhttp(sink);
            return builder;
        }

        public static /* synthetic */ Builder socket$default(Builder builder, Socket socket, String string, BufferedSource bufferedSource, BufferedSink bufferedSink, int n, Object object) throws IOException {
            if ((n & 2) != 0) {
                string = Util.peerName(socket);
            }
            if ((n & 4) != 0) {
                bufferedSource = Okio.buffer((Source)Okio.source((Socket)socket));
            }
            if ((n & 8) != 0) {
                bufferedSink = Okio.buffer((Sink)Okio.sink((Socket)socket));
            }
            return builder.socket(socket, string, bufferedSource, bufferedSink);
        }

        @NotNull
        public final Builder listener(@NotNull Listener listener) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            Builder $this$listener_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$listener_u24lambda_u241.listener = listener;
            return builder;
        }

        @NotNull
        public final Builder pushObserver(@NotNull PushObserver pushObserver) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)pushObserver, (String)"pushObserver");
            Builder $this$pushObserver_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$pushObserver_u24lambda_u242.pushObserver = pushObserver;
            return builder;
        }

        @NotNull
        public final Builder pingIntervalMillis(int pingIntervalMillis) {
            Builder builder;
            Builder $this$pingIntervalMillis_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$pingIntervalMillis_u24lambda_u243.pingIntervalMillis = pingIntervalMillis;
            return builder;
        }

        @NotNull
        public final Http2Connection build() {
            return new Http2Connection(this);
        }

        @JvmOverloads
        @NotNull
        public final Builder socket(@NotNull Socket socket, @NotNull String peerName, @NotNull BufferedSource source) throws IOException {
            Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
            Intrinsics.checkNotNullParameter((Object)peerName, (String)"peerName");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            return Builder.socket$default(this, socket, peerName, source, null, 8, null);
        }

        @JvmOverloads
        @NotNull
        public final Builder socket(@NotNull Socket socket, @NotNull String peerName) throws IOException {
            Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
            Intrinsics.checkNotNullParameter((Object)peerName, (String)"peerName");
            return Builder.socket$default(this, socket, peerName, null, null, 12, null);
        }

        @JvmOverloads
        @NotNull
        public final Builder socket(@NotNull Socket socket) throws IOException {
            Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
            return Builder.socket$default(this, socket, null, null, null, 14, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lokhttp3/internal/http2/Http2Connection$Companion;", "", "()V", "AWAIT_PING", "", "DEFAULT_SETTINGS", "Lokhttp3/internal/http2/Settings;", "getDEFAULT_SETTINGS", "()Lokhttp3/internal/http2/Settings;", "DEGRADED_PING", "DEGRADED_PONG_TIMEOUT_NS", "INTERVAL_PING", "OKHTTP_CLIENT_WINDOW_SIZE", "impersonator-okhttp"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Settings getDEFAULT_SETTINGS() {
            return DEFAULT_SETTINGS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH&\u00a8\u0006\r"}, d2={"Lokhttp3/internal/http2/Http2Connection$Listener;", "", "()V", "onSettings", "", "connection", "Lokhttp3/internal/http2/Http2Connection;", "settings", "Lokhttp3/internal/http2/Settings;", "onStream", "stream", "Lokhttp3/internal/http2/Http2Stream;", "Companion", "impersonator-okhttp"})
    public static abstract class Listener {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @JvmField
        @NotNull
        public static final Listener REFUSE_INCOMING_STREAMS = new Listener(){

            public void onStream(@NotNull Http2Stream stream) throws IOException {
                Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
                stream.close(ErrorCode.REFUSED_STREAM, null);
            }
        };

        public abstract void onStream(@NotNull Http2Stream var1) throws IOException;

        public void onSettings(@NotNull Http2Connection connection, @NotNull Settings settings) {
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lokhttp3/internal/http2/Http2Connection$Listener$Companion;", "", "()V", "REFUSE_INCOMING_STREAMS", "Lokhttp3/internal/http2/Http2Connection$Listener;", "impersonator-okhttp"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0086\u0004\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u000f\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\u0003H\u0016J8\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J(\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\fH\u0016J \u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0010H\u0016J.\u0010$\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010%\u001a\u00020\f2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'H\u0016J\t\u0010)\u001a\u00020\u0003H\u0096\u0002J \u0010*\u001a\u00020\u00032\u0006\u0010+\u001a\u00020\u00172\u0006\u0010,\u001a\u00020\f2\u0006\u0010-\u001a\u00020\fH\u0016J(\u0010.\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010/\u001a\u00020\f2\u0006\u00100\u001a\u00020\f2\u0006\u00101\u001a\u00020\u0017H\u0016J&\u00102\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u00103\u001a\u00020\f2\f\u00104\u001a\b\u0012\u0004\u0012\u00020(0'H\u0016J\u0018\u00105\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u00106\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u00107\u001a\u00020\u0014H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u00068"}, d2={"Lokhttp3/internal/http2/Http2Connection$ReaderRunnable;", "Lokhttp3/internal/http2/Http2Reader$Handler;", "Lkotlin/Function0;", "", "reader", "Lokhttp3/internal/http2/Http2Reader;", "(Lokhttp3/internal/http2/Http2Connection;Lokhttp3/internal/http2/Http2Reader;)V", "getReader$impersonator_okhttp", "()Lokhttp3/internal/http2/Http2Reader;", "ackSettings", "alternateService", "streamId", "", "origin", "", "protocol", "Lokio/ByteString;", "host", "port", "maxAge", "", "applyAndAckSettings", "clearPrevious", "", "settings", "Lokhttp3/internal/http2/Settings;", "data", "inFinished", "source", "Lokio/BufferedSource;", "length", "goAway", "lastGoodStreamId", "errorCode", "Lokhttp3/internal/http2/ErrorCode;", "debugData", "headers", "associatedStreamId", "headerBlock", "", "Lokhttp3/internal/http2/Header;", "invoke", "ping", "ack", "payload1", "payload2", "priority", "streamDependency", "weight", "exclusive", "pushPromise", "promisedStreamId", "requestHeaders", "rstStream", "windowUpdate", "windowSizeIncrement", "impersonator-okhttp"})
    @SourceDebugExtension(value={"SMAP\nHttp2Connection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http2Connection.kt\nokhttp3/internal/http2/Http2Connection$ReaderRunnable\n+ 2 TaskQueue.kt\nokhttp3/internal/concurrent/TaskQueue\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 Util.kt\nokhttp3/internal/Util\n*L\n1#1,1069:1\n90#2,13:1070\n90#2,13:1083\n90#2,13:1098\n90#2,13:1112\n37#3,2:1096\n37#3,2:1125\n563#4:1111\n563#4:1127\n*S KotlinDebug\n*F\n+ 1 Http2Connection.kt\nokhttp3/internal/http2/Http2Connection$ReaderRunnable\n*L\n750#1:1070,13\n778#1:1083,13\n821#1:1098,13\n869#1:1112,13\n816#1:1096,2\n887#1:1125,2\n860#1:1111\n904#1:1127\n*E\n"})
    public final class ReaderRunnable
    implements Http2Reader.Handler,
    Function0<Unit> {
        @NotNull
        private final Http2Reader reader;

        public ReaderRunnable(Http2Reader reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            this.reader = reader;
        }

        @NotNull
        public final Http2Reader getReader$impersonator_okhttp() {
            return this.reader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invoke() {
            ErrorCode connectionErrorCode = ErrorCode.INTERNAL_ERROR;
            ErrorCode streamErrorCode = ErrorCode.INTERNAL_ERROR;
            IOException errorException = null;
            try {
                this.reader.readConnectionPreface(this);
                while (this.reader.nextFrame(false, this)) {
                }
                connectionErrorCode = ErrorCode.NO_ERROR;
                streamErrorCode = ErrorCode.CANCEL;
            }
            catch (IOException e) {
                errorException = e;
                connectionErrorCode = ErrorCode.PROTOCOL_ERROR;
                streamErrorCode = ErrorCode.PROTOCOL_ERROR;
            }
            finally {
                Http2Connection.this.close$impersonator_okhttp(connectionErrorCode, streamErrorCode, errorException);
                Util.closeQuietly(this.reader);
            }
        }

        @Override
        public void data(boolean inFinished, int streamId, @NotNull BufferedSource source, int length) throws IOException {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            if (Http2Connection.this.pushedStream$impersonator_okhttp(streamId)) {
                Http2Connection.this.pushDataLater$impersonator_okhttp(streamId, source, length, inFinished);
                return;
            }
            Http2Stream dataStream = Http2Connection.this.getStream(streamId);
            if (dataStream == null) {
                Http2Connection.this.writeSynResetLater$impersonator_okhttp(streamId, ErrorCode.PROTOCOL_ERROR);
                Http2Connection.this.updateConnectionFlowControl$impersonator_okhttp(length);
                source.skip((long)length);
                return;
            }
            dataStream.receiveData(source, length);
            if (inFinished) {
                dataStream.receiveHeaders(Util.EMPTY_HEADERS, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void headers(boolean inFinished, int streamId, int associatedStreamId, @NotNull List<Header> headerBlock) {
            Intrinsics.checkNotNullParameter(headerBlock, (String)"headerBlock");
            if (Http2Connection.this.pushedStream$impersonator_okhttp(streamId)) {
                Http2Connection.this.pushHeadersLater$impersonator_okhttp(streamId, headerBlock, inFinished);
                return;
            }
            Http2Stream stream = null;
            Http2Connection http2Connection = Http2Connection.this;
            Http2Connection http2Connection2 = Http2Connection.this;
            Http2Connection http2Connection3 = http2Connection;
            synchronized (http2Connection3) {
                boolean bl = false;
                stream = http2Connection2.getStream(streamId);
                if (stream == null) {
                    void $this$iv;
                    if (http2Connection2.isShutdown) {
                        return;
                    }
                    if (streamId <= http2Connection2.getLastGoodStreamId$impersonator_okhttp()) {
                        return;
                    }
                    if (streamId % 2 == http2Connection2.getNextStreamId$impersonator_okhttp() % 2) {
                        return;
                    }
                    Headers headers = Util.toHeaders(headerBlock);
                    Http2Stream newStream = new Http2Stream(streamId, http2Connection2, false, inFinished, headers);
                    http2Connection2.setLastGoodStreamId$impersonator_okhttp(streamId);
                    Integer n = streamId;
                    http2Connection2.getStreams$impersonator_okhttp().put(n, newStream);
                    TaskQueue taskQueue = http2Connection2.taskRunner.newQueue();
                    String name$iv = http2Connection2.getConnectionName$impersonator_okhttp() + '[' + streamId + "] onStream";
                    long delayNanos$iv = 0L;
                    boolean cancelable$iv = true;
                    boolean $i$f$execute = false;
                    $this$iv.schedule(new Task(name$iv, cancelable$iv, http2Connection2, newStream){
                        final /* synthetic */ Http2Connection this$0;
                        final /* synthetic */ Http2Stream $newStream$inlined;
                        {
                            this.this$0 = http2Connection;
                            this.$newStream$inlined = http2Stream;
                            super($name, $cancelable);
                        }

                        public long runOnce() {
                            boolean bl = false;
                            try {
                                this.this$0.getListener$impersonator_okhttp().onStream(this.$newStream$inlined);
                            }
                            catch (IOException e) {
                                Platform.Companion.get().log("Http2Connection.Listener failure for " + this.this$0.getConnectionName$impersonator_okhttp(), 4, e);
                                boolean $i$f$ignoreIoExceptions = false;
                                try {
                                    boolean bl2 = false;
                                    this.$newStream$inlined.close(ErrorCode.PROTOCOL_ERROR, e);
                                }
                                catch (IOException iOException) {
                                }
                            }
                            return -1L;
                        }
                    }, delayNanos$iv);
                    return;
                }
                Unit unit = Unit.INSTANCE;
            }
            stream.receiveHeaders(Util.toHeaders(headerBlock), inFinished);
        }

        @Override
        public void rstStream(int streamId, @NotNull ErrorCode errorCode) {
            block1: {
                Http2Stream rstStream;
                Intrinsics.checkNotNullParameter((Object)((Object)errorCode), (String)"errorCode");
                if (Http2Connection.this.pushedStream$impersonator_okhttp(streamId)) {
                    Http2Connection.this.pushResetLater$impersonator_okhttp(streamId, errorCode);
                    return;
                }
                Http2Stream http2Stream = rstStream = Http2Connection.this.removeStream$impersonator_okhttp(streamId);
                if (http2Stream == null) break block1;
                http2Stream.receiveRstStream(errorCode);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void settings(boolean clearPrevious, @NotNull Settings settings) {
            void $this$iv;
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            TaskQueue taskQueue = Http2Connection.this.writerQueue;
            String name$iv = Http2Connection.this.getConnectionName$impersonator_okhttp() + " applyAndAckSettings";
            long delayNanos$iv = 0L;
            boolean cancelable$iv = true;
            boolean $i$f$execute = false;
            $this$iv.schedule(new Task(name$iv, cancelable$iv, this, clearPrevious, settings){
                final /* synthetic */ ReaderRunnable this$0;
                final /* synthetic */ boolean $clearPrevious$inlined;
                final /* synthetic */ Settings $settings$inlined;
                {
                    this.this$0 = readerRunnable;
                    this.$clearPrevious$inlined = bl;
                    this.$settings$inlined = settings;
                    super($name, $cancelable);
                }

                public long runOnce() {
                    boolean bl = false;
                    this.this$0.applyAndAckSettings(this.$clearPrevious$inlined, this.$settings$inlined);
                    return -1L;
                }
            }, delayNanos$iv);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public final void applyAndAckSettings(boolean clearPrevious, @NotNull Settings settings) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            long delta = 0L;
            Http2Stream[] streamsToNotify = null;
            Ref.ObjectRef newPeerSettings = new Ref.ObjectRef();
            Http2Stream[] http2StreamArray = Http2Connection.this.getWriter();
            Http2Connection http2Connection = Http2Connection.this;
            Http2Stream[] http2StreamArray2 = http2StreamArray;
            synchronized (http2StreamArray2) {
                boolean $i$a$-synchronized-Http2Connection$ReaderRunnable$applyAndAckSettings$32 = false;
                object = http2Connection;
                synchronized (object) {
                    void $this$iv;
                    Http2Stream[] http2StreamArray3;
                    Settings settings2;
                    boolean $i$a$-synchronized-Http2Connection$ReaderRunnable$applyAndAckSettings$1$22 = false;
                    Settings previousPeerSettings = http2Connection.getPeerSettings();
                    Ref.ObjectRef objectRef = newPeerSettings;
                    if (clearPrevious) {
                        settings2 = settings;
                    } else {
                        void $this$applyAndAckSettings_u24lambda_u247_u24lambda_u246_u24lambda_u244;
                        Settings settings3;
                        Settings settings4 = settings3 = new Settings();
                        Ref.ObjectRef objectRef2 = objectRef;
                        boolean bl = false;
                        $this$applyAndAckSettings_u24lambda_u247_u24lambda_u246_u24lambda_u244.merge(previousPeerSettings);
                        $this$applyAndAckSettings_u24lambda_u247_u24lambda_u246_u24lambda_u244.merge(settings);
                        objectRef = objectRef2;
                        settings2 = settings3;
                    }
                    objectRef.element = settings2;
                    long peerInitialWindowSize = ((Settings)newPeerSettings.element).getInitialWindowSize();
                    delta = peerInitialWindowSize - (long)previousPeerSettings.getInitialWindowSize();
                    if (delta == 0L || http2Connection.getStreams$impersonator_okhttp().isEmpty()) {
                        http2StreamArray3 = null;
                    } else {
                        Collection<Http2Stream> $this$toTypedArray$iv = http2Connection.getStreams$impersonator_okhttp().values();
                        boolean $i$f$toTypedArray = false;
                        Collection<Http2Stream> thisCollection$iv = $this$toTypedArray$iv;
                        http2StreamArray3 = thisCollection$iv.toArray(new Http2Stream[0]);
                    }
                    streamsToNotify = http2StreamArray3;
                    http2Connection.setPeerSettings((Settings)newPeerSettings.element);
                    TaskQueue $this$toTypedArray$iv = http2Connection.settingsListenerQueue;
                    String name$iv = http2Connection.getConnectionName$impersonator_okhttp() + " onSettings";
                    long delayNanos$iv = 0L;
                    boolean cancelable$iv = true;
                    boolean $i$f$execute = false;
                    $this$iv.schedule(new Task(name$iv, cancelable$iv, http2Connection, newPeerSettings){
                        final /* synthetic */ Http2Connection this$0;
                        final /* synthetic */ Ref.ObjectRef $newPeerSettings$inlined;
                        {
                            this.this$0 = http2Connection;
                            this.$newPeerSettings$inlined = objectRef;
                            super($name, $cancelable);
                        }

                        public long runOnce() {
                            boolean bl = false;
                            this.this$0.getListener$impersonator_okhttp().onSettings(this.this$0, (Settings)this.$newPeerSettings$inlined.element);
                            return -1L;
                        }
                    }, delayNanos$iv);
                    Unit $i$a$-synchronized-Http2Connection$ReaderRunnable$applyAndAckSettings$1$22 = Unit.INSTANCE;
                }
                try {
                    http2Connection.getWriter().applyAndAckSettings((Settings)newPeerSettings.element);
                }
                catch (IOException e) {
                    http2Connection.failConnection(e);
                }
                Unit $i$a$-synchronized-Http2Connection$ReaderRunnable$applyAndAckSettings$32 = Unit.INSTANCE;
            }
            if (streamsToNotify != null) {
                for (Http2Stream stream : streamsToNotify) {
                    object = stream;
                    synchronized (object) {
                        boolean bl = false;
                        stream.addBytesToWriteWindow(delta);
                        Unit unit = Unit.INSTANCE;
                    }
                }
            }
        }

        @Override
        public void ackSettings() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void ping(boolean ack, int payload1, int payload2) {
            if (ack) {
                Http2Connection http2Connection = Http2Connection.this;
                Http2Connection http2Connection2 = Http2Connection.this;
                Http2Connection http2Connection3 = http2Connection;
                synchronized (http2Connection3) {
                    Object object;
                    boolean bl = false;
                    switch (payload1) {
                        case 1: {
                            long l = http2Connection2.intervalPongsReceived;
                            http2Connection2.intervalPongsReceived = l + 1L;
                            object = l;
                            break;
                        }
                        case 2: {
                            long l = http2Connection2.degradedPongsReceived;
                            http2Connection2.degradedPongsReceived = l + 1L;
                            object = l;
                            break;
                        }
                        case 3: {
                            long l = http2Connection2.awaitPongsReceived;
                            http2Connection2.awaitPongsReceived = l + 1L;
                            Http2Connection $this$notifyAll$iv = http2Connection2;
                            boolean $i$f$notifyAll = false;
                            Intrinsics.checkNotNull((Object)$this$notifyAll$iv, (String)"null cannot be cast to non-null type java.lang.Object");
                            ((Object)$this$notifyAll$iv).notifyAll();
                            object = Unit.INSTANCE;
                            break;
                        }
                        default: {
                            object = Unit.INSTANCE;
                        }
                    }
                    Unit unit = object;
                }
            } else {
                void name$iv;
                void $this$iv;
                TaskQueue taskQueue = Http2Connection.this.writerQueue;
                String string = Http2Connection.this.getConnectionName$impersonator_okhttp() + " ping";
                Http2Connection http2Connection = Http2Connection.this;
                long delayNanos$iv = 0L;
                boolean cancelable$iv = true;
                boolean $i$f$execute = false;
                $this$iv.schedule(new Task((String)name$iv, cancelable$iv, http2Connection, payload1, payload2){
                    final /* synthetic */ Http2Connection this$0;
                    final /* synthetic */ int $payload1$inlined;
                    final /* synthetic */ int $payload2$inlined;
                    {
                        this.this$0 = http2Connection;
                        this.$payload1$inlined = n;
                        this.$payload2$inlined = n2;
                        super($name, $cancelable);
                    }

                    public long runOnce() {
                        boolean bl = false;
                        this.this$0.writePing(true, this.$payload1$inlined, this.$payload2$inlined);
                        return -1L;
                    }
                }, delayNanos$iv);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void goAway(int lastGoodStreamId, @NotNull ErrorCode errorCode, @NotNull ByteString debugData) {
            Intrinsics.checkNotNullParameter((Object)((Object)errorCode), (String)"errorCode");
            Intrinsics.checkNotNullParameter((Object)debugData, (String)"debugData");
            if (debugData.size() > 0) {
                // empty if block
            }
            Http2Stream[] streamsCopy = null;
            Http2Stream[] http2StreamArray = Http2Connection.this;
            Http2Connection http2Connection = Http2Connection.this;
            Http2Stream[] http2StreamArray2 = http2StreamArray;
            synchronized (http2StreamArray2) {
                boolean $i$a$-synchronized-Http2Connection$ReaderRunnable$goAway$22 = false;
                Collection<Http2Stream> $this$toTypedArray$iv = http2Connection.getStreams$impersonator_okhttp().values();
                boolean $i$f$toTypedArray = false;
                Collection<Http2Stream> thisCollection$iv = $this$toTypedArray$iv;
                streamsCopy = thisCollection$iv.toArray(new Http2Stream[0]);
                http2Connection.isShutdown = true;
                Unit $i$a$-synchronized-Http2Connection$ReaderRunnable$goAway$22 = Unit.INSTANCE;
            }
            for (Http2Stream http2Stream : streamsCopy) {
                if (http2Stream.getId() <= lastGoodStreamId || !http2Stream.isLocallyInitiated()) continue;
                http2Stream.receiveRstStream(ErrorCode.REFUSED_STREAM);
                Http2Connection.this.removeStream$impersonator_okhttp(http2Stream.getId());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void windowUpdate(int streamId, long windowSizeIncrement) {
            if (streamId == 0) {
                Http2Connection http2Connection = Http2Connection.this;
                Http2Connection http2Connection2 = Http2Connection.this;
                Http2Connection http2Connection3 = http2Connection;
                synchronized (http2Connection3) {
                    boolean bl = false;
                    http2Connection2.writeBytesMaximum = http2Connection2.getWriteBytesMaximum() + windowSizeIncrement;
                    Http2Connection $this$notifyAll$iv = http2Connection2;
                    boolean $i$f$notifyAll = false;
                    Intrinsics.checkNotNull((Object)$this$notifyAll$iv, (String)"null cannot be cast to non-null type java.lang.Object");
                    ((Object)$this$notifyAll$iv).notifyAll();
                    Unit unit = Unit.INSTANCE;
                }
            }
            Http2Stream stream = Http2Connection.this.getStream(streamId);
            if (stream != null) {
                Http2Stream http2Stream = stream;
                synchronized (http2Stream) {
                    boolean bl = false;
                    stream.addBytesToWriteWindow(windowSizeIncrement);
                    Unit unit = Unit.INSTANCE;
                }
            }
        }

        @Override
        public void priority(int streamId, int streamDependency, int weight, boolean exclusive) {
        }

        @Override
        public void pushPromise(int streamId, int promisedStreamId, @NotNull List<Header> requestHeaders) {
            Intrinsics.checkNotNullParameter(requestHeaders, (String)"requestHeaders");
            Http2Connection.this.pushRequestLater$impersonator_okhttp(promisedStreamId, requestHeaders);
        }

        @Override
        public void alternateService(int streamId, @NotNull String origin, @NotNull ByteString protocol, @NotNull String host, int port, long maxAge) {
            Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
            Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        }
    }
}

