/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\f\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0011\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0086\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013J\u0006\u0010\u0015\u001a\u00020\u0004J\u000e\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004J\u000e\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004J\u000e\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0004J\u000e\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u0000J\u0019\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004H\u0086\u0002J\u0006\u0010\u001d\u001a\u00020\u0004R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R-\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\nj\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004`\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001f"}, d2={"Lokhttp3/internal/http2/Settings;", "", "()V", "headerTableSize", "", "getHeaderTableSize", "()I", "initialWindowSize", "getInitialWindowSize", "values", "Ljava/util/LinkedHashMap;", "Lkotlin/collections/LinkedHashMap;", "getValues", "()Ljava/util/LinkedHashMap;", "clear", "", "get", "id", "getEnablePush", "", "defaultValue", "getMaxConcurrentStreams", "getMaxFrameSize", "getMaxHeaderListSize", "isSet", "merge", "other", "set", "value", "size", "Companion", "impersonator-okhttp"})
public final class Settings {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LinkedHashMap<Integer, Integer> values = new LinkedHashMap(10);
    public static final int DEFAULT_INITIAL_WINDOW_SIZE = 65535;
    public static final int HEADER_TABLE_SIZE = 1;
    public static final int ENABLE_PUSH = 2;
    public static final int MAX_CONCURRENT_STREAMS = 4;
    public static final int MAX_FRAME_SIZE = 5;
    public static final int MAX_HEADER_LIST_SIZE = 6;
    public static final int INITIAL_WINDOW_SIZE = 7;
    public static final int COUNT = 10;

    @NotNull
    public final LinkedHashMap<Integer, Integer> getValues() {
        return this.values;
    }

    public final int getHeaderTableSize() {
        Integer n = this.values.getOrDefault(1, -1);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getOrDefault(...)");
        return ((Number)n).intValue();
    }

    public final int getInitialWindowSize() {
        Integer n = this.values.getOrDefault(7, 65535);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getOrDefault(...)");
        return ((Number)n).intValue();
    }

    public final void clear() {
        this.values.clear();
    }

    @NotNull
    public final Settings set(int id, int value) {
        if (value == -1) {
            this.values.remove(id);
            return this;
        }
        if (id < 0 || id >= 10) {
            return this;
        }
        Integer n = id;
        Integer n2 = value;
        ((Map)this.values).put(n, n2);
        return this;
    }

    public final boolean isSet(int id) {
        return this.values.containsKey(id);
    }

    public final int get(int id) {
        Integer n = this.values.getOrDefault(id, 0);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getOrDefault(...)");
        return ((Number)n).intValue();
    }

    public final int size() {
        return this.values.size();
    }

    public final boolean getEnablePush(boolean defaultValue) {
        if (this.values.containsKey(2)) {
            Integer n = this.values.get(2);
            int n2 = 1;
            return n != null && n == n2;
        }
        return defaultValue;
    }

    public final int getMaxConcurrentStreams() {
        Integer n = this.values.getOrDefault(4, Integer.MAX_VALUE);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getOrDefault(...)");
        return ((Number)n).intValue();
    }

    public final int getMaxFrameSize(int defaultValue) {
        Integer n = this.values.getOrDefault(5, defaultValue);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getOrDefault(...)");
        return ((Number)n).intValue();
    }

    public final int getMaxHeaderListSize(int defaultValue) {
        Integer n = this.values.getOrDefault(6, defaultValue);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getOrDefault(...)");
        return ((Number)n).intValue();
    }

    public final void merge(@NotNull Settings other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        for (int i = 0; i < 10; ++i) {
            if (!other.isSet(i)) continue;
            this.set(i, other.get(i));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lokhttp3/internal/http2/Settings$Companion;", "", "()V", "COUNT", "", "DEFAULT_INITIAL_WINDOW_SIZE", "ENABLE_PUSH", "HEADER_TABLE_SIZE", "INITIAL_WINDOW_SIZE", "MAX_CONCURRENT_STREAMS", "MAX_FRAME_SIZE", "MAX_HEADER_LIST_SIZE", "impersonator-okhttp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

