/*
 * Decompiled with CFR 0.152.
 */
package keystone;

import com.sun.jna.NativeLoader;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import keystone.KeystoneArchitecture;
import keystone.KeystoneEncoded;
import keystone.KeystoneError;
import keystone.KeystoneMode;
import keystone.KeystoneOptionType;
import keystone.KeystoneOptionValue;
import keystone.SymbolResolverCallback;
import keystone.exceptions.AssembleFailedKeystoneException;
import keystone.exceptions.OpenFailedKeystoneException;
import keystone.exceptions.SetOptionFailedKeystoneException;
import keystone.natives.DirectMappingKeystoneNative;
import keystone.utilities.Version;

public class Keystone
implements AutoCloseable {
    private final Pointer ksEngine;

    public Keystone(KeystoneArchitecture architecture, KeystoneMode mode) {
        this.ksEngine = this.initializeKeystoneEngine(architecture, mode);
    }

    public static boolean isArchitectureSupported(KeystoneArchitecture architecture) {
        return DirectMappingKeystoneNative.ks_arch_supported(architecture);
    }

    private Pointer initializeKeystoneEngine(KeystoneArchitecture architecture, KeystoneMode mode) {
        PointerByReference pointerToEngine = new PointerByReference();
        KeystoneError openResult = DirectMappingKeystoneNative.ks_open(architecture, mode, pointerToEngine);
        if (openResult != KeystoneError.Ok) {
            throw new OpenFailedKeystoneException(openResult);
        }
        return pointerToEngine.getValue();
    }

    public KeystoneEncoded assemble(String assembly) {
        return this.assemble(assembly, 0);
    }

    public KeystoneEncoded assemble(String assembly, int address) {
        PointerByReference pointerToMachineCodeBuffer = new PointerByReference();
        IntByReference pointerToMachineCodeSize = new IntByReference();
        IntByReference pointerToNumberOfStatements = new IntByReference();
        int result = DirectMappingKeystoneNative.ks_asm(this.ksEngine, assembly, address, pointerToMachineCodeBuffer, pointerToMachineCodeSize, pointerToNumberOfStatements);
        if (result != 0) {
            KeystoneError errorCode = DirectMappingKeystoneNative.ks_errno(this.ksEngine);
            throw new AssembleFailedKeystoneException(errorCode, assembly);
        }
        Pointer machineCodeBuffer = pointerToMachineCodeBuffer.getValue();
        byte[] machineCode = machineCodeBuffer.getByteArray(0L, pointerToMachineCodeSize.getValue());
        DirectMappingKeystoneNative.ks_free(machineCodeBuffer);
        return new KeystoneEncoded(machineCode, address, pointerToNumberOfStatements.getValue());
    }

    public KeystoneEncoded assemble(Iterable<String> assembly) {
        return this.assemble(assembly, 0);
    }

    public KeystoneEncoded assemble(Iterable<String> assembly, int address) {
        StringBuilder builder = new StringBuilder();
        for (String asm : assembly) {
            builder.append(asm).append(';');
        }
        int length = builder.length();
        if (length > 0) {
            builder.deleteCharAt(length - 1);
        }
        return this.assemble(builder.toString(), address);
    }

    public Version version() {
        IntByReference major = new IntByReference();
        IntByReference minor = new IntByReference();
        DirectMappingKeystoneNative.ks_version(major, minor);
        return new Version(major.getValue(), minor.getValue());
    }

    public void setAssemblySyntax(KeystoneOptionValue.KeystoneOptionSyntax syntax) {
        this.setOption(KeystoneOptionType.Syntax, syntax.value());
    }

    public void setOption(KeystoneOptionType type, int value) {
        KeystoneError result = DirectMappingKeystoneNative.ks_option(this.ksEngine, type, value);
        if (result != KeystoneError.Ok) {
            throw new SetOptionFailedKeystoneException(result, type, value);
        }
    }

    public void setSymbolResolver(SymbolResolverCallback callback) {
        DirectMappingKeystoneNative.ks_option(this.ksEngine, KeystoneOptionType.SymbolResolver, callback);
    }

    public void unsetSymbolResolver() {
        DirectMappingKeystoneNative.ks_option(this.ksEngine, KeystoneOptionType.SymbolResolver, 0);
    }

    @Override
    public void close() {
        DirectMappingKeystoneNative.ks_close(this.ksEngine);
    }

    static {
        NativeLoader.loadAppleSilicon();
    }
}

