/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.file.linux;

import com.github.unidbg.Emulator;
import com.github.unidbg.file.BaseFileSystem;
import com.github.unidbg.file.FileResult;
import com.github.unidbg.file.FileSystem;
import com.github.unidbg.file.NewFileIO;
import com.github.unidbg.file.linux.AndroidFileIO;
import com.github.unidbg.file.linux.IOConstants;
import com.github.unidbg.linux.android.LogCatHandler;
import com.github.unidbg.linux.file.DirectoryFileIO;
import com.github.unidbg.linux.file.MapsFileIO;
import com.github.unidbg.linux.file.NullFileIO;
import com.github.unidbg.linux.file.SimpleFileIO;
import com.github.unidbg.linux.file.Stdin;
import com.github.unidbg.linux.file.Stdout;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class LinuxFileSystem
extends BaseFileSystem<AndroidFileIO>
implements FileSystem<AndroidFileIO>,
IOConstants {
    public LinuxFileSystem(Emulator<AndroidFileIO> emulator, File rootDir) {
        super(emulator, rootDir);
    }

    public FileResult<AndroidFileIO> open(String pathname, int oflags) {
        if ("/dev/tty".equals(pathname)) {
            return FileResult.success((NewFileIO)new NullFileIO(pathname));
        }
        if ("/proc/self/maps".equals(pathname) || ("/proc/" + this.emulator.getPid() + "/maps").equals(pathname)) {
            return FileResult.success((NewFileIO)new MapsFileIO(oflags, pathname, this.emulator.getMemory().getLoadedModules()));
        }
        return super.open(pathname, oflags);
    }

    public LogCatHandler getLogCatHandler() {
        return null;
    }

    protected void initialize(File rootDir) throws IOException {
        super.initialize(rootDir);
        FileUtils.forceMkdir((File)new File(rootDir, "system"));
        FileUtils.forceMkdir((File)new File(rootDir, "data"));
    }

    public AndroidFileIO createSimpleFileIO(File file, int oflags, String path) {
        return new SimpleFileIO(oflags, file, path);
    }

    public AndroidFileIO createDirectoryFileIO(File file, int oflags, String path) {
        return new DirectoryFileIO(oflags, path, file);
    }

    protected AndroidFileIO createStdin(int oflags) {
        return new Stdin(oflags);
    }

    protected AndroidFileIO createStdout(int oflags, File stdio, String pathname) {
        return new Stdout(oflags, stdio, pathname, "stderr".equals(pathname), null);
    }

    protected boolean hasCreat(int oflags) {
        return (oflags & 0x40) != 0;
    }

    protected boolean hasDirectory(int oflags) {
        return (oflags & 0x10000) != 0;
    }

    protected boolean hasAppend(int oflags) {
        return (oflags & 0x400) != 0;
    }

    protected boolean hasExcl(int oflags) {
        return (oflags & 0x80) != 0;
    }
}

