/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux;

import com.github.unidbg.Emulator;
import com.github.unidbg.arm.context.RegisterContext;
import com.github.unidbg.file.FileResult;
import com.github.unidbg.file.NewFileIO;
import com.github.unidbg.file.linux.AndroidFileIO;
import com.github.unidbg.linux.file.DirectoryFileIO;
import com.github.unidbg.linux.file.EventFD;
import com.github.unidbg.linux.file.PipedReadFileIO;
import com.github.unidbg.linux.file.PipedWriteFileIO;
import com.github.unidbg.linux.struct.StatFS;
import com.github.unidbg.linux.struct.StatFS32;
import com.github.unidbg.linux.struct.StatFS64;
import com.github.unidbg.pointer.UnidbgPointer;
import com.github.unidbg.spi.SyscallHandler;
import com.github.unidbg.unix.UnixSyscallHandler;
import com.github.unidbg.utils.Inspector;
import com.sun.jna.Pointer;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.Map;
import net.dongliu.apk.parser.utils.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

abstract class AndroidSyscallHandler
extends UnixSyscallHandler<AndroidFileIO>
implements SyscallHandler<AndroidFileIO> {
    private static final Log log = LogFactory.getLog(AndroidSyscallHandler.class);
    static final int MREMAP_MAYMOVE = 1;
    static final int MREMAP_FIXED = 2;
    private byte[] sched_cpu_mask;
    private static final int EFD_SEMAPHORE = 1;
    private static final int EFD_NONBLOCK = 2048;
    private static final int EFD_CLOEXEC = 524288;

    AndroidSyscallHandler() {
    }

    final long sched_setaffinity(Emulator<AndroidFileIO> emulator) {
        RegisterContext context = emulator.getContext();
        int pid = context.getIntArg(0);
        int cpusetsize = context.getIntArg(1);
        UnidbgPointer mask = context.getPointerArg(2);
        if (mask != null) {
            this.sched_cpu_mask = mask.getByteArray(0L, cpusetsize);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)Inspector.inspectString((byte[])this.sched_cpu_mask, (String)("sched_setaffinity pid=" + pid + ", cpusetsize=" + cpusetsize + ", mask=" + mask)));
        }
        return 0L;
    }

    final long sched_getaffinity(Emulator<AndroidFileIO> emulator) {
        RegisterContext context = emulator.getContext();
        int pid = context.getIntArg(0);
        int cpusetsize = context.getIntArg(1);
        UnidbgPointer mask = context.getPointerArg(2);
        int ret = 0;
        if (mask != null && this.sched_cpu_mask != null) {
            mask.write(0L, this.sched_cpu_mask, 0, cpusetsize);
            ret = cpusetsize;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)Inspector.inspectString((byte[])this.sched_cpu_mask, (String)("sched_getaffinity pid=" + pid + ", cpusetsize=" + cpusetsize + ", mask=" + mask)));
        }
        return ret;
    }

    final int eventfd2(Emulator<?> emulator) {
        RegisterContext ctx = emulator.getContext();
        int initval = ctx.getIntArg(0);
        int flags = ctx.getIntArg(1);
        if (log.isDebugEnabled()) {
            log.debug((Object)("eventfd2 initval=" + initval + ", flags=0x" + Integer.toHexString(flags)));
        }
        if ((flags & 0x80000) != 0) {
            throw new UnsupportedOperationException("eventfd2 flags=0x" + Integer.toHexString(flags));
        }
        boolean nonblock = (flags & 0x800) != 0;
        boolean semaphore = (flags & 1) != 0;
        EventFD fileIO = new EventFD(initval, semaphore, nonblock);
        int minFd = this.getMinFd();
        this.fdMap.put(minFd, fileIO);
        if (this.verbose) {
            System.out.printf("eventfd(%d) with flags=0x%x fd=%d from %s%n", initval, flags, minFd, emulator.getContext().getLRPointer());
        }
        return minFd;
    }

    protected FileResult<AndroidFileIO> createFdDir(int oflags, String pathname) {
        ArrayList<DirectoryFileIO.DirectoryEntry> list = new ArrayList<DirectoryFileIO.DirectoryEntry>();
        for (Map.Entry entry : this.fdMap.entrySet()) {
            list.add(new DirectoryFileIO.DirectoryEntry(DirectoryFileIO.DirentType.DT_LNK, ((Integer)entry.getKey()).toString()));
        }
        return FileResult.success((NewFileIO)new DirectoryFileIO(oflags, pathname, list.toArray(new DirectoryFileIO.DirectoryEntry[0])));
    }

    protected FileResult<AndroidFileIO> createTaskDir(Emulator<AndroidFileIO> emulator, int oflags, String pathname) {
        return FileResult.success((NewFileIO)new DirectoryFileIO(oflags, pathname, new DirectoryFileIO.DirectoryEntry(false, Integer.toString(emulator.getPid()))));
    }

    protected long statfs64(Emulator<AndroidFileIO> emulator, String path, Pointer buf) {
        FileResult result = this.resolve(emulator, path, 0);
        if (result == null) {
            log.info((Object)("statfs64 buf=" + buf + ", path=" + path));
            emulator.getMemory().setErrno(2);
            return -1L;
        }
        if (result.isSuccess()) {
            StatFS statFS = emulator.is64Bit() ? new StatFS64(buf) : new StatFS32(buf);
            int ret = ((AndroidFileIO)result.io).statfs(statFS);
            if (ret != 0) {
                log.info((Object)("statfs64 buf=" + buf + ", path=" + path));
            } else {
                if (this.verbose) {
                    System.out.printf("File statfs '%s' from %s%n", result.io, emulator.getContext().getLRPointer());
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("statfs64 buf=" + buf + ", path=" + path));
                }
            }
            return ret;
        }
        log.info((Object)("statfs64 buf=" + buf + ", path=" + path));
        emulator.getMemory().setErrno(result.errno);
        return -1L;
    }

    protected int pipe2(Emulator<?> emulator) {
        try {
            RegisterContext context = emulator.getContext();
            UnidbgPointer pipefd = context.getPointerArg(0);
            int flags = context.getIntArg(1);
            int writefd = this.getMinFd();
            Pair<AndroidFileIO, AndroidFileIO> pair = this.getPipePair(emulator, writefd);
            this.fdMap.put(writefd, pair.getLeft());
            int readfd = this.getMinFd();
            this.fdMap.put(readfd, pair.getRight());
            pipefd.setInt(0L, readfd);
            pipefd.setInt(4L, writefd);
            log.info((Object)("pipe2 pipefd=" + pipefd + ", flags=0x" + flags + ", readfd=" + readfd + ", writefd=" + writefd));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return 0;
    }

    protected Pair<AndroidFileIO, AndroidFileIO> getPipePair(Emulator<?> emulator, int writefd) throws IOException {
        PipedInputStream inputStream = new PipedInputStream();
        PipedOutputStream outputStream = new PipedOutputStream(inputStream);
        PipedWriteFileIO writeIO = new PipedWriteFileIO(outputStream, writefd);
        PipedReadFileIO readIO = new PipedReadFileIO(inputStream, writefd);
        return new Pair((Object)writeIO, (Object)readIO);
    }

    protected int mkdirat(Emulator<?> emulator) {
        RegisterContext context = emulator.getContext();
        int dirfd = context.getIntArg(0);
        UnidbgPointer pathname_p = context.getPointerArg(1);
        int mode = context.getIntArg(2);
        String pathname = pathname_p.getString(0L);
        if (log.isDebugEnabled()) {
            log.debug((Object)("mkdirat dirfd=" + dirfd + ", pathname=" + pathname + ", mode=" + Integer.toHexString(mode)));
        }
        emulator.getMemory().setErrno(13);
        return -1;
    }

    final int select(int nfds, Pointer checkfds, Pointer clearfds, boolean checkRead) {
        int i;
        int count = 0;
        for (i = 0; i < nfds; ++i) {
            int mask = checkfds.getInt((long)(i / 32));
            if ((mask >> i & 1) != 1) continue;
            AndroidFileIO io = (AndroidFileIO)this.fdMap.get(i);
            if (!checkRead || io.canRead()) {
                ++count;
                continue;
            }
            checkfds.setInt((long)(i / 32), mask &= ~(1 << i));
        }
        if (count > 0 && clearfds != null) {
            for (i = 0; i < nfds; ++i) {
                clearfds.setInt((long)(i / 32), 0);
            }
        }
        return count;
    }

    final int sigaltstack(Emulator<?> emulator) {
        RegisterContext context = emulator.getContext();
        UnidbgPointer ss = context.getPointerArg(0);
        UnidbgPointer old_ss = context.getPointerArg(1);
        if (log.isDebugEnabled()) {
            log.debug((Object)("sigaltstack ss=" + ss + ", old_ss=" + old_ss));
        }
        return 0;
    }

    protected int renameat(Emulator<?> emulator) {
        RegisterContext context = emulator.getContext();
        int olddirfd = context.getIntArg(0);
        String oldpath = context.getPointerArg(1).getString(0L);
        int newdirfd = context.getIntArg(2);
        String newpath = context.getPointerArg(3).getString(0L);
        int ret = emulator.getFileSystem().rename(oldpath, newpath);
        if (ret != 0) {
            log.info((Object)("renameat olddirfd=" + olddirfd + ", oldpath=" + oldpath + ", newdirfd=" + newdirfd + ", newpath=" + newpath));
        } else {
            log.debug((Object)("renameat olddirfd=" + olddirfd + ", oldpath=" + oldpath + ", newdirfd=" + newdirfd + ", newpath=" + newpath));
        }
        return 0;
    }

    protected int unlinkat(Emulator<?> emulator) {
        RegisterContext context = emulator.getContext();
        int dirfd = context.getIntArg(0);
        UnidbgPointer pathname = context.getPointerArg(1);
        int flags = context.getIntArg(2);
        emulator.getFileSystem().unlink(pathname.getString(0L));
        if (log.isDebugEnabled()) {
            log.info((Object)("unlinkat dirfd=" + dirfd + ", pathname=" + pathname.getString(0L) + ", flags=" + flags));
        }
        return 0;
    }
}

