/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux;

import com.github.unidbg.Emulator;
import com.github.unidbg.spi.InitFunction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class LinuxInitFunction
extends InitFunction {
    private static final Log log = LogFactory.getLog(LinuxInitFunction.class);

    LinuxInitFunction(long load_base, String soName, long address) {
        super(load_base, soName, address);
    }

    public long getAddress() {
        return this.load_base + this.address;
    }

    public void call(Emulator<?> emulator) {
        if (this.address == 0L || this.address == -1L) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.libName + "]CallInitFunction: 0x" + Long.toHexString(this.address)));
        }
        long start = System.currentTimeMillis();
        emulator.eInit(this.getAddress(), new Number[0]);
        if (log.isDebugEnabled()) {
            System.err.println("[" + this.libName + "]CallInitFunction: 0x" + Long.toHexString(this.address) + ", offset=" + (System.currentTimeMillis() - start) + "ms");
        }
    }
}

