/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux;

import com.github.unidbg.Emulator;
import com.github.unidbg.Module;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.pointer.UnidbgPointer;
import com.github.unidbg.unix.Thread;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LinuxThread
extends Thread {
    private static final Log log = LogFactory.getLog(LinuxThread.class);
    private final UnidbgPointer child_stack;
    private final UnidbgPointer fn;
    private final UnidbgPointer arg;
    private long context;

    LinuxThread(UnidbgPointer child_stack, UnidbgPointer fn, UnidbgPointer arg) {
        this.child_stack = child_stack;
        this.fn = fn;
        this.arg = arg;
    }

    public void runThread(Emulator<?> emulator, long __thread_entry, long timeout) {
        Backend backend = emulator.getBackend();
        if (this.context == 0L) {
            log.info((Object)("run thread: fn=" + this.fn + ", arg=" + this.arg + ", child_stack=" + this.child_stack + ", __thread_entry=0x" + Long.toHexString(__thread_entry)));
            if (__thread_entry == 0L) {
                emulator.eThread(this.fn.peer, this.arg.peer, this.child_stack.peer);
            } else {
                Module.emulateFunction(emulator, (long)__thread_entry, (Object[])new Object[]{this.fn, this.arg, this.child_stack});
            }
        } else {
            backend.context_restore(this.context);
            long pc = backend.reg_read(emulator.is32Bit() ? 11 : 260).longValue();
            if (emulator.is32Bit()) {
                pc &= 0xFFFFFFFFL;
            }
            log.info((Object)("resume thread: fn=" + this.fn + ", arg=" + this.arg + ", child_stack=" + this.child_stack + ", pc=0x" + Long.toHexString(pc) + ", __thread_entry=0x" + Long.toHexString(__thread_entry)));
            backend.emu_start(pc, 0L, timeout, 0L);
        }
        if (this.context == 0L) {
            this.context = backend.context_alloc();
        }
        backend.context_save(this.context);
    }
}

