/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.android;

import com.github.unidbg.AndroidEmulator;
import com.github.unidbg.Emulator;
import com.github.unidbg.Family;
import com.github.unidbg.arm.AbstractARM64Emulator;
import com.github.unidbg.arm.backend.BackendFactory;
import com.github.unidbg.file.FileSystem;
import com.github.unidbg.file.linux.AndroidFileIO;
import com.github.unidbg.file.linux.LinuxFileSystem;
import com.github.unidbg.linux.ARM64SyscallHandler;
import com.github.unidbg.linux.AndroidElfLoader;
import com.github.unidbg.linux.android.AndroidARM64Unwinder;
import com.github.unidbg.linux.android.ArmLD64;
import com.github.unidbg.linux.android.URLibraryFile;
import com.github.unidbg.linux.android.dvm.DalvikVM64;
import com.github.unidbg.linux.android.dvm.VM;
import com.github.unidbg.memory.Memory;
import com.github.unidbg.memory.SvcMemory;
import com.github.unidbg.spi.Dlfcn;
import com.github.unidbg.spi.LibraryFile;
import com.github.unidbg.unix.UnixSyscallHandler;
import com.github.unidbg.unwind.Unwinder;
import java.io.File;
import java.net.URL;
import java.util.Collection;

public class AndroidARM64Emulator
extends AbstractARM64Emulator<AndroidFileIO>
implements AndroidEmulator {
    private VM vm;

    protected AndroidARM64Emulator(String processName, File rootDir, Collection<BackendFactory> backendFactories) {
        super(processName, rootDir, Family.Android64, backendFactories, new String[0]);
    }

    protected FileSystem<AndroidFileIO> createFileSystem(File rootDir) {
        return new LinuxFileSystem((Emulator<AndroidFileIO>)this, rootDir);
    }

    protected Memory createMemory(UnixSyscallHandler<AndroidFileIO> syscallHandler, String[] envs) {
        return new AndroidElfLoader((Emulator<AndroidFileIO>)this, syscallHandler);
    }

    protected Dlfcn createDyld(SvcMemory svcMemory) {
        return new ArmLD64(this.backend, svcMemory);
    }

    protected UnixSyscallHandler<AndroidFileIO> createSyscallHandler(SvcMemory svcMemory) {
        return new ARM64SyscallHandler(svcMemory);
    }

    private VM createDalvikVMInternal(File apkFile) {
        return new DalvikVM64((Emulator<?>)this, apkFile);
    }

    public LibraryFile createURLibraryFile(URL url, String libName) {
        return new URLibraryFile(url, libName, -1, true);
    }

    protected boolean isPaddingArgument() {
        return false;
    }

    @Override
    public VM createDalvikVM() {
        return this.createDalvikVM((File)null);
    }

    @Override
    public final VM createDalvikVM(File apkFile) {
        if (this.vm != null) {
            throw new IllegalStateException("vm is already created");
        }
        this.vm = this.createDalvikVMInternal(apkFile);
        return this.vm;
    }

    @Override
    public VM createDalvikVM(Class<?> callingClass) {
        return this.createDalvikVM(new File(callingClass.getProtectionDomain().getCodeSource().getLocation().getPath()));
    }

    @Override
    public final VM getDalvikVM() {
        return this.vm;
    }

    public Unwinder getUnwinder() {
        return new AndroidARM64Unwinder((Emulator<?>)this);
    }
}

