/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.android;

import com.github.unidbg.Emulator;
import com.github.unidbg.linux.LinuxModule;
import com.github.unidbg.unwind.Frame;
import com.github.unidbg.unwind.SimpleARMUnwinder;
import com.github.unidbg.unwind.Unwinder;
import java.io.IOException;
import net.fornwall.jelf.ArmExIdx;
import net.fornwall.jelf.DwarfCursor;
import net.fornwall.jelf.DwarfCursor32;
import net.fornwall.jelf.GnuEhFrameHeader;
import net.fornwall.jelf.MemoizedObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class AndroidARMUnwinder
extends SimpleARMUnwinder {
    private static final Log log = LogFactory.getLog(AndroidARMUnwinder.class);
    private final DwarfCursor context;

    public AndroidARMUnwinder(Emulator<?> emulator) {
        super(emulator);
        this.context = new DwarfCursor32(emulator);
    }

    protected Frame unw_step(Emulator<?> emulator, Frame frame) {
        try {
            MemoizedObject<ArmExIdx> armExIdx;
            MemoizedObject<GnuEhFrameHeader> ehFrameHeader;
            LinuxModule module = (LinuxModule)emulator.getMemory().findModuleByAddress(this.context.ip);
            MemoizedObject<GnuEhFrameHeader> memoizedObject = ehFrameHeader = module == null ? null : module.ehFrameHeader;
            if (ehFrameHeader != null) {
                long fun = this.context.ip - module.base;
                Frame ret = ehFrameHeader.getValue().dwarf_step(emulator, (Unwinder)this, module, fun, this.context);
                if (ret != null) {
                    return ret;
                }
            }
            MemoizedObject<ArmExIdx> memoizedObject2 = armExIdx = module == null ? null : module.armExIdx;
            if (armExIdx != null) {
                long fun = this.context.ip - module.base;
                Frame ret = armExIdx.getValue().arm_exidx_step(emulator, (Unwinder)this, module, fun, this.context);
                if (ret != null) {
                    return ret;
                }
            }
        }
        catch (RuntimeException exception) {
            log.warn((Object)"unw_step", (Throwable)exception);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return super.unw_step(emulator, frame);
    }
}

