/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.android;

import com.github.unidbg.Emulator;
import com.github.unidbg.LibraryResolver;
import com.github.unidbg.file.FileResult;
import com.github.unidbg.file.FileSystem;
import com.github.unidbg.file.IOResolver;
import com.github.unidbg.file.NewFileIO;
import com.github.unidbg.file.linux.AndroidFileIO;
import com.github.unidbg.hook.hookzz.IHookZz;
import com.github.unidbg.linux.android.URLibraryFile;
import com.github.unidbg.linux.file.DirectoryFileIO;
import com.github.unidbg.linux.file.LogCatFileIO;
import com.github.unidbg.linux.file.SimpleFileIO;
import com.github.unidbg.linux.thread.ThreadJoin19;
import com.github.unidbg.linux.thread.ThreadJoin23;
import com.github.unidbg.spi.LibraryFile;
import com.github.unidbg.utils.ResourceUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FilenameUtils;

public class AndroidResolver
implements LibraryResolver,
IOResolver<AndroidFileIO> {
    private final int sdk;
    private final List<String> needed;

    public AndroidResolver(int sdk, String ... needed) {
        this.sdk = sdk;
        this.needed = needed == null ? null : Arrays.asList(needed);
    }

    public void patchThread(Emulator<?> emulator, IHookZz hookZz) {
        switch (this.sdk) {
            case 19: {
                ThreadJoin19.patch(emulator, hookZz);
                break;
            }
            case 23: {
                ThreadJoin23.patch(emulator, hookZz);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    public int getSdk() {
        return this.sdk;
    }

    public LibraryFile resolveLibrary(Emulator<?> emulator, String libraryName) {
        if (this.needed == null) {
            return null;
        }
        if (!this.needed.isEmpty() && !this.needed.contains(libraryName)) {
            return null;
        }
        return AndroidResolver.resolveLibrary(emulator, libraryName, this.sdk);
    }

    static LibraryFile resolveLibrary(Emulator<?> emulator, String libraryName, int sdk) {
        String lib = emulator.is32Bit() ? "lib" : "lib64";
        String name = "/android/sdk" + sdk + "/" + lib + "/" + libraryName.replace('+', 'p');
        URL url = AndroidResolver.class.getResource(name);
        if (url != null) {
            return new URLibraryFile(url, libraryName, sdk, emulator.is64Bit());
        }
        return null;
    }

    public FileResult<AndroidFileIO> resolve(Emulator<AndroidFileIO> emulator, String path, int oflags) {
        FileSystem fileSystem = emulator.getFileSystem();
        File rootDir = fileSystem.getRootDir();
        if (path.startsWith("/dev/log/")) {
            try {
                File log = new File(rootDir, path);
                File logDir = log.getParentFile();
                if (!logDir.exists() && !logDir.mkdirs()) {
                    throw new IOException("mkdirs failed: " + logDir);
                }
                if (!log.exists() && !log.createNewFile()) {
                    throw new IOException("create new file failed: " + log);
                }
                return FileResult.success((NewFileIO)new LogCatFileIO(emulator, oflags, log, path));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        if (".".equals(path)) {
            return FileResult.success((NewFileIO)this.createFileIO(fileSystem.createWorkDir(), path, oflags));
        }
        String androidResource = FilenameUtils.normalize((String)("/android/sdk" + this.sdk + "/" + path), (boolean)true);
        File file = ResourceUtils.extractResource(AndroidResolver.class, (String)androidResource, (String)path);
        if (file != null) {
            return FileResult.fallback((NewFileIO)this.createFileIO(file, path, oflags));
        }
        return null;
    }

    private AndroidFileIO createFileIO(File file, String pathname, int oflags) {
        if (file.canRead()) {
            return file.isDirectory() ? new DirectoryFileIO(oflags, pathname, new DirectoryFileIO.DirectoryEntry[0]) : new SimpleFileIO(oflags, file, pathname);
        }
        return null;
    }
}

