/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.android;

import com.github.unidbg.Emulator;
import com.github.unidbg.Module;
import com.github.unidbg.Svc;
import com.github.unidbg.Symbol;
import com.github.unidbg.arm.ArmHook;
import com.github.unidbg.arm.ArmSvc;
import com.github.unidbg.arm.HookStatus;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.arm.context.RegisterContext;
import com.github.unidbg.linux.LinuxModule;
import com.github.unidbg.linux.struct.dl_phdr_info;
import com.github.unidbg.memory.Memory;
import com.github.unidbg.memory.MemoryBlock;
import com.github.unidbg.memory.SvcMemory;
import com.github.unidbg.pointer.UnidbgPointer;
import com.github.unidbg.pointer.UnidbgStructure;
import com.github.unidbg.spi.Dlfcn;
import com.github.unidbg.spi.InitFunction;
import com.github.unidbg.unix.struct.DlInfo;
import com.sun.jna.Pointer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import keystone.Keystone;
import keystone.KeystoneArchitecture;
import keystone.KeystoneEncoded;
import keystone.KeystoneMode;
import net.fornwall.jelf.ElfDynamicStructure;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ArmLD
extends Dlfcn {
    private static final Log log = LogFactory.getLog(ArmLD.class);
    private final Backend backend;

    ArmLD(Backend backend, SvcMemory svcMemory) {
        super(svcMemory);
        this.backend = backend;
    }

    public long hook(final SvcMemory svcMemory, String libraryName, String symbolName, long old) {
        if ("libdl.so".equals(libraryName)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("link " + symbolName + ", old=0x" + Long.toHexString(old)));
            }
            switch (symbolName) {
                case "dl_iterate_phdr": {
                    return svcMemory.registerSvc((Svc)new ArmSvc(){
                        private MemoryBlock block;

                        public UnidbgPointer onRegister(SvcMemory svcMemory2, int svcNumber) {
                            try (Keystone keystone = new Keystone(KeystoneArchitecture.Arm, KeystoneMode.Arm);){
                                KeystoneEncoded encoded = keystone.assemble(Arrays.asList("push {r4-r7, lr}", "svc #0x" + Integer.toHexString(svcNumber), "pop {r7}", "cmp r7, #0", "beq 0x34", "pop {r0-r2}", "blx r7", "cmp r0, #0", "beq 0x8", "pop {r7}", "cmp r7, #0", "popne {r4-r6}", "bne 0x24", "mov r7, #0", "mov r5, #0x" + Integer.toHexString(34952), "mov r4, #0x" + Integer.toHexString(svcNumber), "svc #0", "pop {r4-r7, pc}"));
                                byte[] code = encoded.getMachineCode();
                                UnidbgPointer pointer = svcMemory2.allocate(code.length, "dl_iterate_phdr");
                                pointer.write(0L, code, 0, code.length);
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("dl_iterate_phdr: pointer=" + pointer));
                                }
                                UnidbgPointer unidbgPointer = pointer;
                                return unidbgPointer;
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public long handle(Emulator<?> emulator) {
                            if (this.block != null) {
                                throw new IllegalStateException();
                            }
                            RegisterContext context = emulator.getContext();
                            UnidbgPointer cb = context.getPointerArg(0);
                            UnidbgPointer data = context.getPointerArg(1);
                            Collection modules = emulator.getMemory().getLoadedModules();
                            ArrayList<LinuxModule> list = new ArrayList<LinuxModule>();
                            for (Module module : modules) {
                                LinuxModule lm = (LinuxModule)module;
                                if (lm.elfFile == null) continue;
                                list.add(lm);
                            }
                            Collections.reverse(list);
                            int size = UnidbgStructure.calculateSize(dl_phdr_info.class);
                            this.block = emulator.getMemory().malloc(size * list.size(), true);
                            UnidbgPointer ptr = this.block.getPointer();
                            Backend backend = emulator.getBackend();
                            UnidbgPointer sp = UnidbgPointer.register(emulator, (int)12);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("dl_iterate_phdr cb=" + cb + ", data=" + data + ", size=" + list.size() + ", sp=" + sp));
                            }
                            try {
                                sp = sp.share(-4L, 0L);
                                sp.setInt(0L, 0);
                                for (LinuxModule module : list) {
                                    dl_phdr_info info = new dl_phdr_info((Pointer)ptr);
                                    info.dlpi_addr = UnidbgPointer.pointer(emulator, (long)module.base);
                                    assert (info.dlpi_addr != null);
                                    ElfDynamicStructure dynamicStructure = module.dynamicStructure;
                                    info.dlpi_name = dynamicStructure != null && dynamicStructure.soName > 0 && dynamicStructure.dt_strtab_offset > 0L ? info.dlpi_addr.share(dynamicStructure.dt_strtab_offset + (long)dynamicStructure.soName) : module.createPathMemory(svcMemory);
                                    info.dlpi_phdr = info.dlpi_addr.share(module.elfFile.ph_offset);
                                    info.dlpi_phnum = module.elfFile.num_ph;
                                    info.pack();
                                    sp = sp.share(-4L, 0L);
                                    sp.setPointer(0L, (Pointer)data);
                                    sp = sp.share(-4L, 0L);
                                    sp.setInt(0L, size);
                                    sp = sp.share(-4L, 0L);
                                    sp.setPointer(0L, (Pointer)ptr);
                                    sp = sp.share(-4L, 0L);
                                    sp.setPointer(0L, (Pointer)cb);
                                    ptr = ptr.share((long)size, 0L);
                                }
                                long l = context.getLongArg(0);
                                return l;
                            }
                            finally {
                                backend.reg_write(12, (Number)sp.peer);
                            }
                        }

                        public void handleCallback(Emulator<?> emulator) {
                            super.handleCallback(emulator);
                            if (this.block == null) {
                                throw new IllegalStateException();
                            }
                            this.block.free();
                            this.block = null;
                        }
                    }).peer;
                }
                case "dlerror": {
                    return svcMemory.registerSvc((Svc)new ArmSvc(){

                        public long handle(Emulator<?> emulator) {
                            return ((ArmLD)ArmLD.this).error.peer;
                        }
                    }).peer;
                }
                case "dlclose": {
                    return svcMemory.registerSvc((Svc)new ArmSvc(){

                        public long handle(Emulator<?> emulator) {
                            RegisterContext context = emulator.getContext();
                            int handle = context.getIntArg(0);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("dlclose handle=0x" + Long.toHexString(handle)));
                            }
                            return ArmLD.this.dlclose(emulator.getMemory(), handle);
                        }
                    }).peer;
                }
                case "dlopen": {
                    return svcMemory.registerSvc((Svc)new ArmSvc(){

                        public UnidbgPointer onRegister(SvcMemory svcMemory, int svcNumber) {
                            ByteBuffer buffer = ByteBuffer.allocate(28);
                            buffer.order(ByteOrder.LITTLE_ENDIAN);
                            buffer.putInt(-382910224);
                            buffer.putInt(ArmSvc.assembleSvc((int)svcNumber));
                            buffer.putInt(-459444220);
                            buffer.putInt(-480837632);
                            buffer.putInt(307224592);
                            buffer.putInt(288358167);
                            buffer.putInt(-390233871);
                            byte[] code = buffer.array();
                            UnidbgPointer pointer = svcMemory.allocate(code.length, "dlopen");
                            pointer.write(code);
                            return pointer;
                        }

                        public long handle(Emulator<?> emulator) {
                            RegisterContext context = emulator.getContext();
                            UnidbgPointer filename = context.getPointerArg(0);
                            int flags = context.getIntArg(1);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("dlopen filename=" + filename.getString(0L) + ", flags=" + flags));
                            }
                            return ArmLD.this.dlopen(emulator.getMemory(), filename.getString(0L), emulator);
                        }
                    }).peer;
                }
                case "dladdr": {
                    return svcMemory.registerSvc((Svc)new ArmSvc(){

                        public long handle(Emulator<?> emulator) {
                            Module module;
                            RegisterContext context = emulator.getContext();
                            int addr = context.getIntArg(0);
                            UnidbgPointer info = context.getPointerArg(1);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("dladdr addr=0x" + Long.toHexString(addr) + ", info=" + info));
                            }
                            if ((module = emulator.getMemory().findModuleByAddress((long)addr)) == null) {
                                return 0L;
                            }
                            Symbol symbol = module.findClosestSymbolByAddress((long)addr, true);
                            DlInfo dlInfo = new DlInfo((Pointer)info);
                            dlInfo.dli_fname = module.createPathMemory(svcMemory);
                            dlInfo.dli_fbase = UnidbgPointer.pointer(emulator, (long)module.base);
                            if (symbol != null) {
                                dlInfo.dli_sname = symbol.createNameMemory(svcMemory);
                                dlInfo.dli_saddr = UnidbgPointer.pointer(emulator, (long)symbol.getAddress());
                            }
                            dlInfo.pack();
                            return 1L;
                        }
                    }).peer;
                }
                case "dlsym": {
                    return svcMemory.registerSvc((Svc)new ArmSvc(){

                        public long handle(Emulator<?> emulator) {
                            RegisterContext context = emulator.getContext();
                            int handle = context.getIntArg(0);
                            UnidbgPointer symbol = context.getPointerArg(1);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("dlsym handle=0x" + Long.toHexString(handle) + ", symbol=" + symbol.getString(0L)));
                            }
                            return ArmLD.this.dlsym(emulator, (int)((long)handle & 0xFFFFFFFFL), symbol.getString(0L));
                        }
                    }).peer;
                }
                case "dl_unwind_find_exidx": {
                    return svcMemory.registerSvc((Svc)new ArmSvc(){

                        public long handle(Emulator<?> emulator) {
                            RegisterContext context = emulator.getContext();
                            UnidbgPointer pc = context.getPointerArg(0);
                            UnidbgPointer pcount = context.getPointerArg(1);
                            log.info((Object)("dl_unwind_find_exidx pc" + pc + ", pcount=" + pcount));
                            return 0L;
                        }
                    }).peer;
                }
                case "android_get_application_target_sdk_version": {
                    return svcMemory.registerSvc((Svc)new ArmHook(){

                        protected HookStatus hook(Emulator<?> emulator) {
                            return HookStatus.LR(emulator, (long)0L);
                        }
                    }).peer;
                }
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long dlopen(Memory memory, String filename, Emulator<?> emulator) {
        UnidbgPointer pointer = UnidbgPointer.register(emulator, (int)12);
        try {
            Module module = memory.dlopen(filename, false);
            pointer = pointer.share(-4L);
            if (module == null) {
                pointer.setInt(0L, 0);
                pointer = pointer.share(-4L);
                pointer.setInt(0L, 0);
                if (!"libnetd_client.so".equals(filename)) {
                    log.info((Object)("dlopen failed: " + filename + ", LR=" + emulator.getContext().getLRPointer()));
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("dlopen failed: " + filename));
                }
                this.error.setString(0L, "Resolve library " + filename + " failed");
                long l = 0L;
                return l;
            }
            pointer.setInt(0L, (int)module.base);
            pointer = pointer.share(-4L);
            pointer.setInt(0L, 0);
            for (Module md : memory.getLoadedModules()) {
                LinuxModule m = (LinuxModule)md;
                if (!m.getUnresolvedSymbol().isEmpty()) continue;
                for (InitFunction initFunction : m.initFunctionList) {
                    long address = initFunction.getAddress();
                    if (address == 0L) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("[" + m.name + "]PushInitFunction: 0x" + Long.toHexString(address)));
                    }
                    pointer = pointer.share(-4L);
                    pointer.setInt(0L, (int)address);
                }
                m.initFunctionList.clear();
            }
            long l = module.base;
            return l;
        }
        finally {
            this.backend.reg_write(12, (Number)pointer.peer);
        }
    }

    private int dlclose(Memory memory, long handle) {
        if (memory.dlclose(handle)) {
            return 0;
        }
        this.error.setString(0L, "dlclose 0x" + Long.toHexString(handle) + " failed");
        return -1;
    }
}

