/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.android.dvm;

import com.github.unidbg.Emulator;
import com.github.unidbg.linux.android.dvm.BaseVM;
import com.github.unidbg.linux.android.dvm.apk.Apk;
import com.github.unidbg.spi.LibraryFile;
import java.nio.ByteBuffer;

class ApkLibraryFile
implements LibraryFile {
    private final BaseVM baseVM;
    private final Apk apk;
    private final String soName;
    private final byte[] soData;
    private final String packageName;
    private final String appDir;
    private final boolean is64Bit;

    ApkLibraryFile(BaseVM baseVM, Apk apk, String soName, byte[] soData, String packageName, boolean is64Bit) {
        this.baseVM = baseVM;
        this.apk = apk;
        this.soName = soName;
        this.soData = soData;
        this.packageName = packageName;
        this.appDir = packageName == null ? "" : '/' + packageName + "-1";
        this.is64Bit = is64Bit;
    }

    public String getName() {
        return this.soName;
    }

    public String getMapRegionName() {
        return this.getPath();
    }

    public LibraryFile resolveLibrary(Emulator<?> emulator, String soName) {
        byte[] libData = this.baseVM.loadLibraryData(this.apk, soName);
        return libData == null ? null : new ApkLibraryFile(this.baseVM, this.apk, soName, libData, this.packageName, this.is64Bit);
    }

    public ByteBuffer mapBuffer() {
        return ByteBuffer.wrap(this.soData);
    }

    public String getPath() {
        return "/data/app" + this.appDir + "/lib/" + (this.is64Bit ? "arm64/" : "arm/") + this.soName;
    }
}

