/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.android.dvm;

import com.github.unidbg.Emulator;
import com.github.unidbg.linux.android.dvm.ArmVarArg;
import com.github.unidbg.linux.android.dvm.BaseVM;
import com.github.unidbg.linux.android.dvm.DvmMethod;
import com.github.unidbg.linux.android.dvm.Shorty;
import com.github.unidbg.pointer.UnidbgPointer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class ArmVarArg64
extends ArmVarArg {
    ArmVarArg64(Emulator<?> emulator, BaseVM vm, DvmMethod method) {
        super(emulator, vm, method);
        int offset = 0;
        int floatOff = 0;
        block6: for (Shorty shorty : this.shorties) {
            switch (shorty.getType()) {
                case 'B': 
                case 'C': 
                case 'I': 
                case 'L': 
                case 'S': 
                case 'Z': {
                    this.args.add(this.getInt(offset++));
                    continue block6;
                }
                case 'D': {
                    this.args.add(this.getVectorArg(floatOff++));
                    continue block6;
                }
                case 'F': {
                    this.args.add(Float.valueOf((float)this.getVectorArg(floatOff++)));
                    continue block6;
                }
                case 'J': {
                    UnidbgPointer ptr = this.getArg(offset++);
                    assert (ptr != null);
                    this.args.add(ptr.toUIntPeer());
                    continue block6;
                }
                default: {
                    throw new IllegalStateException("c=" + shorty.getType());
                }
            }
        }
    }

    private double getVectorArg(int index) {
        ByteBuffer buffer = ByteBuffer.allocate(16);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.put(this.emulator.getBackend().reg_read_vector(104 + index));
        buffer.flip();
        return buffer.getDouble();
    }
}

