/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.android.dvm;

import com.github.unidbg.linux.android.dvm.BaseVM;
import com.github.unidbg.linux.android.dvm.DvmClass;
import com.github.unidbg.linux.android.dvm.DvmObject;
import com.github.unidbg.linux.android.dvm.Hashable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class DvmField
extends Hashable {
    private final DvmClass dvmClass;
    final String fieldName;
    final String fieldType;
    private final boolean isStatic;
    public Field filed;

    DvmField(DvmClass dvmClass, String fieldName, String fieldType, boolean isStatic) {
        this.dvmClass = dvmClass;
        this.fieldName = fieldName;
        this.fieldType = fieldType;
        this.isStatic = isStatic;
    }

    public DvmClass getDvmClass() {
        return this.dvmClass;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    final String getSignature() {
        return this.dvmClass.getClassName() + "->" + this.fieldName + ":" + this.fieldType;
    }

    DvmObject<?> getStaticObjectField() {
        BaseVM vm = this.dvmClass.vm;
        return this.checkJni(vm, this.dvmClass).getStaticObjectField(vm, this.dvmClass, this);
    }

    boolean getStaticBooleanField() {
        BaseVM vm = this.dvmClass.vm;
        return this.checkJni(vm, this.dvmClass).getStaticBooleanField(vm, this.dvmClass, this);
    }

    byte getStaticByteField() {
        BaseVM vm = this.dvmClass.vm;
        return this.checkJni(vm, this.dvmClass).getStaticByteField(vm, this.dvmClass, this);
    }

    int getStaticIntField() {
        BaseVM vm = this.dvmClass.vm;
        return this.checkJni(vm, this.dvmClass).getStaticIntField(vm, this.dvmClass, this);
    }

    DvmObject<?> getObjectField(DvmObject<?> dvmObject) {
        BaseVM vm = this.dvmClass.vm;
        return this.checkJni(vm, this.dvmClass).getObjectField(vm, dvmObject, this);
    }

    int getIntField(DvmObject<?> dvmObject) {
        BaseVM vm = this.dvmClass.vm;
        return this.checkJni(vm, this.dvmClass).getIntField(vm, dvmObject, this);
    }

    long getLongField(DvmObject<?> dvmObject) {
        BaseVM vm = this.dvmClass.vm;
        return this.checkJni(vm, this.dvmClass).getLongField(vm, dvmObject, this);
    }

    float getFloatField(DvmObject<?> dvmObject) {
        BaseVM vm = this.dvmClass.vm;
        return this.checkJni(vm, this.dvmClass).getFloatField(vm, dvmObject, this);
    }

    void setObjectField(DvmObject<?> dvmObject, DvmObject<?> value) {
        BaseVM vm = this.dvmClass.vm;
        this.checkJni(vm, this.dvmClass).setObjectField(vm, dvmObject, this, value);
    }

    int getBooleanField(DvmObject<?> dvmObject) {
        BaseVM vm = this.dvmClass.vm;
        return this.checkJni(vm, this.dvmClass).getBooleanField(vm, dvmObject, this) ? 1 : 0;
    }

    void setIntField(DvmObject<?> dvmObject, int value) {
        BaseVM vm = this.dvmClass.vm;
        this.checkJni(vm, this.dvmClass).setIntField(vm, dvmObject, this, value);
    }

    void setLongField(DvmObject<?> dvmObject, long value) {
        BaseVM vm = this.dvmClass.vm;
        this.checkJni(vm, this.dvmClass).setLongField(vm, dvmObject, this, value);
    }

    void setBooleanField(DvmObject<?> dvmObject, boolean value) {
        BaseVM vm = this.dvmClass.vm;
        this.checkJni(vm, this.dvmClass).setBooleanField(vm, dvmObject, this, value);
    }

    void setFloatField(DvmObject<?> dvmObject, float value) {
        BaseVM vm = this.dvmClass.vm;
        this.checkJni(vm, this.dvmClass).setFloatField(vm, dvmObject, this, value);
    }

    void setDoubleField(DvmObject<?> dvmObject, double value) {
        BaseVM vm = this.dvmClass.vm;
        this.checkJni(vm, this.dvmClass).setDoubleField(vm, dvmObject, this, value);
    }

    void setStaticObjectField(DvmObject<?> value) {
        BaseVM vm = this.dvmClass.vm;
        this.checkJni(vm, this.dvmClass).setStaticObjectField(vm, this.dvmClass, this, value);
    }

    void setStaticIntField(int value) {
        BaseVM vm = this.dvmClass.vm;
        this.checkJni(vm, this.dvmClass).setStaticIntField(vm, this.dvmClass, this, value);
    }

    void setStaticLongField(long value) {
        BaseVM vm = this.dvmClass.vm;
        this.checkJni(vm, this.dvmClass).setStaticLongField(vm, this.dvmClass, this, value);
    }

    void setStaticFloatField(float value) {
        BaseVM vm = this.dvmClass.vm;
        this.checkJni(vm, this.dvmClass).setStaticFloatField(vm, this.dvmClass, this, value);
    }

    void setStaticDoubleField(double value) {
        BaseVM vm = this.dvmClass.vm;
        this.checkJni(vm, this.dvmClass).setStaticDoubleField(vm, this.dvmClass, this, value);
    }

    long getStaticLongField() {
        BaseVM vm = this.dvmClass.vm;
        return this.checkJni(vm, this.dvmClass).getStaticLongField(vm, this.dvmClass, this);
    }

    public void setFiled(Field filed) {
        filed.setAccessible(true);
        if (Modifier.isStatic(filed.getModifiers()) ^ this.isStatic) {
            throw new IllegalStateException(this.toString());
        }
        this.filed = filed;
    }

    public String toString() {
        return this.getSignature();
    }
}

