/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.android.dvm;

import com.github.unidbg.linux.android.dvm.BaseVM;
import com.github.unidbg.linux.android.dvm.DvmMethod;
import com.github.unidbg.linux.android.dvm.Shorty;
import com.github.unidbg.linux.android.dvm.VaList;
import com.github.unidbg.pointer.UnidbgPointer;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class JValueList
extends VaList {
    private static final Log log = LogFactory.getLog(JValueList.class);

    JValueList(BaseVM vm, UnidbgPointer jvalue, DvmMethod method) {
        super(vm, method);
        UnidbgPointer pointer = jvalue;
        for (Shorty shorty : this.shorties) {
            switch (shorty.getType()) {
                case 'L': {
                    UnidbgPointer ptr = (UnidbgPointer)pointer.getPointer(0L);
                    this.args.add((int)ptr.toUIntPeer());
                    break;
                }
                case 'B': {
                    char val = pointer.getByte(0L);
                    this.args.add(val & 0xFF);
                    break;
                }
                case 'Z': {
                    char val = pointer.getByte(0L);
                    this.args.add(val & '\u0001');
                    break;
                }
                case 'C': {
                    char val = pointer.getChar(0L);
                    this.args.add(Integer.valueOf(val));
                    break;
                }
                case 'S': {
                    this.args.add(Integer.valueOf(pointer.getShort(0L)));
                    break;
                }
                case 'I': {
                    this.args.add(pointer.getInt(0L));
                    break;
                }
                case 'F': {
                    this.args.add(Float.valueOf((float)pointer.getDouble(0L)));
                    break;
                }
                case 'D': {
                    this.args.add(pointer.getDouble(0L));
                    break;
                }
                case 'J': {
                    this.args.add(pointer.getLong(0L));
                    break;
                }
                default: {
                    throw new IllegalStateException("c=" + shorty.getType());
                }
            }
            pointer = pointer.share(8L);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("JValueList args=" + method.args + ", shorty=" + Arrays.toString(this.shorties)));
        }
    }
}

