/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.android.dvm.api;

import com.github.unidbg.arm.backend.BackendException;
import com.github.unidbg.linux.android.dvm.DvmClass;
import com.github.unidbg.linux.android.dvm.DvmObject;
import com.github.unidbg.linux.android.dvm.VM;

public class SystemService
extends DvmObject<String> {
    public static final String WIFI_SERVICE = "wifi";
    public static final String CONNECTIVITY_SERVICE = "connectivity";
    public static final String TELEPHONY_SERVICE = "phone";
    public static final String ACCESSIBILITY_SERVICE = "accessibility";
    public static final String KEYGUARD_SERVICE = "keyguard";
    public static final String ACTIVITY_SERVICE = "activity";
    public static final String SENSOR_SERVICE = "sensor";
    public static final String INPUT_METHOD_SERVICE = "input_method";

    public SystemService(VM vm, String serviceName) {
        super(SystemService.getObjectType(vm, serviceName), serviceName);
    }

    private static DvmClass getObjectType(VM vm, String serviceName) {
        switch (serviceName) {
            case "phone": {
                return vm.resolveClass("android/telephony/TelephonyManager", new DvmClass[0]);
            }
            case "wifi": {
                return vm.resolveClass("android/net/wifi/WifiManager", new DvmClass[0]);
            }
            case "connectivity": {
                return vm.resolveClass("android/net/ConnectivityManager", new DvmClass[0]);
            }
            case "accessibility": {
                return vm.resolveClass("android/view/accessibility/AccessibilityManager", new DvmClass[0]);
            }
            case "keyguard": {
                return vm.resolveClass("android/app/KeyguardManager", new DvmClass[0]);
            }
            case "activity": {
                return vm.resolveClass("android/os/BinderProxy", new DvmClass[0]);
            }
            case "sensor": {
                return vm.resolveClass("android/hardware/SensorManager", new DvmClass[0]);
            }
            case "input_method": {
                return vm.resolveClass("android/view/inputmethod/InputMethodManager", new DvmClass[0]);
            }
        }
        throw new BackendException("service failed: " + serviceName);
    }
}

