/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.android.dvm.apk;

import com.github.unidbg.linux.android.dvm.VM;
import com.github.unidbg.linux.android.dvm.api.Signature;
import com.github.unidbg.linux.android.dvm.apk.Apk;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.dongliu.apk.parser.bean.ApkMeta;
import net.dongliu.apk.parser.bean.ApkSigner;
import net.dongliu.apk.parser.bean.CertificateMeta;
import net.dongliu.apk.parser.exception.ParserException;
import net.dongliu.apk.parser.parser.ApkMetaTranslator;
import net.dongliu.apk.parser.parser.BinaryXmlParser;
import net.dongliu.apk.parser.parser.CertificateParser;
import net.dongliu.apk.parser.parser.CompositeXmlStreamer;
import net.dongliu.apk.parser.parser.XmlStreamer;
import net.dongliu.apk.parser.parser.XmlTranslator;
import net.dongliu.apk.parser.struct.resource.ResourceTable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

class ApkDir
implements Apk {
    private final File dir;
    private Signature[] signatures;
    private boolean manifestParsed;
    private String manifestXml;
    private ApkMeta apkMeta;

    ApkDir(File dir) {
        this.dir = dir;
    }

    @Override
    public long getVersionCode() {
        this.parseManifest();
        return this.apkMeta.getVersionCode();
    }

    @Override
    public String getVersionName() {
        this.parseManifest();
        return this.apkMeta.getVersionName();
    }

    @Override
    public String getManifestXml() {
        this.parseManifest();
        return this.manifestXml;
    }

    @Override
    public byte[] openAsset(String fileName) {
        return this.getFileData("assets/" + fileName);
    }

    @Override
    public byte[] getFileData(String path) {
        File file = new File(this.dir, path);
        if (file.canRead()) {
            try {
                return FileUtils.readFileToByteArray((File)file);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        return null;
    }

    @Override
    public Signature[] getSignatures(VM vm) {
        if (this.signatures == null) {
            try {
                this.parseCertificates(vm);
            }
            catch (IOException | CertificateException e) {
                throw new IllegalStateException(e);
            }
        }
        return this.signatures;
    }

    private List<CertificateFile> getAllCertificateData() throws IOException {
        ArrayList<CertificateFile> list = new ArrayList<CertificateFile>();
        this.scanCertificateFile(list, this.dir);
        return list;
    }

    private void scanCertificateFile(List<CertificateFile> list, File dir) throws IOException {
        File[] files = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String ext;
                return pathname.isDirectory() || (ext = FilenameUtils.getExtension((String)pathname.getName())).equalsIgnoreCase("RSA") || ext.equalsIgnoreCase("DSA");
            }
        });
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    this.scanCertificateFile(list, file);
                    continue;
                }
                list.add(new CertificateFile(file.getPath(), FileUtils.readFileToByteArray((File)file)));
            }
        }
    }

    private void parseCertificates(VM vm) throws IOException, CertificateException {
        ArrayList<ApkSigner> apkSigners = new ArrayList<ApkSigner>();
        for (CertificateFile file : this.getAllCertificateData()) {
            CertificateParser parser = CertificateParser.getInstance((byte[])file.getData());
            List certificateMetas = parser.parse();
            apkSigners.add(new ApkSigner(file.getPath(), certificateMetas));
        }
        ArrayList<Signature> signatures = new ArrayList<Signature>(apkSigners.size());
        for (ApkSigner signer : apkSigners) {
            for (CertificateMeta meta : signer.getCertificateMetas()) {
                signatures.add(new Signature(vm, meta));
            }
        }
        this.signatures = signatures.toArray(new Signature[0]);
    }

    @Override
    public String getPackageName() {
        this.parseManifest();
        return this.apkMeta.getPackageName();
    }

    @Override
    public File getParentFile() {
        return this.dir.getParentFile();
    }

    private void parseManifest() {
        if (this.manifestParsed) {
            return;
        }
        ResourceTable resourceTable = new ResourceTable();
        Locale preferredLocale = Locale.US;
        XmlTranslator xmlTranslator = new XmlTranslator();
        ApkMetaTranslator apkTranslator = new ApkMetaTranslator(resourceTable, preferredLocale);
        CompositeXmlStreamer xmlStreamer = new CompositeXmlStreamer(new XmlStreamer[]{xmlTranslator, apkTranslator});
        byte[] data = this.getFileData("AndroidManifest.xml");
        if (data == null) {
            throw new ParserException("Manifest file not found");
        }
        this.transBinaryXml(data, (XmlStreamer)xmlStreamer, resourceTable, preferredLocale);
        this.manifestXml = xmlTranslator.getXml();
        this.apkMeta = apkTranslator.getApkMeta();
        this.manifestParsed = true;
    }

    private void transBinaryXml(byte[] data, XmlStreamer xmlStreamer, ResourceTable resourceTable, Locale preferredLocale) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        BinaryXmlParser binaryXmlParser = new BinaryXmlParser(buffer, resourceTable);
        binaryXmlParser.setLocale(preferredLocale);
        binaryXmlParser.setXmlStreamer(xmlStreamer);
        binaryXmlParser.parse();
    }

    private static class CertificateFile {
        private final String path;
        private final byte[] data;

        CertificateFile(String path, byte[] data) {
            this.path = path;
            this.data = data;
        }

        public String getPath() {
            return this.path;
        }

        public byte[] getData() {
            return this.data;
        }
    }
}

