/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.android.dvm.array;

import com.github.unidbg.Emulator;
import com.github.unidbg.linux.android.dvm.DvmClass;
import com.github.unidbg.linux.android.dvm.VM;
import com.github.unidbg.linux.android.dvm.array.BaseArray;
import com.github.unidbg.linux.android.dvm.array.PrimitiveArray;
import com.github.unidbg.pointer.UnidbgPointer;
import com.sun.jna.Pointer;

public class DoubleArray
extends BaseArray<double[]>
implements PrimitiveArray<double[]> {
    public DoubleArray(VM vm, double[] value) {
        super(vm.resolveClass("[D", new DvmClass[0]), value);
    }

    @Override
    public int length() {
        return ((double[])this.value).length;
    }

    public void setValue(double[] value) {
        this.value = value;
    }

    @Override
    public void setData(int start, double[] data) {
        System.arraycopy(data, 0, this.value, start, data.length);
    }

    @Override
    public UnidbgPointer _GetArrayCritical(Emulator<?> emulator, Pointer isCopy) {
        if (isCopy != null) {
            isCopy.setInt(0L, 1);
        }
        UnidbgPointer pointer = this.allocateMemoryBlock(emulator, ((double[])this.value).length * 8);
        pointer.write(0L, (double[])this.value, 0, ((double[])this.value).length);
        return pointer;
    }

    @Override
    public void _ReleaseArrayCritical(Pointer elems, int mode) {
        switch (mode) {
            case 1: {
                this.setValue(elems.getDoubleArray(0L, ((double[])this.value).length));
                break;
            }
            case 0: {
                this.setValue(elems.getDoubleArray(0L, ((double[])this.value).length));
            }
            case 2: {
                this.freeMemoryBlock(elems);
            }
        }
    }
}

