/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.android.dvm.jni;

import com.github.unidbg.linux.android.dvm.jni.ProxyDvmObjectVisitor;
import java.lang.reflect.Field;

class ProxyField {
    private final ProxyDvmObjectVisitor visitor;
    private final Field field;

    ProxyField(ProxyDvmObjectVisitor visitor, Field field) {
        this.visitor = visitor;
        this.field = field;
    }

    final Object get(Object thisObj) throws IllegalAccessException {
        if (this.visitor != null) {
            this.visitor.onProxyVisit(this.field, thisObj, null);
        }
        return this.field.get(thisObj);
    }

    final long getLong(Object thisObj) throws IllegalAccessException {
        if (this.visitor != null) {
            this.visitor.onProxyVisit(this.field, thisObj, null);
        }
        return this.field.getLong(thisObj);
    }

    final float getFloat(Object thisObj) throws IllegalAccessException {
        if (this.visitor != null) {
            this.visitor.onProxyVisit(this.field, thisObj, null);
        }
        return this.field.getFloat(thisObj);
    }

    final boolean getBoolean(Object thisObj) throws IllegalAccessException {
        if (this.visitor != null) {
            this.visitor.onProxyVisit(this.field, thisObj, null);
        }
        return this.field.getBoolean(thisObj);
    }

    final byte getByte(Object thisObj) throws IllegalAccessException {
        if (this.visitor != null) {
            this.visitor.onProxyVisit(this.field, thisObj, null);
        }
        return this.field.getByte(thisObj);
    }

    final int getInt(Object thisObj) throws IllegalAccessException {
        if (this.visitor != null) {
            this.visitor.onProxyVisit(this.field, thisObj, null);
        }
        return this.field.getInt(thisObj);
    }

    final void setInt(Object thisObj, int value) throws IllegalAccessException {
        if (this.visitor != null) {
            this.visitor.onProxyVisit(this.field, thisObj, new Object[]{value});
        }
        this.field.setInt(thisObj, value);
    }

    final void setFloat(Object thisObj, float value) throws IllegalAccessException {
        if (this.visitor != null) {
            this.visitor.onProxyVisit(this.field, thisObj, new Object[]{Float.valueOf(value)});
        }
        this.field.setFloat(thisObj, value);
    }

    final void setDouble(Object thisObj, double value) throws IllegalAccessException {
        if (this.visitor != null) {
            this.visitor.onProxyVisit(this.field, thisObj, new Object[]{value});
        }
        this.field.setDouble(thisObj, value);
    }

    final void setObject(Object thisObj, Object value) throws IllegalAccessException {
        if (this.visitor != null) {
            this.visitor.onProxyVisit(this.field, thisObj, new Object[]{value});
        }
        this.field.set(thisObj, value);
    }

    final void setBoolean(Object thisObj, boolean value) throws IllegalAccessException {
        if (this.visitor != null) {
            this.visitor.onProxyVisit(this.field, thisObj, new Object[]{value});
        }
        this.field.setBoolean(thisObj, value);
    }

    final void setLong(Object thisObj, long value) throws IllegalAccessException {
        if (this.visitor != null) {
            this.visitor.onProxyVisit(this.field, thisObj, new Object[]{value});
        }
        this.field.setLong(thisObj, value);
    }
}

