/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.android.dvm.jni;

import com.github.unidbg.arm.backend.BackendException;
import com.github.unidbg.linux.android.dvm.VM;
import com.github.unidbg.linux.android.dvm.jni.ProxyCall;
import com.github.unidbg.linux.android.dvm.jni.ProxyDvmException;
import com.github.unidbg.linux.android.dvm.jni.ProxyDvmObject;
import com.github.unidbg.linux.android.dvm.jni.ProxyDvmObjectVisitor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class ProxyMethod
implements ProxyCall {
    private final ProxyDvmObjectVisitor visitor;
    private final Method method;
    private final Object[] args;

    ProxyMethod(ProxyDvmObjectVisitor visitor, Method method, Object[] args) {
        this.visitor = visitor;
        this.method = method;
        this.args = args;
    }

    @Override
    public Object call(VM vm, Object obj) throws IllegalAccessException, InvocationTargetException {
        try {
            this.patch(obj, this.args);
            if (this.visitor != null) {
                this.visitor.onProxyVisit(this.method, obj, this.args);
            }
            return this.method.invoke(obj, this.args);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getTargetException();
            if (cause instanceof BackendException) {
                throw (BackendException)cause;
            }
            if (cause instanceof ProxyDvmException) {
                vm.throwException(ProxyDvmObject.createObject(vm, cause));
                return null;
            }
            if (cause instanceof ClassNotFoundException) {
                vm.throwException(ProxyDvmObject.createObject(vm, cause));
                return null;
            }
            throw e;
        }
    }

    private void patch(Object obj, Object[] args) {
        if (obj instanceof ClassLoader && args.length == 1 && ("loadClass".equals(this.method.getName()) || "findClass".equals(this.method.getName()))) {
            String binaryName = (String)args[0];
            args[0] = binaryName.replace('/', '.');
        }
    }
}

