/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.file;

import com.github.unidbg.Emulator;
import com.github.unidbg.linux.file.DriverFileIO;
import com.github.unidbg.pointer.UnidbgPointer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class Ashmem
extends DriverFileIO {
    private static final Log log = LogFactory.getLog(Ashmem.class);
    private static final int ASHMEM_SET_NAME = 1090549505;
    private static final int ASHMEM_SET_SIZE = 1074034435;
    private String name;
    private int size;

    Ashmem(Emulator<?> emulator, int oflags, String path) {
        super(emulator, oflags, path);
    }

    @Override
    public int ioctl(Emulator<?> emulator, long request, long argp) {
        if (request == 1090549505L) {
            UnidbgPointer pointer = UnidbgPointer.pointer(emulator, (long)argp);
            assert (pointer != null);
            this.name = pointer.getString(0L);
            log.debug((Object)("ashmem set name: " + this.name));
            return 0;
        }
        if (request == 1074034435L) {
            this.size = (int)argp;
            log.debug((Object)("ashmem set size: " + this.size));
            return 0;
        }
        return super.ioctl(emulator, request, argp);
    }

    protected byte[] getMmapData(int offset, int length) {
        return new byte[0];
    }

    @Override
    public String toString() {
        return "Ashmem{name='" + this.name + '\'' + ", size=" + this.size + '}';
    }
}

