/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.file;

import com.github.unidbg.Emulator;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.file.NewFileIO;
import com.github.unidbg.file.linux.AndroidFileIO;
import com.github.unidbg.file.linux.BaseAndroidFileIO;
import com.github.unidbg.file.linux.StatStructure;
import com.github.unidbg.linux.file.Ashmem;
import com.github.unidbg.linux.file.RandomFileIO;
import com.github.unidbg.linux.file.ZeroFileIO;
import com.github.unidbg.pointer.UnidbgPointer;
import com.sun.jna.Pointer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DriverFileIO
extends BaseAndroidFileIO
implements NewFileIO,
AndroidFileIO {
    private static final Log log = LogFactory.getLog(DriverFileIO.class);
    private final Emulator<?> emulator;
    private final String path;
    private static final int _IOC_NRBITS = 8;
    private static final int _IOC_TYPEBITS = 8;
    private static final int _IOC_SIZEBITS = 14;
    private static final int _IOC_WRITE = 1;
    private static final int _IOC_READ = 2;
    private static final int ANDROID_ALARM_GET_TIME = 4;

    public static DriverFileIO create(Emulator<?> emulator, int oflags, String pathname) {
        if ("/dev/urandom".equals(pathname) || "/dev/random".equals(pathname) || "/dev/srandom".equals(pathname)) {
            return new RandomFileIO(emulator, pathname);
        }
        if ("/dev/alarm".equals(pathname) || "/dev/null".equals(pathname)) {
            return new DriverFileIO(emulator, oflags, pathname);
        }
        if ("/dev/ashmem".equals(pathname)) {
            return new Ashmem(emulator, oflags, pathname);
        }
        if ("/dev/zero".equals(pathname)) {
            return new ZeroFileIO(emulator, oflags, pathname);
        }
        return null;
    }

    DriverFileIO(Emulator<?> emulator, int oflags, String path) {
        super(oflags);
        this.emulator = emulator;
        this.path = path;
    }

    public void close() {
    }

    public int write(byte[] data) {
        throw new AbstractMethodError();
    }

    public int read(Backend backend, Pointer buffer, int count) {
        throw new AbstractMethodError();
    }

    public int ioctl(Emulator<?> emulator, long request, long argp) {
        if ("/dev/alarm".equals(this.path)) {
            long ioc = request;
            long nr = ioc & 0xFFL;
            long type = (ioc >>= 8) & 0xFFL;
            long size = (ioc >>= 8) & 0x3FFFL;
            long dir = ioc >>= 14;
            if (type == 97L) {
                long c = nr & 0xFL;
                type = nr >> 4;
                return this.androidAlarm(dir, c, AndroidAlarmType.valueOf(type), size, argp);
            }
            log.info((Object)("alarm ioctl request=0x" + Long.toHexString(request) + ", argp=0x" + Long.toHexString(argp) + ", nr=" + nr + ", type=" + type + ", size=" + size + ", dir=" + dir));
            return -1;
        }
        return super.ioctl(emulator, request, argp);
    }

    private int androidAlarm(long dir, long c, AndroidAlarmType type, long size, long argp) {
        if (dir == 1L && c == 4L && type == AndroidAlarmType.ANDROID_ALARM_ELAPSED_REALTIME) {
            long offset = System.currentTimeMillis();
            long tv_sec = offset / 1000000000L;
            long tv_nsec = offset % 1000000000L;
            UnidbgPointer pointer = UnidbgPointer.pointer(this.emulator, (long)argp);
            if (pointer == null) {
                throw new IllegalArgumentException();
            }
            if (size == 8L) {
                pointer.setInt(0L, (int)tv_sec);
                pointer.setInt(4L, (int)tv_nsec);
                return 0;
            }
            if (size == 16L) {
                pointer.setLong(0L, tv_sec);
                pointer.setLong(8L, tv_nsec);
                return 0;
            }
            throw new IllegalArgumentException("size=" + size);
        }
        log.info((Object)("androidAlarm argp=0x" + Long.toHexString(argp) + ", c=" + c + ", type=" + (Object)((Object)type) + ", size=" + size + ", dir=" + dir));
        return -1;
    }

    @Override
    public int fstat(Emulator<?> emulator, StatStructure stat) {
        return 0;
    }

    @Override
    public int getdents64(Pointer dirp, int size) {
        throw new UnsupportedOperationException(this.path);
    }

    public String toString() {
        return this.path;
    }

    private static enum AndroidAlarmType {
        ANDROID_ALARM_RTC_WAKEUP,
        ANDROID_ALARM_RTC,
        ANDROID_ALARM_ELAPSED_REALTIME_WAKEUP,
        ANDROID_ALARM_ELAPSED_REALTIME,
        ANDROID_ALARM_SYSTEMTIME,
        ANDROID_ALARM_TYPE_COUNT;


        static AndroidAlarmType valueOf(long type) {
            for (AndroidAlarmType alarmType : AndroidAlarmType.values()) {
                if ((long)alarmType.ordinal() != type) continue;
                return alarmType;
            }
            throw new IllegalArgumentException("type=" + type);
        }
    }
}

