/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.file;

import com.github.unidbg.Emulator;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.file.linux.AndroidFileIO;
import com.github.unidbg.file.linux.BaseAndroidFileIO;
import com.github.unidbg.file.linux.StatStructure;
import com.github.unidbg.unix.struct.SockAddr;
import com.sun.jna.Pointer;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SocketIO
extends BaseAndroidFileIO
implements AndroidFileIO {
    private static final Log log = LogFactory.getLog(SocketIO.class);
    public static final short AF_UNSPEC = 0;
    public static final short AF_LOCAL = 1;
    public static final short AF_INET = 2;
    public static final short AF_INET6 = 10;
    public static final short AF_NETLINK = 16;
    public static final short AF_ROUTE = 17;
    public static final short AF_LINK = 18;
    protected static final int IPV4_ADDR_LEN = 16;
    protected static final int IPV6_ADDR_LEN = 28;
    public static final int SOCK_STREAM = 1;
    public static final int SOCK_DGRAM = 2;
    public static final int SOCK_RAW = 3;
    private static final int IPPROTO_IP = 0;
    public static final int IPPROTO_ICMP = 1;
    public static final int IPPROTO_TCP = 6;
    protected static final int SOL_SOCKET = 1;
    private static final int SO_REUSEADDR = 2;
    private static final int SO_ERROR = 4;
    private static final int SO_BROADCAST = 6;
    private static final int SO_SNDBUF = 7;
    private static final int SO_RCVBUF = 8;
    private static final int SO_KEEPALIVE = 9;
    private static final int SO_RCVTIMEO = 20;
    private static final int SO_SNDTIMEO = 21;
    protected static final int SO_PEERSEC = 31;
    static final int SHUT_RD = 0;
    static final int SHUT_WR = 1;
    static final int SHUT_RDWR = 2;
    private static final int TCP_NODELAY = 1;
    private static final int TCP_MAXSEG = 2;
    static final int MSG_PEEK = 2;
    private static final int MSG_NOSIGNAL = 16384;

    protected SocketIO() {
        super(2);
    }

    public int getsockopt(int level, int optname, Pointer optval, Pointer optlen) {
        try {
            switch (level) {
                case 1: {
                    if (optname != 4) break;
                    optlen.setInt(0L, 4);
                    optval.setInt(0L, 0);
                    return 0;
                }
                case 6: {
                    if (optname != 1) break;
                    optlen.setInt(0L, 4);
                    optval.setInt(0L, this.getTcpNoDelay());
                    return 0;
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return super.getsockopt(level, optname, optval, optlen);
    }

    protected abstract int getTcpNoDelay() throws SocketException;

    public int setsockopt(int level, int optname, Pointer optval, int optlen) {
        try {
            switch (level) {
                case 1: {
                    switch (optname) {
                        case 2: {
                            if (optlen != 4) {
                                throw new IllegalStateException("optlen=" + optlen);
                            }
                            this.setReuseAddress(optval.getInt(0L));
                            return 0;
                        }
                        case 6: {
                            if (optlen != 4) {
                                throw new IllegalStateException("optlen=" + optlen);
                            }
                            optval.getInt(0L);
                            return 0;
                        }
                        case 7: {
                            if (optlen != 4) {
                                throw new IllegalStateException("optlen=" + optlen);
                            }
                            this.setSendBufferSize(optval.getInt(0L));
                            return 0;
                        }
                        case 8: {
                            if (optlen != 4) {
                                throw new IllegalStateException("optlen=" + optlen);
                            }
                            this.setReceiveBufferSize(optval.getInt(0L));
                            return 0;
                        }
                        case 9: {
                            if (optlen != 4) {
                                throw new IllegalStateException("optlen=" + optlen);
                            }
                            this.setKeepAlive(optval.getInt(0L));
                            return 0;
                        }
                        case 20: 
                        case 21: {
                            return 0;
                        }
                    }
                    break;
                }
                case 6: {
                    switch (optname) {
                        case 1: {
                            if (optlen != 4) {
                                throw new IllegalStateException("optlen=" + optlen);
                            }
                            this.setTcpNoDelay(optval.getInt(0L));
                            return 0;
                        }
                        case 2: {
                            if (optlen != 4) {
                                throw new IllegalStateException("optlen=" + optlen);
                            }
                            log.debug((Object)("setsockopt TCP_MAXSEG=" + optval.getInt(0L)));
                            return 0;
                        }
                    }
                    break;
                }
                case 0: {
                    return 0;
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        log.warn((Object)("setsockopt level=" + level + ", optname=" + optname + ", optval=" + optval + ", optlen=" + optlen));
        return 0;
    }

    protected abstract void setTcpNoDelay(int var1) throws SocketException;

    protected abstract void setReuseAddress(int var1) throws SocketException;

    protected abstract void setKeepAlive(int var1) throws SocketException;

    protected abstract void setSendBufferSize(int var1) throws SocketException;

    protected abstract void setReceiveBufferSize(int var1) throws SocketException;

    public int getsockname(Pointer addr, Pointer addrlen) {
        InetSocketAddress local = this.getLocalSocketAddress();
        this.fillAddress(local, addr, addrlen);
        return 0;
    }

    protected final void fillAddress(InetSocketAddress socketAddress, Pointer addr, Pointer addrlen) {
        InetAddress address = socketAddress.getAddress();
        SockAddr sockAddr = new SockAddr(addr);
        sockAddr.sin_port = (short)socketAddress.getPort();
        if (address instanceof Inet4Address) {
            sockAddr.sin_family = (short)2;
            sockAddr.sin_addr = Arrays.copyOf(address.getAddress(), 12);
            addrlen.setInt(0L, 16);
        } else if (address instanceof Inet6Address) {
            sockAddr.sin_family = (short)10;
            sockAddr.sin_addr = Arrays.copyOf(address.getAddress(), 24);
            addrlen.setInt(0L, 28);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    protected abstract InetSocketAddress getLocalSocketAddress();

    public int connect(Pointer addr, int addrlen) {
        if (addrlen == 16) {
            return this.connect_ipv4(addr, addrlen);
        }
        if (addrlen == 28) {
            return this.connect_ipv6(addr, addrlen);
        }
        throw new IllegalStateException("addrlen=" + addrlen);
    }

    public final int bind(Pointer addr, int addrlen) {
        if (addrlen == 16) {
            return this.bind_ipv4(addr, addrlen);
        }
        if (addrlen == 28) {
            return this.bind_ipv6(addr, addrlen);
        }
        throw new IllegalStateException("addrlen=" + addrlen);
    }

    protected abstract int connect_ipv6(Pointer var1, int var2);

    protected abstract int connect_ipv4(Pointer var1, int var2);

    protected int bind_ipv6(Pointer addr, int addrlen) {
        throw new AbstractMethodError(this.getClass().getName());
    }

    protected int bind_ipv4(Pointer addr, int addrlen) {
        throw new AbstractMethodError(this.getClass().getName());
    }

    public int recvfrom(Backend backend, Pointer buf, int len, int flags, Pointer src_addr, Pointer addrlen) {
        if (flags == 0 && src_addr == null && addrlen == null) {
            return this.read(backend, buf, len);
        }
        return super.recvfrom(backend, buf, len, flags, src_addr, addrlen);
    }

    public int sendto(byte[] data, int flags, Pointer dest_addr, int addrlen) {
        if ((flags &= 0xFFFFBFFF) == 0 && dest_addr == null && addrlen == 0) {
            return this.write(data);
        }
        return super.sendto(data, flags, dest_addr, addrlen);
    }

    @Override
    public int fstat(Emulator<?> emulator, StatStructure stat) {
        stat.st_dev = 0L;
        stat.st_mode = 49152;
        stat.st_uid = 0;
        stat.st_gid = 0;
        stat.st_size = 0L;
        stat.st_blksize = 0;
        stat.st_ino = 0L;
        stat.pack();
        return 0;
    }

    @Override
    public int getdents64(Pointer dirp, int size) {
        throw new UnsupportedOperationException();
    }
}

