/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.thread;

import com.github.unidbg.Emulator;
import com.github.unidbg.Module;
import com.github.unidbg.Svc;
import com.github.unidbg.Symbol;
import com.github.unidbg.arm.ArmSvc;
import com.github.unidbg.arm.context.Arm32RegisterContext;
import com.github.unidbg.hook.hookzz.IHookZz;
import com.github.unidbg.memory.Memory;
import com.github.unidbg.memory.SvcMemory;
import com.github.unidbg.pointer.UnidbgPointer;
import com.sun.jna.Pointer;
import java.util.Arrays;
import keystone.Keystone;
import keystone.KeystoneArchitecture;
import keystone.KeystoneEncoded;
import keystone.KeystoneMode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ThreadJoin19 {
    private static final Log log = LogFactory.getLog(ThreadJoin19.class);

    public static void patch(Emulator<?> emulator, IHookZz hookZz) {
        if (emulator.is64Bit()) {
            throw new IllegalStateException();
        }
        Memory memory = emulator.getMemory();
        SvcMemory svcMemory = emulator.getSvcMemory();
        Module libc = memory.findModule("libc.so");
        Symbol _pthread_clone = libc.findSymbolByName("__pthread_clone", false);
        if (_pthread_clone == null) {
            throw new IllegalStateException("find __pthread_clone failed.");
        }
        hookZz.replace(_pthread_clone, (Pointer)svcMemory.registerSvc((Svc)new ArmSvc(){

            public long handle(Emulator<?> emulator) {
                Arm32RegisterContext context = (Arm32RegisterContext)emulator.getContext();
                UnidbgPointer start_routine = context.getPointerArg(0);
                UnidbgPointer child_stack = context.getPointerArg(1);
                int flags = context.getIntArg(2);
                UnidbgPointer arg = context.getPointerArg(3);
                log.info((Object)("pthread_clone start_routine=" + start_routine + ", child_stack=" + child_stack + ", flags=0x" + Integer.toHexString(flags) + ", arg=" + arg));
                return context.getR0Int();
            }

            public UnidbgPointer onRegister(SvcMemory svcMemory, int svcNumber) {
                try (Keystone keystone = new Keystone(KeystoneArchitecture.Arm, KeystoneMode.Arm);){
                    KeystoneEncoded encoded = keystone.assemble(Arrays.asList("push {r4-r7, lr}", "svc #0x" + Integer.toHexString(svcNumber), "mov ip, r0", "mov r0, r3", "blx ip", "mov r0, #1", "pop {r4-r7, pc}"));
                    byte[] code = encoded.getMachineCode();
                    UnidbgPointer pointer = svcMemory.allocate(code.length, "ArmSvc");
                    pointer.write(code);
                    UnidbgPointer unidbgPointer = pointer;
                    return unidbgPointer;
                }
            }
        }));
    }
}

