/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.linux.thread;

import com.github.unidbg.Emulator;
import com.github.unidbg.Module;
import com.github.unidbg.Svc;
import com.github.unidbg.Symbol;
import com.github.unidbg.arm.Arm64Svc;
import com.github.unidbg.arm.ArmSvc;
import com.github.unidbg.arm.context.RegisterContext;
import com.github.unidbg.hook.hookzz.IHookZz;
import com.github.unidbg.memory.Memory;
import com.github.unidbg.memory.SvcMemory;
import com.github.unidbg.pointer.UnidbgPointer;
import com.sun.jna.Pointer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ThreadJoin23 {
    public static void patch(Emulator<?> emulator, IHookZz hookZz) {
        Memory memory = emulator.getMemory();
        SvcMemory svcMemory = emulator.getSvcMemory();
        Module libc = memory.findModule("libc.so");
        Symbol clone = libc.findSymbolByName("clone", false);
        if (clone == null) {
            throw new IllegalStateException("find clone failed.");
        }
        hookZz.replace(clone, (Pointer)svcMemory.registerSvc((Svc)(emulator.is32Bit() ? new ArmSvc(){

            public long handle(Emulator<?> emulator) {
                RegisterContext context = emulator.getContext();
                UnidbgPointer pthread_start = context.getPointerArg(0);
                UnidbgPointer child_stack = context.getPointerArg(1);
                int flags = context.getIntArg(2);
                UnidbgPointer thread = context.getPointerArg(3);
                System.out.println("clone pthread_start=" + pthread_start + ", child_stack=" + child_stack + ", flags=0x" + Integer.toHexString(flags) + ", thread=" + thread);
                return 0L;
            }

            public UnidbgPointer onRegister(SvcMemory svcMemory, int svcNumber) {
                ByteBuffer buffer = ByteBuffer.allocate(8);
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                buffer.putInt(1.assembleSvc((int)svcNumber));
                buffer.putInt(-516948194);
                byte[] code = buffer.array();
                UnidbgPointer pointer = svcMemory.allocate(code.length, "ArmSvc");
                pointer.write(code);
                return pointer;
            }
        } : new Arm64Svc(){

            public long handle(Emulator<?> emulator) {
                throw new UnsupportedOperationException();
            }
        })));
    }
}

