/*
 * Decompiled with CFR 0.152.
 */
package net.fornwall.jelf;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.fornwall.jelf.ElfDataIn;
import net.fornwall.jelf.ElfException;

class ElfBuffer
implements ElfDataIn {
    private final ByteBuffer buffer;

    public ElfBuffer(byte[] array) {
        this.buffer = ByteBuffer.wrap(array);
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public short readUnsignedByte() throws ElfException {
        return (short)(this.buffer.get() & 0xFF);
    }

    @Override
    public short readShort() throws ElfException {
        return this.buffer.getShort();
    }

    @Override
    public int readInt() throws ElfException {
        return this.buffer.getInt();
    }

    @Override
    public long readLong() throws ElfException {
        return this.buffer.getLong();
    }
}

