/*
 * Decompiled with CFR 0.152.
 */
package net.fornwall.jelf;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.fornwall.jelf.AndroidRelocation;
import net.fornwall.jelf.ElfException;
import net.fornwall.jelf.ElfGnuHashTable;
import net.fornwall.jelf.ElfHashTable;
import net.fornwall.jelf.ElfInitArray;
import net.fornwall.jelf.ElfParser;
import net.fornwall.jelf.ElfRelocation;
import net.fornwall.jelf.ElfStringTable;
import net.fornwall.jelf.ElfSymbolStructure;
import net.fornwall.jelf.HashTable;
import net.fornwall.jelf.MemoizedObject;
import net.fornwall.jelf.SymbolLocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ElfDynamicStructure {
    private static final Log log = LogFactory.getLog(ElfDynamicStructure.class);
    private static final int DT_NULL = 0;
    private static final int DT_NEEDED = 1;
    private static final int DT_PLTRELSZ = 2;
    public static final int DT_PLTGOT = 3;
    private static final int DT_HASH = 4;
    private static final int DT_STRTAB = 5;
    private static final int DT_SYMTAB = 6;
    public static final int DT_RELA = 7;
    public static final int DT_RELASZ = 8;
    public static final int DT_RELAENT = 9;
    private static final int DT_STRSZ = 10;
    private static final int DT_SYMENT = 11;
    private static final int DT_INIT = 12;
    public static final int DT_FINI = 13;
    private static final int DT_SONAME = 14;
    public static final int DT_RPATH = 15;
    private static final int DT_REL = 17;
    private static final int DT_RELSZ = 18;
    private static final int DT_RELENT = 19;
    private static final int DT_JMPREL = 23;
    private static final int DT_INIT_ARRAY = 25;
    private static final int DT_INIT_ARRAYSZ = 27;
    public static final int DT_RUNPATH = 29;
    private static final int DT_PREINIT_ARRAY = 32;
    private static final int DT_PREINIT_ARRAYSZ = 33;
    private static final int DT_VERSYM = 0x6FFFFFF0;
    private static final int DT_GNU_HASH = 1879047925;
    private static final int DT_RELACOUNT = 0x6FFFFFF9;
    private static final int DT_RELCOUNT = 0x6FFFFFFA;
    private static final int DT_FLAGS_1 = 0x6FFFFFFB;
    private static final int DT_VERDEF = 0x6FFFFFFC;
    private static final int DT_VERDEFNUM = 0x6FFFFFFD;
    private static final int DT_VERNEEDED = 0x6FFFFFFE;
    private static final int DT_VERNEEDNUM = 0x6FFFFFFF;
    private static final int DT_AUXILIARY = 0x7FFFFFFD;
    private static final int DT_ANDROID_REL = 0x6000000F;
    private static final int DT_ANDROID_RELSZ = 0x60000010;
    private static final int DT_ANDROID_RELA = 0x60000011;
    private static final int DT_ANDROID_RELASZ = 1610612754;
    public static final int DF_1_NOW = 1;
    public static final int DF_1_GLOBAL = 2;
    public static final int DF_1_GROUP = 4;
    public static final int DF_1_NODELETE = 8;
    public long dt_strtab_offset;
    private int dt_strtab_size;
    private MemoizedObject<ElfStringTable> dtStringTable;
    private final int[] dtNeeded;
    public final int soName;
    private final int init;
    private long initArrayOffset;
    private long preInitArrayOffset;
    private int initArraySize;
    private int preInitArraySize;
    private MemoizedObject<ElfInitArray> initArray;
    private MemoizedObject<ElfInitArray> preInitArray;
    private MemoizedObject<ElfSymbolStructure> symbolStructure;
    private int symbolEntrySize;
    private long symbolOffset;
    private long hashOffset;
    private long gnuHashOffset;
    private long relOffset;
    private int relSize;
    private int relEntrySize;
    private long pltRelOffset;
    private int pltRelSize;
    private long androidRelOffset;
    private long androidRelAOffset;
    private int androidRelSize;
    private int androidRelASize;
    private MemoizedObject<ElfRelocation>[] rel;
    private MemoizedObject<ElfRelocation>[] pltRel;
    private MemoizedObject<AndroidRelocation> androidRelocation;

    ElfDynamicStructure(final ElfParser parser, long offset, int size) throws IOException {
        int i;
        long fileOffset;
        parser.seek(offset);
        int numEntries = size / (parser.elfFile.objectSize == 1 ? 8 : 16);
        ArrayList<Integer> dtNeededList = new ArrayList<Integer>();
        int soName = -1;
        int init = 0;
        block26: for (int i2 = 0; i2 < numEntries; ++i2) {
            long d_tag = parser.readIntOrLong();
            long d_val_or_ptr = parser.readIntOrLong();
            switch ((int)d_tag) {
                case 0: {
                    break block26;
                }
                case 1: {
                    dtNeededList.add((int)d_val_or_ptr);
                    continue block26;
                }
                case 5: {
                    this.dt_strtab_offset = d_val_or_ptr;
                    continue block26;
                }
                case 10: {
                    if (d_val_or_ptr > Integer.MAX_VALUE) {
                        throw new ElfException("Too large DT_STRSZ: " + d_val_or_ptr);
                    }
                    this.dt_strtab_size = (int)d_val_or_ptr;
                    continue block26;
                }
                case 14: {
                    soName = (int)d_val_or_ptr;
                    continue block26;
                }
                case 12: {
                    init = (int)d_val_or_ptr;
                    continue block26;
                }
                case 25: {
                    this.initArrayOffset = d_val_or_ptr;
                    continue block26;
                }
                case 27: {
                    this.initArraySize = (int)d_val_or_ptr;
                    continue block26;
                }
                case 32: {
                    this.preInitArrayOffset = d_val_or_ptr;
                    continue block26;
                }
                case 33: {
                    this.preInitArraySize = (int)d_val_or_ptr;
                    continue block26;
                }
                case 11: {
                    this.symbolEntrySize = (int)d_val_or_ptr;
                    continue block26;
                }
                case 6: {
                    this.symbolOffset = d_val_or_ptr;
                    continue block26;
                }
                case 4: {
                    this.hashOffset = d_val_or_ptr;
                    continue block26;
                }
                case 1879047925: {
                    this.gnuHashOffset = d_val_or_ptr;
                    continue block26;
                }
                case 7: 
                case 17: {
                    this.relOffset = d_val_or_ptr;
                    continue block26;
                }
                case 8: 
                case 18: {
                    this.relSize = (int)d_val_or_ptr;
                    continue block26;
                }
                case 9: 
                case 19: {
                    this.relEntrySize = (int)d_val_or_ptr;
                    continue block26;
                }
                case 2: {
                    this.pltRelSize = (int)d_val_or_ptr;
                    continue block26;
                }
                case 23: {
                    this.pltRelOffset = d_val_or_ptr;
                    continue block26;
                }
                case 1610612754: {
                    this.androidRelASize = (int)d_val_or_ptr;
                    continue block26;
                }
                case 0x60000010: {
                    this.androidRelSize = (int)d_val_or_ptr;
                    continue block26;
                }
                case 0x60000011: {
                    this.androidRelAOffset = d_val_or_ptr;
                    continue block26;
                }
                case 0x6000000F: {
                    this.androidRelOffset = d_val_or_ptr;
                    continue block26;
                }
                case 0x6FFFFFF0: 
                case 0x6FFFFFF9: 
                case 0x6FFFFFFA: 
                case 0x6FFFFFFB: 
                case 0x6FFFFFFC: 
                case 0x6FFFFFFD: 
                case 0x6FFFFFFE: 
                case 0x6FFFFFFF: 
                case 0x7FFFFFFD: {
                    continue block26;
                }
                default: {
                    boolean androidTag;
                    boolean bl = androidTag = (d_tag & 0x60000000L) != 0L;
                    if (!androidTag) continue block26;
                    log.warn((Object)("Unsupported android tag: 0x" + Long.toHexString(d_tag)));
                }
            }
        }
        if (this.dt_strtab_size > 0) {
            this.dtStringTable = new MemoizedObject<ElfStringTable>(){

                @Override
                protected ElfStringTable computeValue() throws ElfException, IOException {
                    return new ElfStringTable(parser, parser.virtualMemoryAddrToFileOffset(ElfDynamicStructure.this.dt_strtab_offset), ElfDynamicStructure.this.dt_strtab_size);
                }
            };
        }
        final MemoizedObject<HashTable> hashTable = this.hashOffset > 0L ? new MemoizedObject<HashTable>(){

            @Override
            protected HashTable computeValue() throws ElfException, IOException {
                return new ElfHashTable(parser, parser.virtualMemoryAddrToFileOffset(ElfDynamicStructure.this.hashOffset), -1);
            }
        } : (this.gnuHashOffset > 0L ? new MemoizedObject<HashTable>(){

            @Override
            protected HashTable computeValue() throws ElfException, IOException {
                return new ElfGnuHashTable(parser, parser.virtualMemoryAddrToFileOffset(ElfDynamicStructure.this.gnuHashOffset));
            }
        } : null);
        if (this.symbolOffset > 0L) {
            this.symbolStructure = new MemoizedObject<ElfSymbolStructure>(){

                @Override
                protected ElfSymbolStructure computeValue() throws ElfException, IOException {
                    return new ElfSymbolStructure(parser, parser.virtualMemoryAddrToFileOffset(ElfDynamicStructure.this.symbolOffset), ElfDynamicStructure.this.symbolEntrySize, ElfDynamicStructure.this.dtStringTable, hashTable);
                }
            };
        }
        if (this.relOffset > 0L) {
            int num_entries = this.relSize / this.relEntrySize;
            this.rel = MemoizedObject.uncheckedArray(num_entries);
            fileOffset = parser.virtualMemoryAddrToFileOffset(this.relOffset);
            for (i = 0; i < num_entries; ++i) {
                final long relocationOffset = fileOffset + (long)i * (long)this.relEntrySize;
                this.rel[i] = new MemoizedObject<ElfRelocation>(){

                    @Override
                    public ElfRelocation computeValue() throws IOException {
                        return new ElfRelocation(parser, relocationOffset, ElfDynamicStructure.this.relEntrySize, (SymbolLocator)ElfDynamicStructure.this.symbolStructure.getValue());
                    }
                };
            }
        }
        if (this.pltRelOffset > 0L) {
            int num_entries = this.pltRelSize / this.relEntrySize;
            this.pltRel = MemoizedObject.uncheckedArray(num_entries);
            fileOffset = parser.virtualMemoryAddrToFileOffset(this.pltRelOffset);
            for (i = 0; i < num_entries; ++i) {
                final long relocationOffset = fileOffset + (long)i * (long)this.relEntrySize;
                this.pltRel[i] = new MemoizedObject<ElfRelocation>(){

                    @Override
                    public ElfRelocation computeValue() throws IOException {
                        return new ElfRelocation(parser, relocationOffset, ElfDynamicStructure.this.relEntrySize, (SymbolLocator)ElfDynamicStructure.this.symbolStructure.getValue());
                    }
                };
            }
        }
        if (this.androidRelOffset > 0L) {
            assert (this.symbolStructure != null);
            this.androidRelocation = new MemoizedObject<AndroidRelocation>(){

                @Override
                protected AndroidRelocation computeValue() throws ElfException, IOException {
                    parser.seek(parser.virtualMemoryAddrToFileOffset(ElfDynamicStructure.this.androidRelOffset));
                    byte[] magic = new byte[4];
                    parser.read(magic);
                    if (ElfDynamicStructure.this.androidRelSize >= 4 && "APS2".equals(new String(magic))) {
                        ByteBuffer androidRelData = parser.readBuffer(ElfDynamicStructure.this.androidRelSize - 4);
                        return new AndroidRelocation(parser, (SymbolLocator)ElfDynamicStructure.this.symbolStructure.getValue(), androidRelData, false);
                    }
                    throw new IllegalStateException("bad android relocation header.");
                }
            };
        } else if (this.androidRelAOffset > 0L) {
            assert (this.symbolStructure != null);
            this.androidRelocation = new MemoizedObject<AndroidRelocation>(){

                @Override
                protected AndroidRelocation computeValue() throws ElfException, IOException {
                    parser.seek(parser.virtualMemoryAddrToFileOffset(ElfDynamicStructure.this.androidRelAOffset));
                    byte[] magic = new byte[4];
                    parser.read(magic);
                    if (ElfDynamicStructure.this.androidRelASize >= 4 && "APS2".equals(new String(magic))) {
                        ByteBuffer androidRelData = parser.readBuffer(ElfDynamicStructure.this.androidRelASize - 4);
                        return new AndroidRelocation(parser, (SymbolLocator)ElfDynamicStructure.this.symbolStructure.getValue(), androidRelData, true);
                    }
                    throw new IllegalStateException("bad android relocation header.");
                }
            };
        }
        if (this.initArraySize > 0) {
            this.initArray = new MemoizedObject<ElfInitArray>(){

                @Override
                protected ElfInitArray computeValue() throws ElfException, IOException {
                    return new ElfInitArray(parser, parser.virtualMemoryAddrToFileOffset(ElfDynamicStructure.this.initArrayOffset), ElfDynamicStructure.this.initArraySize);
                }
            };
        }
        if (this.preInitArraySize > 0) {
            this.preInitArray = new MemoizedObject<ElfInitArray>(){

                @Override
                protected ElfInitArray computeValue() throws ElfException, IOException {
                    return new ElfInitArray(parser, parser.virtualMemoryAddrToFileOffset(ElfDynamicStructure.this.preInitArrayOffset), ElfDynamicStructure.this.preInitArraySize);
                }
            };
        }
        this.dtNeeded = new int[dtNeededList.size()];
        int len = this.dtNeeded.length;
        for (int i3 = 0; i3 < len; ++i3) {
            this.dtNeeded[i3] = (Integer)dtNeededList.get(i3);
        }
        this.soName = soName;
        this.init = init;
    }

    public String getSOName(String fileName) throws IOException {
        ElfStringTable stringTable = this.dtStringTable.getValue();
        return this.soName == -1 ? fileName : stringTable.get(this.soName);
    }

    public int getInit() {
        return this.init;
    }

    public List<String> getNeededLibraries() throws ElfException, IOException {
        ArrayList<String> result = new ArrayList<String>();
        ElfStringTable stringTable = this.dtStringTable.getValue();
        for (int needed : this.dtNeeded) {
            result.add(stringTable.get(needed));
        }
        return result;
    }

    public long getInitArrayOffset() {
        return this.initArrayOffset;
    }

    public long getPreInitArrayOffset() {
        return this.preInitArrayOffset;
    }

    public int getInitArraySize() {
        return this.initArraySize;
    }

    public int getPreInitArraySize() {
        return this.preInitArraySize;
    }

    public ElfInitArray getInitArray() throws IOException {
        return this.initArray == null ? null : this.initArray.getValue();
    }

    public ElfInitArray getPreInitArray() throws IOException {
        return this.preInitArray == null ? null : this.preInitArray.getValue();
    }

    public ElfSymbolStructure getSymbolStructure() throws IOException {
        return this.symbolStructure.getValue();
    }

    public Collection<MemoizedObject<ElfRelocation>> getRelocations() throws IOException {
        ArrayList<MemoizedObject<ElfRelocation>> list = new ArrayList<MemoizedObject<ElfRelocation>>();
        if (this.androidRelocation != null) {
            for (MemoizedObject<ElfRelocation> elfRelocationMemoizedObject : this.androidRelocation.getValue()) {
                list.add(elfRelocationMemoizedObject);
            }
        }
        if (this.rel != null) {
            Collections.addAll(list, this.rel);
        }
        if (this.pltRel != null) {
            Collections.addAll(list, this.pltRel);
        }
        return list;
    }

    public String toString() {
        return "ElfDynamicStructure[]";
    }
}

