/*
 * Decompiled with CFR 0.152.
 */
package net.fornwall.jelf;

import java.io.IOException;
import net.fornwall.jelf.ElfParser;
import net.fornwall.jelf.ElfSymbol;
import net.fornwall.jelf.ElfSymbolStructure;
import net.fornwall.jelf.HashTable;

class ElfGnuHashTable
implements HashTable {
    private final int nbucket;
    private final int maskwords;
    private final int shift2;
    private final long[] bloom_filters;
    private final int[] buckets;
    private final HashChain chains;
    private final int bloom_mask_bits;

    ElfGnuHashTable(final ElfParser parser, long offset) {
        int i;
        parser.seek(offset);
        this.nbucket = parser.readInt();
        int symndx = parser.readInt();
        int gnu_maskwords_ = parser.readInt();
        this.shift2 = parser.readInt();
        this.bloom_filters = new long[gnu_maskwords_];
        for (i = 0; i < this.bloom_filters.length; ++i) {
            this.bloom_filters[i] = parser.readIntOrLong();
        }
        this.buckets = new int[this.nbucket];
        for (i = 0; i < this.nbucket; ++i) {
            this.buckets[i] = parser.readInt();
        }
        final long chain_base = offset + 16L + (long)gnu_maskwords_ * (long)(parser.elfFile.objectSize == 1 ? 4 : 8) + (long)this.nbucket * 4L - (long)symndx * 4L;
        this.chains = new HashChain(){

            @Override
            public int chain(int index) {
                parser.seek(chain_base + (long)index * 4L);
                return parser.readInt();
            }
        };
        this.maskwords = gnu_maskwords_ - 1;
        this.bloom_mask_bits = parser.elfFile.objectSize == 1 ? 32 : 64;
    }

    @Override
    public ElfSymbol getSymbol(ElfSymbolStructure symbolStructure, String symbolName) throws IOException {
        long h2;
        if (symbolName == null) {
            return null;
        }
        long hash = ElfGnuHashTable.elf_hash(symbolName);
        long word_num = hash / (long)this.bloom_mask_bits & (long)this.maskwords;
        long bloom_word = this.bloom_filters[(int)word_num];
        if ((1L & bloom_word >> (int)(hash % (long)this.bloom_mask_bits) & bloom_word >> (int)((h2 = hash >> this.shift2) % (long)this.bloom_mask_bits)) == 0L) {
            return null;
        }
        int n = this.buckets[(int)(hash % (long)this.nbucket)];
        if (n == 0) {
            return null;
        }
        do {
            ElfSymbol symbol;
            if (!symbolName.equals((symbol = symbolStructure.getELFSymbol(n)).getName())) continue;
            return symbol;
        } while ((this.chains.chain(n++) & 1) == 0);
        return null;
    }

    @Override
    public ElfSymbol findSymbolByAddress(ElfSymbolStructure symbolStructure, long soaddr) throws IOException {
        for (int i = 0; i < this.nbucket; ++i) {
            int n = this.buckets[i];
            if (n == 0) continue;
            do {
                ElfSymbol symbol;
                if (!(symbol = symbolStructure.getELFSymbol(n)).matches(soaddr)) continue;
                return symbol;
            } while ((this.chains.chain(n++) & 1) == 0);
        }
        return null;
    }

    private static long elf_hash(String name) {
        long h = 5381L;
        for (char c : name.toCharArray()) {
            h += (h << 5) + (long)c;
        }
        return h & 0xFFFFFFFFL;
    }

    @Override
    public int getNumBuckets() {
        return this.nbucket;
    }

    private static interface HashChain {
        public int chain(int var1);
    }
}

