/*
 * Decompiled with CFR 0.152.
 */
package net.fornwall.jelf;

import java.io.IOException;
import java.nio.ByteBuffer;
import net.fornwall.jelf.ArmExIdx;
import net.fornwall.jelf.ElfDynamicStructure;
import net.fornwall.jelf.ElfException;
import net.fornwall.jelf.ElfParser;
import net.fornwall.jelf.GnuEhFrameHeader;
import net.fornwall.jelf.MemoizedObject;
import net.fornwall.jelf.PtLoadData;

public class ElfSegment {
    public static final int PT_NULL = 0;
    public static final int PT_LOAD = 1;
    public static final int PT_DYNAMIC = 2;
    public static final int PT_INTERP = 3;
    public static final int PT_NOTE = 4;
    public static final int PT_SHLIB = 5;
    public static final int PT_PHDR = 6;
    public static final int PT_TLS = 7;
    public static final int PT_LOOS = 0x60000000;
    public static final int PT_GNU_EH_FRAME = 1685382480;
    public static final int PT_HIOS = 0x6FFFFFFF;
    public static final int PT_LOPROC = 0x70000000;
    public static final int PT_ARM_EXIDX = 0x70000001;
    public static final int PT_HIPROC = Integer.MAX_VALUE;
    public final int type;
    public final long offset;
    public final long virtual_address;
    public final long physical_address;
    public final long file_size;
    public final long mem_size;
    public final int flags;
    public final long alignment;
    private MemoizedObject<String> ptInterpreter;
    private MemoizedObject<PtLoadData> ptLoad;
    private MemoizedObject<GnuEhFrameHeader> ehFrameHeader;
    private MemoizedObject<ElfDynamicStructure> dynamicStructure;
    private MemoizedObject<ArmExIdx> arm_exidx;
    public static final int PF_R = 4;
    public static final int PF_W = 2;
    public static final int PF_X = 1;

    ElfSegment(final ElfParser parser, long offset) {
        parser.seek(offset);
        if (parser.elfFile.objectSize == 1) {
            this.type = parser.readInt();
            this.offset = parser.readInt();
            this.virtual_address = parser.readInt();
            this.physical_address = parser.readInt();
            this.file_size = parser.readInt();
            this.mem_size = parser.readInt();
            this.flags = parser.readInt();
            this.alignment = parser.readInt();
        } else {
            this.type = parser.readInt();
            this.flags = parser.readInt();
            this.offset = parser.readLong();
            this.virtual_address = parser.readLong();
            this.physical_address = parser.readLong();
            this.file_size = parser.readLong();
            this.mem_size = parser.readLong();
            this.alignment = parser.readLong();
        }
        switch (this.type) {
            case 3: {
                this.ptInterpreter = new MemoizedObject<String>(){

                    @Override
                    protected String computeValue() throws ElfException {
                        short b;
                        parser.seek(ElfSegment.this.offset);
                        StringBuilder buffer = new StringBuilder();
                        while ((b = parser.readUnsignedByte()) != 0) {
                            buffer.append((char)b);
                        }
                        return buffer.toString();
                    }
                };
                break;
            }
            case 1: {
                this.ptLoad = new MemoizedObject<PtLoadData>(){

                    @Override
                    protected PtLoadData computeValue() throws ElfException {
                        parser.seek(ElfSegment.this.offset);
                        ByteBuffer buffer = parser.readBuffer((int)ElfSegment.this.file_size);
                        return new PtLoadData(buffer);
                    }
                };
                break;
            }
            case 2: {
                this.dynamicStructure = new MemoizedObject<ElfDynamicStructure>(){

                    @Override
                    protected ElfDynamicStructure computeValue() throws ElfException, IOException {
                        return new ElfDynamicStructure(parser, parser.virtualMemoryAddrToFileOffset(ElfSegment.this.virtual_address), (int)ElfSegment.this.mem_size);
                    }
                };
                break;
            }
            case 1685382480: {
                this.ehFrameHeader = new MemoizedObject<GnuEhFrameHeader>(){

                    @Override
                    protected GnuEhFrameHeader computeValue() throws ElfException, IOException {
                        return new GnuEhFrameHeader(parser, parser.virtualMemoryAddrToFileOffset(ElfSegment.this.virtual_address), (int)ElfSegment.this.mem_size);
                    }
                };
                break;
            }
            case 0x70000001: {
                this.arm_exidx = new MemoizedObject<ArmExIdx>(){

                    @Override
                    protected ArmExIdx computeValue() throws ElfException {
                        parser.seek(ElfSegment.this.offset);
                        ByteBuffer buffer = parser.readBuffer((int)ElfSegment.this.file_size);
                        return new ArmExIdx(ElfSegment.this.virtual_address, buffer);
                    }
                };
            }
        }
    }

    public String toString() {
        String typeString;
        switch (this.type) {
            case 0: {
                typeString = "PT_NULL";
                break;
            }
            case 1: {
                typeString = "PT_LOAD";
                break;
            }
            case 2: {
                typeString = "PT_DYNAMIC";
                break;
            }
            case 3: {
                typeString = "PT_INTERP";
                break;
            }
            case 4: {
                typeString = "PT_NOTE";
                break;
            }
            case 5: {
                typeString = "PT_SHLIB";
                break;
            }
            case 6: {
                typeString = "PT_PHDR";
                break;
            }
            case 1685382480: {
                typeString = "PT_GNU_EH_FRAME";
                break;
            }
            case 0x70000001: {
                typeString = "PT_ARM_EXIDX";
                break;
            }
            default: {
                typeString = "0x" + Long.toHexString(this.type);
            }
        }
        StringBuilder pFlagsString = new StringBuilder();
        if ((this.flags & 4) != 0) {
            pFlagsString.append("read");
        }
        if ((this.flags & 2) != 0) {
            if (pFlagsString.length() > 0) {
                pFlagsString.append("|");
            }
            pFlagsString.append("write");
        }
        if ((this.flags & 1) != 0) {
            if (pFlagsString.length() > 0) {
                pFlagsString.append("|");
            }
            pFlagsString.append("execute");
        }
        if (pFlagsString.length() == 0) {
            pFlagsString.append("0x").append(Long.toHexString(this.flags));
        }
        return "ElfProgramHeader[p_type=" + typeString + ", p_filesz=" + this.file_size + ", p_memsz=" + this.mem_size + ", p_flags=" + pFlagsString + ", p_align=" + this.alignment + ", range=[0x" + Long.toHexString(this.virtual_address) + "-0x" + Long.toHexString(this.virtual_address + this.mem_size) + "]]";
    }

    public String getInterpreter() throws IOException {
        return this.ptInterpreter == null ? null : this.ptInterpreter.getValue();
    }

    public PtLoadData getPtLoadData() throws IOException {
        return this.ptLoad == null ? null : this.ptLoad.getValue();
    }

    public ElfDynamicStructure getDynamicStructure() throws IOException {
        return this.dynamicStructure == null ? null : this.dynamicStructure.getValue();
    }

    public MemoizedObject<GnuEhFrameHeader> getEhFrameHeader() {
        return this.ehFrameHeader;
    }

    public MemoizedObject<ArmExIdx> getARMExIdxData() {
        return this.arm_exidx;
    }
}

